/*
 * Decompiled with CFR 0.152.
 */
package fr.mod;

import fr.mod.Config;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="solosleeper")
public class ModEvents {
    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.getServer() == null) {
            return;
        }
        ServerLevel overworld = event.getServer().m_129880_(Level.f_46428_);
        if (overworld == null) {
            return;
        }
        if (!overworld.m_46462_()) {
            return;
        }
        long sleepingPlayers = 0L;
        long totalPlayersInOverworld = 0L;
        for (ServerPlayer player : event.getServer().m_6846_().m_11314_()) {
            if (player.m_9236_().m_46472_() != Level.f_46428_) continue;
            ++totalPlayersInOverworld;
            if (!player.m_5803_()) continue;
            ++sleepingPlayers;
        }
        if (totalPlayersInOverworld == 0L || sleepingPlayers == 0L) {
            return;
        }
        double percentSleeping = (double)sleepingPlayers / (double)totalPlayersInOverworld * 100.0;
        if (percentSleeping < (double)Config.minPlayerPercentage) {
            return;
        }
        long extraTicks = (long)((double)sleepingPlayers * Config.multiplierPerPlayer);
        long maxExtraTicks = Config.maxAcceleration - 1;
        if (extraTicks > maxExtraTicks) {
            extraTicks = maxExtraTicks;
        }
        if (extraTicks > 0L) {
            long currentTime = overworld.m_46468_();
            overworld.m_8615_(currentTime + extraTicks);
        }
    }
}

