/*
 * Decompiled with CFR 0.152.
 */
package fr.mod;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="solosleeper", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec.IntValue MIN_PLAYER_PERCENTAGE;
    public static final ForgeConfigSpec.DoubleValue MULTIPLIER_PER_PLAYER;
    public static final ForgeConfigSpec.IntValue MAX_ACCELERATION;
    public static final ForgeConfigSpec.BooleanValue DISPLAY_SLEEP_TITLE;
    public static final ForgeConfigSpec.ConfigValue<String> TITLE_MESSAGE_TEMPLATE;
    public static final ForgeConfigSpec.IntValue TITLE_FADE_IN_TICKS;
    public static final ForgeConfigSpec.IntValue TITLE_STAY_TICKS;
    public static final ForgeConfigSpec.IntValue TITLE_FADE_OUT_TICKS;
    public static final ForgeConfigSpec.BooleanValue TITLE_ONLY_FOR_SLEEPERS;
    public static final ForgeConfigSpec.BooleanValue ALLOW_VANILLA_SKIP;
    public static final ForgeConfigSpec.IntValue SKIP_PERCENTAGE;
    static final ForgeConfigSpec SPEC;
    public static int minPlayerPercentage;
    public static double multiplierPerPlayer;
    public static int maxAcceleration;
    public static boolean displaySleepTitle;
    public static String titleMessageTemplate;
    public static int titleFadeInTicks;
    public static int titleStayTicks;
    public static int titleFadeOutTicks;
    public static boolean titleOnlyForSleepers;
    public static boolean allowVanillaSkip;
    public static int skipPercentage;

    @SubscribeEvent
    static void onLoad(ModConfigEvent.Loading event) {
        if (event.getConfig().getSpec() == SPEC) {
            Config.cacheConfig();
        }
    }

    @SubscribeEvent
    static void onReload(ModConfigEvent.Reloading event) {
        if (event.getConfig().getSpec() == SPEC) {
            Config.cacheConfig();
        }
    }

    private static void cacheConfig() {
        minPlayerPercentage = (Integer)MIN_PLAYER_PERCENTAGE.get();
        multiplierPerPlayer = (Double)MULTIPLIER_PER_PLAYER.get();
        maxAcceleration = (Integer)MAX_ACCELERATION.get();
        displaySleepTitle = (Boolean)DISPLAY_SLEEP_TITLE.get();
        titleMessageTemplate = (String)TITLE_MESSAGE_TEMPLATE.get();
        titleFadeInTicks = (Integer)TITLE_FADE_IN_TICKS.get();
        titleStayTicks = (Integer)TITLE_STAY_TICKS.get();
        titleFadeOutTicks = (Integer)TITLE_FADE_OUT_TICKS.get();
        titleOnlyForSleepers = (Boolean)TITLE_ONLY_FOR_SLEEPERS.get();
        allowVanillaSkip = (Boolean)ALLOW_VANILLA_SKIP.get();
        skipPercentage = (Integer)SKIP_PERCENTAGE.get();
    }

    static {
        BUILDER.push("SoloSleeper Config");
        MIN_PLAYER_PERCENTAGE = BUILDER.comment(new String[]{"Minimum percentage of players (0-100) that must be sleeping for acceleration to start.", "Default: 0 (activates with just 1 player)"}).defineInRange("minPlayerPercentage", 0, 0, 100);
        MULTIPLIER_PER_PLAYER = BUILDER.comment(new String[]{"Number of additional 'ticks' to add PER sleeping player.", "Ex: 1.0 = 1 player adds 1 tick (x2 speed), 2 players add 2 ticks (x3 speed), etc.", "Default: 5.0"}).defineInRange("multiplierPerPlayer", 5.0, 0.0, 100.0);
        MAX_ACCELERATION = BUILDER.comment(new String[]{"MAXIMUM speed multiplier (e.g., 10 = 10x), regardless of the number of players.", "Default: 20"}).defineInRange("maxAcceleration", 20, 1, 200);
        BUILDER.pop().push("Title Notification Config");
        DISPLAY_SLEEP_TITLE = BUILDER.comment(new String[]{"Set to true to display a title/subtitle notification when a player starts sleeping.", "Default: false"}).define("displaySleepTitle", false);
        TITLE_MESSAGE_TEMPLATE = BUILDER.comment(new String[]{"Message template for the title notification. Use placeholders:", "- {sleeping}: number of players sleeping", "- {total}: total number of players in the overworld", "- {speed}: current night acceleration multiplier (e.g., 5x)", "Color codes (e.g., \u00a7c) are supported. Example: '\u00a76{sleeping} / {total} \u00a7fplayers sleeping. Speed: \u00a7b{speed}'"}).define("titleMessageTemplate", (Object)"\u00a76{sleeping} / {total} \u00a7fplayers sleeping. Speed: \u00a7b{speed}");
        TITLE_FADE_IN_TICKS = BUILDER.comment(new String[]{"Duration (in ticks) for the title to fade in (20 ticks = 1 second).", "Default: 10 (0.5s)"}).defineInRange("titleFadeInTicks", 10, 0, 600);
        TITLE_STAY_TICKS = BUILDER.comment(new String[]{"Duration (in ticks) for the title to stay visible.", "Default: 70 (3.5s)"}).defineInRange("titleStayTicks", 70, 0, 600);
        TITLE_FADE_OUT_TICKS = BUILDER.comment(new String[]{"Duration (in ticks) for the title to fade out.", "Default: 20 (1.0s)"}).defineInRange("titleFadeOutTicks", 20, 0, 600);
        TITLE_ONLY_FOR_SLEEPERS = BUILDER.comment(new String[]{"If true, the title notification is only sent to players who are currently sleeping.", "Default: false (sent to all players in the Overworld)"}).define("titleOnlyForSleepers", false);
        BUILDER.pop().push("Vanilla Skip Config");
        ALLOW_VANILLA_SKIP = BUILDER.comment(new String[]{"If true, the night will be skipped instantly when the 'skipPercentage' threshold is met (Vanilla behavior). If false, night acceleration is always used.", "Default: false"}).define("allowVanillaSkip", false);
        SKIP_PERCENTAGE = BUILDER.comment(new String[]{"The percentage of players (0-100) required to skip the night if 'allowVanillaSkip' is true.", "Default: 50 (Vanilla default)"}).defineInRange("skipPercentage", 50, 0, 100);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

