/*
 * Decompiled with CFR 0.152.
 */
package fr.mod;

import fr.mod.Config;
import java.util.ArrayList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="solosleeper")
public class ModEvents {
    private static long lastSleepingPlayersCount = 0L;

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        long maxExtraTicks;
        long extraTicks;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.getServer() == null) {
            return;
        }
        ServerLevel overworld = event.getServer().m_129880_(Level.f_46428_);
        if (overworld == null) {
            return;
        }
        if (!overworld.m_46462_()) {
            lastSleepingPlayersCount = 0L;
            return;
        }
        long sleepingPlayers = 0L;
        long totalPlayersInOverworld = 0L;
        ArrayList<ServerPlayer> playersToNotify = new ArrayList<ServerPlayer>();
        for (ServerPlayer player : event.getServer().m_6846_().m_11314_()) {
            if (player.f_19853_.m_46472_() != Level.f_46428_) continue;
            ++totalPlayersInOverworld;
            if (player.m_5803_()) {
                ++sleepingPlayers;
                if (!Config.titleOnlyForSleepers) continue;
                playersToNotify.add(player);
                continue;
            }
            if (Config.titleOnlyForSleepers) continue;
            playersToNotify.add(player);
        }
        if (!Config.titleOnlyForSleepers) {
            playersToNotify.clear();
            for (ServerPlayer player : event.getServer().m_6846_().m_11314_()) {
                if (player.f_19853_.m_46472_() != Level.f_46428_) continue;
                playersToNotify.add(player);
            }
        }
        if (totalPlayersInOverworld == 0L || sleepingPlayers == 0L) {
            lastSleepingPlayersCount = 0L;
            return;
        }
        double percentSleeping = (double)sleepingPlayers / (double)totalPlayersInOverworld * 100.0;
        if (Config.allowVanillaSkip && percentSleeping >= (double)Config.skipPercentage) {
            lastSleepingPlayersCount = sleepingPlayers;
            return;
        }
        if (percentSleeping < (double)Config.minPlayerPercentage) {
            lastSleepingPlayersCount = sleepingPlayers;
            return;
        }
        if (Config.displaySleepTitle && sleepingPlayers > lastSleepingPlayersCount && sleepingPlayers > 0L) {
            extraTicks = (long)((double)sleepingPlayers * Config.multiplierPerPlayer);
            maxExtraTicks = Config.maxAcceleration - 1;
            if (extraTicks > maxExtraTicks) {
                extraTicks = maxExtraTicks;
            }
            long speedMultiplier = extraTicks + 1L;
            String rawMessage = Config.titleMessageTemplate.replace("{sleeping}", String.valueOf(sleepingPlayers)).replace("{total}", String.valueOf(totalPlayersInOverworld)).replace("{speed}", speedMultiplier + "x");
            MutableComponent titleComponent = Component.m_237113_((String)"");
            MutableComponent subtitleComponent = Component.m_237113_((String)rawMessage);
            ClientboundSetTitlesAnimationPacket animationPacket = new ClientboundSetTitlesAnimationPacket(Config.titleFadeInTicks, Config.titleStayTicks, Config.titleFadeOutTicks);
            for (ServerPlayer player : playersToNotify) {
                if (player.f_19853_.m_46472_() != Level.f_46428_) continue;
                player.f_8906_.m_9829_((Packet)animationPacket);
                player.f_8906_.m_9829_((Packet)new ClientboundSetTitleTextPacket((Component)titleComponent));
                player.f_8906_.m_9829_((Packet)new ClientboundSetSubtitleTextPacket((Component)subtitleComponent));
            }
        }
        lastSleepingPlayersCount = sleepingPlayers;
        extraTicks = (long)((double)sleepingPlayers * Config.multiplierPerPlayer);
        maxExtraTicks = Config.maxAcceleration - 1;
        if (extraTicks > maxExtraTicks) {
            extraTicks = maxExtraTicks;
        }
        if (extraTicks > 0L) {
            long currentTime = overworld.m_46468_();
            overworld.m_8615_(currentTime + extraTicks);
        }
    }
}

