/*
 * Decompiled with CFR 0.152.
 */
package lol.ysmu.biomeEffects;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lol.ysmu.biomeEffects.commands.BiomeEffectsCommand;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public final class BiomeEffects
extends JavaPlugin {
    private boolean effectPermanent;
    private final Map<UUID, String> lastBiomeMap = new HashMap<UUID, String>();

    public String getLastBiome(UUID uuid) {
        return this.lastBiomeMap.getOrDefault(uuid, "None");
    }

    public void setLastBiome(UUID uuid, String biome) {
        this.lastBiomeMap.put(uuid, biome);
    }

    public String getBiomeMessage(String biomeName) {
        if (this.getConfig().contains("biomes." + biomeName + ".message")) {
            return this.getConfig().getString("biomes." + biomeName + ".message");
        }
        return null;
    }

    public void onEnable() {
        this.saveDefaultConfig();
        this.effectPermanent = this.getConfig().getBoolean("effect_permanent", true);
        BiomeEffectsCommand command = new BiomeEffectsCommand(this);
        this.getCommand("biomeeffects").setExecutor((CommandExecutor)command);
        this.getCommand("biomeeffects").setTabCompleter((TabCompleter)command);
        this.getCommand("bf").setExecutor((CommandExecutor)command);
        this.getCommand("bf").setTabCompleter((TabCompleter)command);
        new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    String lastBiome;
                    String currentBiome = player.getLocation().getBlock().getBiome().name();
                    if (!currentBiome.equals(lastBiome = BiomeEffects.this.getLastBiome(player.getUniqueId()))) {
                        BiomeEffects.this.setLastBiome(player.getUniqueId(), currentBiome);
                        if (BiomeEffects.this.getConfig().contains("biomes." + currentBiome)) {
                            BiomeEffects.this.applyEffects(player, currentBiome);
                        } else {
                            BiomeEffects.this.removeEffects(player);
                        }
                    }
                    if (!BiomeEffects.this.effectPermanent || !BiomeEffects.this.getConfig().contains("biomes." + currentBiome)) continue;
                    BiomeEffects.this.applyEffects(player, currentBiome);
                }
            }
        }.runTaskTimer((Plugin)this, 0L, 20L);
    }

    private void applyEffects(Player player, String biomeName) {
        ConfigurationSection section = this.getConfig().getConfigurationSection("biomes." + biomeName);
        String message = this.getBiomeMessage(biomeName);
        if (message != null && !player.hasMetadata("BiomeEffects_" + biomeName)) {
            player.sendMessage(message.replace("&", "\u00a7"));
            player.setMetadata("BiomeEffects_" + biomeName, (MetadataValue)new FixedMetadataValue((Plugin)this, (Object)true));
        }
        for (String effectLine : section.getStringList("effects")) {
            String[] parts = effectLine.split(":");
            PotionEffectType type = PotionEffectType.getByName((String)parts[0]);
            if (type == null) continue;
            int duration = Integer.parseInt(parts[1]);
            int amplifier = Integer.parseInt(parts[2]) - 1;
            player.addPotionEffect(new PotionEffect(type, duration * 20, amplifier), true);
        }
    }

    private void removeEffects(Player player) {
        for (PotionEffect effect : player.getActivePotionEffects()) {
            String typeName = effect.getType().getName();
            for (String biome : this.getConfig().getConfigurationSection("biomes").getKeys(false)) {
                List effects = this.getConfig().getStringList("biomes." + biome + ".effects");
                for (String line : effects) {
                    if (!line.startsWith(typeName + ":")) continue;
                    player.removePotionEffect(effect.getType());
                }
            }
        }
        for (String biome : this.getConfig().getConfigurationSection("biomes").getKeys(false)) {
            if (!player.hasMetadata("BiomeEffects_" + biome)) continue;
            player.removeMetadata("BiomeEffects_" + biome, (Plugin)this);
        }
    }

    public void onDisable() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.removeEffects(player);
        }
    }
}

