/*
 * Decompiled with CFR 0.152.
 */
package lol.ysmu.biomeEffects.listeners;

import java.util.List;
import lol.ysmu.biomeEffects.BiomeEffects;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Biome;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class BiomeListener
implements Listener {
    private final BiomeEffects plugin;

    public BiomeListener(BiomeEffects plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Biome toBiome;
        Player player = event.getPlayer();
        Location from = event.getFrom();
        Location to = event.getTo();
        if (to == null) {
            return;
        }
        if (from.getBlockX() == to.getBlockX() && from.getBlockZ() == to.getBlockZ()) {
            return;
        }
        Biome fromBiome = from.getBlock().getBiome();
        if (fromBiome == (toBiome = to.getBlock().getBiome())) {
            return;
        }
        this.plugin.getBiomeMessage(player.getLocation().getBlock().getBiome().name());
        this.applyBiomeEffects(player, toBiome);
    }

    private void applyBiomeEffects(Player player, Biome biome) {
        String biomePath = "biomes." + biome.name();
        if (!this.plugin.getConfig().isConfigurationSection(biomePath)) {
            return;
        }
        List effects = this.plugin.getConfig().getStringList(biomePath + ".effects");
        List commands = this.plugin.getConfig().getStringList(biomePath + ".commands");
        String message = this.plugin.getConfig().getString(biomePath + ".message");
        if (message != null && !message.isEmpty()) {
            player.sendMessage(message.replace("&", "\u00a7"));
        }
        for (String effectEntry : effects) {
            try {
                String[] parts = effectEntry.split(":");
                PotionEffectType type = PotionEffectType.getByName((String)parts[0].toUpperCase());
                int durationSeconds = Integer.parseInt(parts[1]);
                int amplifierLevel = Integer.parseInt(parts[2]) - 1;
                if (amplifierLevel < 0) {
                    amplifierLevel = 0;
                }
                if (type == null) continue;
                player.addPotionEffect(new PotionEffect(type, durationSeconds * 20, amplifierLevel));
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Invalid effect format in config for biome " + biome.name() + ": " + effectEntry);
            }
        }
        for (String cmd : commands) {
            String parsed = cmd.replace("[player]", player.getName());
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)parsed);
        }
    }
}

