/*
 * Decompiled with CFR 0.152.
 */
package lol.ysmu.biomeEffects.placeholders;

import java.util.stream.Collectors;
import lol.ysmu.biomeEffects.BiomeEffects;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.entity.Player;

public class PAPIExpansion
extends PlaceholderExpansion {
    private final BiomeEffects plugin;

    public PAPIExpansion(BiomeEffects plugin) {
        this.plugin = plugin;
    }

    public String getIdentifier() {
        return "biomeeffects";
    }

    public String getAuthor() {
        return this.plugin.getDescription().getAuthors().toString();
    }

    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }

    public String onPlaceholderRequest(Player player, String identifier) {
        if (player == null) {
            return "";
        }
        switch (identifier.toLowerCase()) {
            case "current_biome": {
                return player.getLocation().getBlock().getBiome().name();
            }
            case "current_biome_name": {
                String biome = player.getLocation().getBlock().getBiome().name().toLowerCase().replace("_", " ");
                return this.capitalize(biome);
            }
            case "last_biome": {
                return this.plugin.getLastBiome(player.getUniqueId());
            }
            case "biome_message": {
                return this.plugin.getBiomeMessage(player.getLocation().getBlock().getBiome().name());
            }
            case "active_effects": {
                String effects = player.getActivePotionEffects().stream().map(e -> e.getType().getName()).collect(Collectors.joining(", "));
                return effects.isEmpty() ? "None" : effects;
            }
            case "effect_count": {
                return String.valueOf(player.getActivePotionEffects().size());
            }
        }
        return null;
    }

    private String capitalize(String str) {
        String[] words = str.split(" ");
        StringBuilder sb = new StringBuilder();
        for (String w : words) {
            if (w.length() <= 0) continue;
            sb.append(Character.toUpperCase(w.charAt(0))).append(w.substring(1)).append(" ");
        }
        return sb.toString().trim();
    }
}

