/*
 * Decompiled with CFR 0.152.
 */
package lol.ysmu.biomeEffects;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lol.ysmu.biomeEffects.GUIs.GUIListener;
import lol.ysmu.biomeEffects.GUIs.GUIState;
import lol.ysmu.biomeEffects.UpdateChecker;
import lol.ysmu.biomeEffects.commands.BiomeEffectsCommand;
import lol.ysmu.biomeEffects.placeholders.PAPIExpansion;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public final class BiomeEffects
extends JavaPlugin {
    private boolean effectPermanent;
    private final Map<UUID, String> lastBiomeMap = new HashMap<UUID, String>();
    private final Map<UUID, GUIState> playerGUIStates = new HashMap<UUID, GUIState>();
    private UpdateChecker updateChecker;

    public String getLastBiome(UUID uuid) {
        return this.lastBiomeMap.getOrDefault(uuid, "None");
    }

    public void setLastBiome(UUID uuid, String biome) {
        this.lastBiomeMap.put(uuid, biome);
    }

    public GUIState getGUIState(UUID uuid) {
        return this.playerGUIStates.get(uuid);
    }

    public void setGUIState(UUID uuid, GUIState state) {
        this.playerGUIStates.put(uuid, state);
    }

    public void removeGUIState(UUID uuid) {
        this.playerGUIStates.remove(uuid);
    }

    public String getBiomeMessage(String biomeName) {
        if (this.getConfig().contains("biomes." + biomeName + ".message")) {
            return this.getConfig().getString("biomes." + biomeName + ".message");
        }
        return null;
    }

    public void onEnable() {
        this.saveDefaultConfig();
        this.effectPermanent = this.getConfig().getBoolean("effect_permanent", true);
        this.updateChecker = new UpdateChecker(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.updateChecker, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new GUIListener(this), (Plugin)this);
        BiomeEffectsCommand command = new BiomeEffectsCommand(this);
        this.getCommand("biomeeffects").setExecutor((CommandExecutor)command);
        this.getCommand("biomeeffects").setTabCompleter((TabCompleter)command);
        this.getCommand("bf").setExecutor((CommandExecutor)command);
        this.getCommand("bf").setTabCompleter((TabCompleter)command);
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new PAPIExpansion(this).register();
            this.getLogger().info("PlaceholderAPI expansion registered!");
        }
        this.startBiomeChecker();
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> this.updateChecker.checkForUpdates(), 100L);
        this.getLogger().info("BiomeEffects v" + this.getDescription().getVersion() + " has been enabled!");
    }

    private void startBiomeChecker() {
        new BukkitRunnable(){

            public void run() {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    BiomeEffects.this.checkPlayerBiome(player);
                }
            }
        }.runTaskTimer((Plugin)this, 0L, 20L);
    }

    private void checkPlayerBiome(Player player) {
        String lastBiome;
        String currentBiome = player.getLocation().getBlock().getBiome().name();
        if (!currentBiome.equals(lastBiome = this.getLastBiome(player.getUniqueId()))) {
            this.setLastBiome(player.getUniqueId(), currentBiome);
            if (this.getConfig().contains("biomes." + currentBiome)) {
                this.applyEffects(player, currentBiome);
            } else {
                this.removeEffects(player);
            }
        } else if (this.effectPermanent && this.getConfig().contains("biomes." + currentBiome)) {
            this.applyEffects(player, currentBiome);
        }
    }

    private void applyEffects(Player player, String biomeName) {
        ConfigurationSection section = this.getConfig().getConfigurationSection("biomes." + biomeName);
        String message = this.getBiomeMessage(biomeName);
        if (message != null && !player.hasMetadata("BiomeEffects_" + biomeName)) {
            player.sendMessage(message.replace("&", "\u00a7"));
            player.setMetadata("BiomeEffects_" + biomeName, (MetadataValue)new FixedMetadataValue((Plugin)this, (Object)true));
        }
        for (String effectLine : section.getStringList("effects")) {
            String[] parts = effectLine.split(":");
            PotionEffectType type = PotionEffectType.getByName((String)parts[0]);
            if (type == null) continue;
            int duration = Integer.parseInt(parts[1]);
            int amplifier = Integer.parseInt(parts[2]) - 1;
            player.addPotionEffect(new PotionEffect(type, duration * 20, amplifier), true);
        }
        for (String command : section.getStringList("commands")) {
            String parsed = command.replace("[player]", player.getName());
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)parsed);
        }
    }

    private void removeEffects(Player player) {
        for (PotionEffect effect : player.getActivePotionEffects()) {
            String typeName = effect.getType().getName();
            for (String biome : this.getConfig().getConfigurationSection("biomes").getKeys(false)) {
                List effects = this.getConfig().getStringList("biomes." + biome + ".effects");
                for (String line : effects) {
                    if (!line.startsWith(typeName + ":")) continue;
                    player.removePotionEffect(effect.getType());
                }
            }
        }
        for (String biome : this.getConfig().getConfigurationSection("biomes").getKeys(false)) {
            if (!player.hasMetadata("BiomeEffects_" + biome)) continue;
            player.removeMetadata("BiomeEffects_" + biome, (Plugin)this);
        }
    }

    public void onDisable() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.removeEffects(player);
        }
    }

    public void saveAndReloadConfig() {
        this.saveConfig();
        this.reloadConfig();
        this.effectPermanent = this.getConfig().getBoolean("effect_permanent", true);
    }

    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }
}

