/*
 * Decompiled with CFR 0.152.
 */
package lol.ysmu.biomeEffects.GUIs;

import java.util.Arrays;
import java.util.List;
import lol.ysmu.biomeEffects.BiomeEffects;
import lol.ysmu.biomeEffects.GUIs.GUIManager;
import lol.ysmu.biomeEffects.GUIs.GUIState;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class GUIListener
implements Listener {
    private final BiomeEffects plugin;
    private final GUIManager guiManager;

    public GUIListener(BiomeEffects plugin) {
        this.plugin = plugin;
        this.guiManager = new GUIManager(plugin);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        Inventory inventory = event.getInventory();
        ItemStack item = event.getCurrentItem();
        String title = event.getView().getTitle();
        if (this.isBiomeEffectsGUI(title)) {
            event.setCancelled(true);
            if (item == null || item.getType() == Material.AIR) {
                return;
            }
            this.handleGUIClick(player, title, item, event.getSlot());
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        String title = event.getView().getTitle();
        if (this.isBiomeEffectsGUI(title)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        GUIState state = this.plugin.getGUIState(player.getUniqueId());
        if (state == null) {
            return;
        }
        event.setCancelled(true);
        String message = event.getMessage();
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.handleChatInput(player, state, message));
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        Player player = (Player)event.getPlayer();
        String title = event.getView().getTitle();
        GUIState state = this.plugin.getGUIState(player.getUniqueId());
        if (state != null && !this.isWaitingForChatInput(state)) {
            this.plugin.removeGUIState(player.getUniqueId());
        }
    }

    private boolean isBiomeEffectsGUI(String title) {
        return title.equals("BiomeEffects Config") || title.startsWith("Editing: ") || title.startsWith("Effects: ") || title.startsWith("Commands: ");
    }

    private boolean isWaitingForChatInput(GUIState state) {
        return state.getEditingField() != null || state.getCurrentBiome().equals("global") || state.getCurrentBiome().equals("new_biome");
    }

    private void handleGUIClick(Player player, String title, ItemStack item, int slot) {
        if (title.equals("BiomeEffects Config")) {
            this.handleMainMenuClick(player, item);
        } else if (title.startsWith("Editing: ")) {
            String biome = title.substring(9);
            this.handleBiomeEditorClick(player, biome, item);
        } else if (title.startsWith("Effects: ")) {
            String biome = title.substring(9);
            this.handleEffectsEditorClick(player, biome, item, slot);
        } else if (title.startsWith("Commands: ")) {
            String biome = title.substring(10);
            this.handleCommandsEditorClick(player, biome, item, slot);
        }
    }

    private void handleMainMenuClick(Player player, ItemStack item) {
        if (item.getType() == Material.GRASS_BLOCK) {
            String biome = ChatColor.stripColor((String)item.getItemMeta().getDisplayName());
            this.guiManager.openBiomeEditor(player, biome);
        } else if (item.getType() == Material.REDSTONE_TORCH) {
            this.plugin.setGUIState(player.getUniqueId(), new GUIState("global"));
            player.closeInventory();
            player.sendMessage("\u00a7aPlease type the new value for \u00a7eeffect_permanent\u00a7a (true/false):");
            player.sendMessage("\u00a77Current: " + this.plugin.getConfig().getBoolean("effect_permanent"));
        } else if (item.getType() == Material.EMERALD && item.getItemMeta().getDisplayName().contains("Add New Biome")) {
            this.plugin.setGUIState(player.getUniqueId(), new GUIState("new_biome"));
            player.closeInventory();
            player.sendMessage("\u00a7aPlease type the name of the new biome:");
        } else if (item.getType() == Material.ARROW) {
            player.closeInventory();
        }
    }

    private void handleBiomeEditorClick(Player player, String biome, ItemStack item) {
        if (item.getType() == Material.OAK_SIGN) {
            GUIState state = new GUIState(biome);
            state.setEditingField("message");
            this.plugin.setGUIState(player.getUniqueId(), state);
            player.closeInventory();
            player.sendMessage("\u00a7aPlease type the new message for biome \u00a7e" + biome + "\u00a7a:");
            player.sendMessage("\u00a77Use & for color codes");
            player.sendMessage("\u00a77Current: " + this.plugin.getConfig().getString("biomes." + biome + ".message", "Not set"));
        } else if (item.getType() == Material.POTION) {
            this.guiManager.openEffectsEditor(player, biome);
        } else if (item.getType() == Material.COMMAND_BLOCK) {
            this.guiManager.openCommandsEditor(player, biome);
        } else if (item.getType() == Material.BARRIER) {
            this.plugin.getConfig().set("biomes." + biome, null);
            this.plugin.saveAndReloadConfig();
            player.sendMessage("\u00a7aBiome \u00a7e" + biome + " \u00a7ahas been deleted.");
            this.guiManager.openMainMenu(player);
        } else if (item.getType() == Material.ARROW) {
            this.guiManager.openMainMenu(player);
        }
    }

    private void handleEffectsEditorClick(Player player, String biome, ItemStack item, int slot) {
        GUIState state = this.plugin.getGUIState(player.getUniqueId());
        if (item.getType() == Material.POTION) {
            String displayName = ChatColor.stripColor((String)item.getItemMeta().getDisplayName());
            int index = Integer.parseInt(displayName.split("#")[1]) - 1;
            state.setEffectIndex(index);
            this.plugin.setGUIState(player.getUniqueId(), state);
            player.closeInventory();
            player.sendMessage("\u00a7aPlease type the new effect for \u00a7e" + biome + "\u00a7a:");
            player.sendMessage("\u00a77Format: EFFECT:DURATION:AMPLIFIER");
            player.sendMessage("\u00a77Example: SPEED:10:1");
            List effects = this.plugin.getConfig().getStringList("biomes." + biome + ".effects");
            player.sendMessage("\u00a77Current: " + (String)effects.get(index));
        } else if (item.getType() == Material.EMERALD) {
            state.setEffectIndex(-1);
            this.plugin.setGUIState(player.getUniqueId(), state);
            player.closeInventory();
            player.sendMessage("\u00a7aPlease type the new effect for \u00a7e" + biome + "\u00a7a:");
            player.sendMessage("\u00a77Format: EFFECT:DURATION:AMPLIFIER");
            player.sendMessage("\u00a77Example: SPEED:10:1");
        } else if (item.getType() == Material.ARROW) {
            this.guiManager.openBiomeEditor(player, biome);
        }
    }

    private void handleCommandsEditorClick(Player player, String biome, ItemStack item, int slot) {
        GUIState state = this.plugin.getGUIState(player.getUniqueId());
        if (item.getType() == Material.COMMAND_BLOCK) {
            String displayName = ChatColor.stripColor((String)item.getItemMeta().getDisplayName());
            int index = Integer.parseInt(displayName.split("#")[1]) - 1;
            state.setCommandIndex(index);
            this.plugin.setGUIState(player.getUniqueId(), state);
            player.closeInventory();
            player.sendMessage("\u00a7aPlease type the new command for \u00a7e" + biome + "\u00a7a:");
            player.sendMessage("\u00a77Use [player] to target the player");
            List commands = this.plugin.getConfig().getStringList("biomes." + biome + ".commands");
            player.sendMessage("\u00a77Current: " + (String)commands.get(index));
        } else if (item.getType() == Material.EMERALD) {
            state.setCommandIndex(-1);
            this.plugin.setGUIState(player.getUniqueId(), state);
            player.closeInventory();
            player.sendMessage("\u00a7aPlease type the new command for \u00a7e" + biome + "\u00a7a:");
            player.sendMessage("\u00a77Use [player] to target the player");
            player.sendMessage("\u00a77Example: give [player] diamond 1");
        } else if (item.getType() == Material.ARROW) {
            this.guiManager.openBiomeEditor(player, biome);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleChatInput(Player player, GUIState state, String message) {
        if (state.getCurrentBiome().equals("global")) {
            if (!message.equalsIgnoreCase("true") && !message.equalsIgnoreCase("false")) {
                player.sendMessage("\u00a7cInvalid value! Please enter 'true' or 'false'.");
                return;
            }
            this.plugin.getConfig().set("effect_permanent", (Object)Boolean.parseBoolean(message.toLowerCase()));
            this.plugin.saveAndReloadConfig();
            player.sendMessage("\u00a7aGlobal setting updated! effect_permanent = " + message.toLowerCase());
            this.guiManager.openMainMenu(player);
        } else if (state.getCurrentBiome().equals("new_biome")) {
            String biome = message.toUpperCase();
            if (!this.plugin.getConfig().contains("biomes." + biome)) {
                this.plugin.getConfig().set("biomes." + biome + ".message", (Object)("&aYou entered the " + biome));
                this.plugin.getConfig().set("biomes." + biome + ".effects", Arrays.asList(new Object[0]));
                this.plugin.getConfig().set("biomes." + biome + ".commands", Arrays.asList(new Object[0]));
                this.plugin.saveAndReloadConfig();
                player.sendMessage("\u00a7aNew biome \u00a7e" + biome + " \u00a7aadded!");
                this.guiManager.openBiomeEditor(player, biome);
            } else {
                player.sendMessage("\u00a7cBiome \u00a7e" + biome + " \u00a7calready exists!");
                this.guiManager.openMainMenu(player);
            }
        } else if (state.getEditingField().equals("message")) {
            this.plugin.getConfig().set("biomes." + state.getCurrentBiome() + ".message", (Object)message);
            this.plugin.saveAndReloadConfig();
            player.sendMessage("\u00a7aMessage updated for biome \u00a7e" + state.getCurrentBiome() + "\u00a7a!");
            this.guiManager.openBiomeEditor(player, state.getCurrentBiome());
        } else if (state.getEditingField().equals("effects")) {
            List effects = this.plugin.getConfig().getStringList("biomes." + state.getCurrentBiome() + ".effects");
            if (state.getEffectIndex() == -1) {
                effects.add(message);
                player.sendMessage("\u00a7aNew effect added to biome \u00a7e" + state.getCurrentBiome() + "\u00a7a!");
            } else {
                effects.set(state.getEffectIndex(), message);
                player.sendMessage("\u00a7aEffect updated for biome \u00a7e" + state.getCurrentBiome() + "\u00a7a!");
            }
            this.plugin.getConfig().set("biomes." + state.getCurrentBiome() + ".effects", (Object)effects);
            this.plugin.saveAndReloadConfig();
            this.guiManager.openEffectsEditor(player, state.getCurrentBiome());
        } else if (state.getEditingField().equals("commands")) {
            List commands = this.plugin.getConfig().getStringList("biomes." + state.getCurrentBiome() + ".commands");
            if (state.getCommandIndex() == -1) {
                commands.add(message);
                player.sendMessage("\u00a7aNew command added to biome \u00a7e" + state.getCurrentBiome() + "\u00a7a!");
            } else {
                commands.set(state.getCommandIndex(), message);
                player.sendMessage("\u00a7aCommand updated for biome \u00a7e" + state.getCurrentBiome() + "\u00a7a!");
            }
            this.plugin.getConfig().set("biomes." + state.getCurrentBiome() + ".commands", (Object)commands);
            this.plugin.saveAndReloadConfig();
            this.guiManager.openCommandsEditor(player, state.getCurrentBiome());
        }
        this.plugin.removeGUIState(player.getUniqueId());
    }
}

