/*
 * Decompiled with CFR 0.152.
 */
package lol.ysmu.biomeEffects.GUIs;

import java.util.Arrays;
import java.util.List;
import lol.ysmu.biomeEffects.BiomeEffects;
import lol.ysmu.biomeEffects.GUIs.GUIState;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class GUIManager {
    private final BiomeEffects plugin;

    public GUIManager(BiomeEffects plugin) {
        this.plugin = plugin;
    }

    public void openMainMenu(Player player) {
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)"BiomeEffects Config");
        ItemStack globalSettings = this.createItem(Material.REDSTONE_TORCH, "&6Global Settings", Arrays.asList("&7Click to edit global plugin settings", "", "&eCurrent effect_permanent: &f" + this.plugin.getConfig().getBoolean("effect_permanent"), "", "&aClick to edit"));
        gui.setItem(0, globalSettings);
        int slot = 9;
        if (this.plugin.getConfig().contains("biomes")) {
            for (String biome : this.plugin.getConfig().getConfigurationSection("biomes").getKeys(false)) {
                ItemStack biomeItem = this.createItem(Material.GRASS_BLOCK, "&a" + biome, Arrays.asList("&7Click to edit this biome's settings", "", "&eMessage: &f" + this.plugin.getConfig().getString("biomes." + biome + ".message", "Not set"), "&eEffects: &f" + this.plugin.getConfig().getStringList("biomes." + biome + ".effects").size(), "&eCommands: &f" + this.plugin.getConfig().getStringList("biomes." + biome + ".commands").size(), "", "&aClick to edit"));
                gui.setItem(slot++, biomeItem);
            }
        }
        ItemStack addBiome = this.createItem(Material.EMERALD, "&aAdd New Biome", Arrays.asList("&7Click to add a new biome configuration", "", "&aClick to add"));
        gui.setItem(53, addBiome);
        player.openInventory(gui);
    }

    public void openBiomeEditor(Player player, String biome) {
        Inventory gui = Bukkit.createInventory(null, (int)36, (String)("Editing: " + biome));
        this.plugin.setGUIState(player.getUniqueId(), new GUIState(biome));
        String currentMessage = this.plugin.getConfig().getString("biomes." + biome + ".message", "Not set");
        ItemStack messageItem = this.createItem(Material.OAK_SIGN, "&6Message", Arrays.asList("&7Current: &f" + currentMessage, "", "&eClick to edit message"));
        gui.setItem(10, messageItem);
        List effects = this.plugin.getConfig().getStringList("biomes." + biome + ".effects");
        ItemStack effectsItem = this.createItem(Material.POTION, "&bEffects", Arrays.asList("&7Current effects: &f" + effects.size(), "", "&eClick to manage effects", "&7Format: EFFECT:DURATION:AMPLIFIER", "&7Example: SPEED:10:1"));
        gui.setItem(12, effectsItem);
        List commands = this.plugin.getConfig().getStringList("biomes." + biome + ".commands");
        ItemStack commandsItem = this.createItem(Material.COMMAND_BLOCK, "&cCommands", Arrays.asList("&7Current commands: &f" + commands.size(), "", "&eClick to manage commands", "&7Use [player] to target the player"));
        gui.setItem(14, commandsItem);
        ItemStack deleteItem = this.createItem(Material.BARRIER, "&4Delete Biome", Arrays.asList("&7Click to delete this biome configuration", "", "&cThis cannot be undone!", "", "&eClick to delete"));
        gui.setItem(16, deleteItem);
        ItemStack backItem = this.createItem(Material.ARROW, "&fBack to Main Menu", Arrays.asList("&7Click to return to main menu"));
        gui.setItem(31, backItem);
        player.openInventory(gui);
    }

    public void openEffectsEditor(Player player, String biome) {
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)("Effects: " + biome));
        GUIState state = new GUIState(biome);
        state.setEditingField("effects");
        this.plugin.setGUIState(player.getUniqueId(), state);
        List effects = this.plugin.getConfig().getStringList("biomes." + biome + ".effects");
        int slot = 0;
        for (int i = 0; i < effects.size(); ++i) {
            String effect = (String)effects.get(i);
            ItemStack effectItem = this.createItem(Material.POTION, "&bEffect #" + (i + 1), Arrays.asList("&7" + effect, "", "&eClick to edit", "&cRight-click to delete"));
            gui.setItem(slot++, effectItem);
        }
        ItemStack addEffect = this.createItem(Material.EMERALD, "&aAdd New Effect", Arrays.asList("&7Click to add a new effect", "", "&7Format: EFFECT:DURATION:AMPLIFIER", "&7Example: SPEED:10:1", "", "&aClick to add"));
        gui.setItem(53, addEffect);
        ItemStack backItem = this.createItem(Material.ARROW, "&fBack to Biome Editor", Arrays.asList("&7Click to return to biome editor"));
        gui.setItem(45, backItem);
        player.openInventory(gui);
    }

    public void openCommandsEditor(Player player, String biome) {
        Inventory gui = Bukkit.createInventory(null, (int)54, (String)("Commands: " + biome));
        GUIState state = new GUIState(biome);
        state.setEditingField("commands");
        this.plugin.setGUIState(player.getUniqueId(), state);
        List commands = this.plugin.getConfig().getStringList("biomes." + biome + ".commands");
        int slot = 0;
        for (int i = 0; i < commands.size(); ++i) {
            String command = (String)commands.get(i);
            ItemStack commandItem = this.createItem(Material.COMMAND_BLOCK, "&cCommand #" + (i + 1), Arrays.asList("&7" + command, "", "&eClick to edit", "&cRight-click to delete"));
            gui.setItem(slot++, commandItem);
        }
        ItemStack addCommand = this.createItem(Material.EMERALD, "&aAdd New Command", Arrays.asList("&7Click to add a new command", "", "&7Use [player] to target the player", "&7Example: give [player] diamond 1", "", "&aClick to add"));
        gui.setItem(53, addCommand);
        ItemStack backItem = this.createItem(Material.ARROW, "&fBack to Biome Editor", Arrays.asList("&7Click to return to biome editor"));
        gui.setItem(45, backItem);
        player.openInventory(gui);
    }

    private ItemStack createItem(Material material, String name, List<String> lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)name));
        List<String> coloredLore = lore.stream().map(line -> ChatColor.translateAlternateColorCodes((char)'&', (String)line)).toList();
        meta.setLore(coloredLore);
        item.setItemMeta(meta);
        return item;
    }
}

