/*
 * Decompiled with CFR 0.152.
 */
package lol.ysmu.biomeEffects;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import lol.ysmu.biomeEffects.BiomeEffects;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.json.JSONObject;

public class UpdateChecker
implements Listener {
    private final BiomeEffects plugin;
    private String latestVersion;
    private boolean updateAvailable = false;
    private static final String MODRINTH_API_URL = "https://api.modrinth.com/v2/project/biomeeffects/version";

    public UpdateChecker(BiomeEffects plugin) {
        this.plugin = plugin;
    }

    public void checkForUpdates() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                URL url = new URL(MODRINTH_API_URL);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("User-Agent", "BiomeEffects/" + this.plugin.getDescription().getVersion());
                connection.setConnectTimeout(10000);
                connection.setReadTimeout(10000);
                int responseCode = connection.getResponseCode();
                if (responseCode == 200) {
                    String inputLine;
                    BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    StringBuilder content = new StringBuilder();
                    while ((inputLine = in.readLine()) != null) {
                        content.append(inputLine);
                    }
                    in.close();
                    String jsonResponse = content.toString();
                    if (jsonResponse.startsWith("[")) {
                        jsonResponse = jsonResponse.substring(1, jsonResponse.indexOf("]"));
                    }
                    JSONObject versionData = new JSONObject(jsonResponse);
                    this.latestVersion = versionData.getString("version_number");
                    String currentVersion = this.plugin.getDescription().getVersion();
                    if (this.isNewerVersion(this.latestVersion, currentVersion)) {
                        this.updateAvailable = true;
                        this.plugin.getLogger().info("A new version of BiomeEffects is available: " + this.latestVersion);
                        this.plugin.getLogger().info("Download it from: https://modrinth.com/plugin/biomeeffects");
                    } else {
                        this.plugin.getLogger().info("BiomeEffects is up to date!");
                    }
                } else {
                    this.plugin.getLogger().warning("Failed to check for updates. HTTP response: " + responseCode);
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Could not check for updates: " + e.getMessage());
            }
        });
    }

    private boolean isNewerVersion(String latest, String current) {
        try {
            String[] latestParts = latest.split("\\.");
            String[] currentParts = current.split("\\.");
            for (int i = 0; i < Math.max(latestParts.length, currentParts.length); ++i) {
                int currentPart;
                int latestPart = i < latestParts.length ? Integer.parseInt(latestParts[i]) : 0;
                int n = currentPart = i < currentParts.length ? Integer.parseInt(currentParts[i]) : 0;
                if (latestPart > currentPart) {
                    return true;
                }
                if (latestPart >= currentPart) continue;
                return false;
            }
            return false;
        }
        catch (NumberFormatException e) {
            return !latest.equals(current);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.updateAvailable && player.hasPermission("biomeeffects.admin")) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                player.sendMessage(String.valueOf(ChatColor.GOLD) + "\u26a0 " + String.valueOf(ChatColor.YELLOW) + "A new version of " + String.valueOf(ChatColor.GREEN) + "BiomeEffects" + String.valueOf(ChatColor.YELLOW) + " is available!");
                player.sendMessage(String.valueOf(ChatColor.GRAY) + "Current: " + String.valueOf(ChatColor.RED) + this.plugin.getDescription().getVersion() + String.valueOf(ChatColor.GRAY) + " \u2192 Latest: " + String.valueOf(ChatColor.GREEN) + this.latestVersion);
                player.sendMessage(String.valueOf(ChatColor.BLUE) + "Download: " + String.valueOf(ChatColor.AQUA) + "https://modrinth.com/plugin/biomeeffects");
            }, 40L);
        }
    }

    public boolean isUpdateAvailable() {
        return this.updateAvailable;
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }
}

