/*
 * Decompiled with CFR 0.152.
 */
package lol.ysmu.biomeEffects.commands;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lol.ysmu.biomeEffects.BiomeEffects;
import lol.ysmu.biomeEffects.GUIs.GUIManager;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class BiomeEffectsCommand
implements CommandExecutor,
TabCompleter {
    private final BiomeEffects plugin;
    private final GUIManager guiManager;

    public BiomeEffectsCommand(BiomeEffects plugin) {
        this.plugin = plugin;
        this.guiManager = new GUIManager(plugin);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("biomeeffects.admin")) {
            sender.sendMessage("\u00a7cYou do not have permission to use this command.");
            return true;
        }
        if (args.length == 0) {
            this.sendUsage(sender, label);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                this.plugin.reloadConfig();
                sender.sendMessage("\u00a7aBiomeEffects configuration reloaded successfully.");
                return true;
            }
            case "list": {
                sender.sendMessage("\u00a7e--- Configured Biomes ---");
                this.plugin.getConfig().getConfigurationSection("biomes").getKeys(false).forEach(b -> sender.sendMessage("\u00a76- \u00a7f" + b));
                return true;
            }
            case "info": {
                if (args.length < 2) {
                    sender.sendMessage("\u00a7cUsage: /" + label + " info <player>");
                    return true;
                }
                Player target = Bukkit.getPlayer((String)args[1]);
                if (target == null) {
                    sender.sendMessage("\u00a7cPlayer not found.");
                    return true;
                }
                String currentBiome = target.getLocation().getBlock().getBiome().name();
                String lastBiome = this.plugin.getLastBiome(target.getUniqueId());
                String effects = target.getActivePotionEffects().stream().map(e -> e.getType().getName()).reduce((a, b) -> a + ", " + b).orElse("None");
                sender.sendMessage("\u00a7e--- BiomeEffects Info ---");
                sender.sendMessage("\u00a76Player: \u00a7f" + target.getName());
                sender.sendMessage("\u00a76Current Biome: \u00a7f" + currentBiome);
                sender.sendMessage("\u00a76Last Biome: \u00a7f" + lastBiome);
                sender.sendMessage("\u00a76Active Effects: \u00a7f" + effects);
                return true;
            }
            case "menu": {
                if (!(sender instanceof Player)) {
                    sender.sendMessage("\u00a7cThis command can only be used by players.");
                    return true;
                }
                this.guiManager.openMainMenu((Player)sender);
                return true;
            }
        }
        sender.sendMessage("\u00a7cUnknown command. Options:");
        this.sendUsage(sender, label);
        return true;
    }

    private void sendUsage(CommandSender sender, String label) {
        sender.sendMessage("\u00a7e--- BiomeEffects Commands ---");
        sender.sendMessage("\u00a76/" + label + " reload \u00a77- Reload the plugin config");
        sender.sendMessage("\u00a76/" + label + " list \u00a77- Show configured biomes");
        sender.sendMessage("\u00a76/" + label + " info <player> \u00a77- Show player biome info");
        sender.sendMessage("\u00a76/" + label + " menu \u00a77- Open configuration GUI");
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!sender.hasPermission("biomeeffects.admin")) {
            return Collections.emptyList();
        }
        if (args.length == 1) {
            return Arrays.asList("reload", "list", "info", "menu").stream().filter(s -> s.startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("info")) {
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(n -> n.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

