/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pethome.mixin;

import com.github.yzqdev.pethome.server.enchantment.DIEnchantmentRegistry;
import com.github.yzqdev.pethome.server.entity.DIActivityRegistry;
import com.github.yzqdev.pethome.server.entity.ModifedToBeTameable;
import com.github.yzqdev.pethome.server.entity.TameableUtils;
import com.github.yzqdev.pethome.server.entity.ai.AmphibianFollowOwnerBehavior;
import com.github.yzqdev.pethome.server.entity.ai.AmphibianStayBehavior;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.axolotl.AxolotlAi;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AxolotlAi.class})
public class AxolotlAiMixin {
    @Inject(method={"Lnet/minecraft/world/entity/animal/axolotl/AxolotlAi;makeBrain(Lnet/minecraft/world/entity/ai/Brain;)Lnet/minecraft/world/entity/ai/Brain;"}, remap=true, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/animal/axolotl/AxolotlAi;initPlayDeadActivity(Lnet/minecraft/world/entity/ai/Brain;)V")})
    private static void di_makeBrain(Brain<Axolotl> brain, CallbackInfoReturnable<Brain<?>> cir) {
        brain.m_21900_((Activity)DIActivityRegistry.AXOLOTL_FOLLOW.get(), ImmutableList.of((Object)Pair.of((Object)0, new AmphibianFollowOwnerBehavior(0.3f, 0.6f))));
        brain.m_21900_((Activity)DIActivityRegistry.AXOLOTL_STAY.get(), ImmutableList.of((Object)Pair.of((Object)0, new AmphibianStayBehavior())));
    }

    @Inject(method={"Lnet/minecraft/world/entity/animal/axolotl/AxolotlAi;updateActivity(Lnet/minecraft/world/entity/animal/axolotl/Axolotl;)V"}, remap=true, at={@At(value="HEAD")}, cancellable=true)
    private static void di_updateActivity(Axolotl axolotl, CallbackInfo ci) {
        Brain brain = axolotl.m_6274_();
        Activity activity = brain.m_21968_().orElse(null);
        if (activity != Activity.f_150238_ && !axolotl.m_149175_() && axolotl instanceof ModifedToBeTameable) {
            ModifedToBeTameable modifedToBeTameable = (ModifedToBeTameable)axolotl;
            if (modifedToBeTameable.isStayingStill()) {
                brain.m_21889_((Activity)DIActivityRegistry.AXOLOTL_STAY.get());
                ci.cancel();
            } else if (modifedToBeTameable.isFollowingOwner()) {
                brain.m_21926_((List)ImmutableList.of((Object)Activity.f_150238_, (Object)Activity.f_37988_, (Object)((Activity)DIActivityRegistry.AXOLOTL_FOLLOW.get())));
                ci.cancel();
            }
        }
    }

    @Inject(method={"Lnet/minecraft/world/entity/animal/axolotl/AxolotlAi;getTemptations()Lnet/minecraft/world/item/crafting/Ingredient;"}, remap=true, at={@At(value="TAIL")}, cancellable=true)
    private static void di_getTemptationItems(CallbackInfoReturnable<Ingredient> cir) {
        cir.setReturnValue((Object)Ingredient.merge((Collection)ImmutableList.of((Object)((Ingredient)cir.getReturnValue()), (Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42528_}))));
    }

    @Inject(method={"Lnet/minecraft/world/entity/animal/axolotl/AxolotlAi;getSpeedModifierChasing(Lnet/minecraft/world/entity/LivingEntity;)F"}, remap=true, at={@At(value="TAIL")}, cancellable=true)
    private static void di_getSpeedModifierChasing(LivingEntity axolotl, CallbackInfoReturnable<Float> cir) {
        int speedsterLevel = TameableUtils.getEnchantLevel(axolotl, DIEnchantmentRegistry.SPEEDSTER);
        cir.setReturnValue((Object)Float.valueOf(axolotl.m_20072_() ? 0.6f + (float)speedsterLevel * 0.05f : 0.15f + (float)speedsterLevel * 0.1f));
    }

    @Inject(method={"Lnet/minecraft/world/entity/animal/axolotl/AxolotlAi;getSpeedModifierFollowingAdult(Lnet/minecraft/world/entity/LivingEntity;)F"}, remap=true, at={@At(value="TAIL")}, cancellable=true)
    private static void di_getSpeedModifierFollowingAdult(LivingEntity axolotl, CallbackInfoReturnable<Float> cir) {
        int speedsterLevel = TameableUtils.getEnchantLevel(axolotl, DIEnchantmentRegistry.SPEEDSTER);
        cir.setReturnValue((Object)Float.valueOf(axolotl.m_20072_() ? 0.6f + (float)speedsterLevel * 0.05f : 0.15f + (float)speedsterLevel * 0.1f));
    }

    @Inject(method={"Lnet/minecraft/world/entity/animal/axolotl/AxolotlAi;getSpeedModifier(Lnet/minecraft/world/entity/LivingEntity;)F"}, remap=true, at={@At(value="TAIL")}, cancellable=true)
    private static void di_getSpeedModifier(LivingEntity axolotl, CallbackInfoReturnable<Float> cir) {
        int speedsterLevel = TameableUtils.getEnchantLevel(axolotl, DIEnchantmentRegistry.SPEEDSTER);
        cir.setReturnValue((Object)Float.valueOf(axolotl.m_20072_() ? 0.5f + (float)speedsterLevel * 0.05f : 0.15f + (float)speedsterLevel * 0.15f));
    }
}

