/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pethome.mixin;

import com.github.yzqdev.pethome.ModConstants;
import com.github.yzqdev.pethome.server.enchantment.DIEnchantmentRegistry;
import com.github.yzqdev.pethome.server.entity.ICitadelDataEntity;
import com.github.yzqdev.pethome.server.entity.TameableUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements ICitadelDataEntity {
    private static final EntityDataAccessor<CompoundTag> PET_HOME_SAVED_DATA = SynchedEntityData.m_135353_(LivingEntityMixin.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);

    public LivingEntityMixin(EntityType<?> entityType, Level lvl) {
        super(entityType, lvl);
    }

    @Inject(method={"getWaterSlowDown()F"}, remap=true, at={@At(value="TAIL")}, cancellable=true)
    private void di_getWaterSlowdown(CallbackInfoReturnable<Float> cir) {
        if (TameableUtils.isTamed(this) && this.isLandAndSea()) {
            cir.setReturnValue((Object)Float.valueOf(0.98f));
        }
    }

    @Inject(at={@At(value="TAIL")}, remap=true, method={"defineSynchedData()V"})
    private void citadel_registerData(CallbackInfo ci) {
        this.f_19804_.m_135372_(PET_HOME_SAVED_DATA, (Object)new CompoundTag());
    }

    @Inject(at={@At(value="TAIL")}, remap=true, method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"})
    private void citadel_writeAdditional(CompoundTag compoundNBT, CallbackInfo ci) {
        CompoundTag citadelDat = this.getCitadelEntityData();
        if (citadelDat != null) {
            compoundNBT.m_128365_(ModConstants.entitySyncData, (Tag)citadelDat);
        }
    }

    @Inject(at={@At(value="TAIL")}, remap=true, method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"})
    private void citadel_readAdditional(CompoundTag compoundNBT, CallbackInfo ci) {
        if (compoundNBT.m_128441_(ModConstants.entitySyncData)) {
            this.setCitadelEntityData(compoundNBT.m_128469_(ModConstants.entitySyncData));
        }
    }

    private boolean isLandAndSea() {
        return TameableUtils.hasEnchant((LivingEntity)this, DIEnchantmentRegistry.AMPHIBIOUS);
    }

    @Override
    public CompoundTag getCitadelEntityData() {
        return (CompoundTag)this.f_19804_.m_135370_(PET_HOME_SAVED_DATA);
    }

    @Override
    public void setCitadelEntityData(CompoundTag nbt) {
        this.f_19804_.m_135381_(PET_HOME_SAVED_DATA, (Object)nbt);
    }
}

