/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pethome.server.entity.ai;

import com.github.yzqdev.pethome.server.enchantment.DIEnchantmentRegistry;
import com.github.yzqdev.pethome.server.entity.ModifedToBeTameable;
import com.github.yzqdev.pethome.server.entity.TameableUtils;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class AmphibianFollowOwnerBehavior<T extends Animal>
extends Behavior<T> {
    private static final float START_DISTANCE = 10.0f;
    private static final float STOP_DISTANCE = 2.0f;
    private float baseSpeedLand = 1.0f;
    private float baseSpeedWater = 1.0f;
    private LivingEntity owner;

    public AmphibianFollowOwnerBehavior(float baseSpeedLand, float baseSpeedWater) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED), 20);
        this.baseSpeedLand = baseSpeedLand;
        this.baseSpeedWater = baseSpeedWater;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, T axolotl) {
        if (axolotl instanceof ModifedToBeTameable) {
            ModifedToBeTameable tamed = (ModifedToBeTameable)axolotl;
            this.owner = tamed.getTameOwner();
            if (this.owner != null && this.owner.m_6084_() && !this.owner.m_5833_() && tamed.isFollowingOwner()) {
                return true;
            }
        }
        return false;
    }

    protected boolean canStillUse(ServerLevel level, T axolotl, long gameTime) {
        if (!axolotl.m_6274_().m_21874_(MemoryModuleType.f_26375_) && this.owner != null && this.owner.m_6084_()) {
            return ((ModifedToBeTameable)axolotl).isFollowingOwner() && axolotl.m_20270_((Entity)this.owner) > 2.0f;
        }
        return false;
    }

    protected void stop(ServerLevel p_23492_, T axolotl, long gameTime) {
        axolotl.m_6274_().m_21936_(MemoryModuleType.f_26370_);
    }

    protected void tick(ServerLevel p_23503_, T axolotl, long gameTime) {
        if (axolotl.m_20280_((Entity)this.owner) >= 144.0) {
            this.teleportToOwner(axolotl);
        } else {
            int speedsterLevel = TameableUtils.getEnchantLevel(axolotl, DIEnchantmentRegistry.SPEEDSTER);
            float speed = axolotl.m_20072_() ? this.baseSpeedWater + (float)speedsterLevel * 0.05f : this.baseSpeedLand + (float)speedsterLevel * 0.1f;
            BehaviorUtils.m_22595_(axolotl, (LivingEntity)this.owner);
            BehaviorUtils.m_22590_(axolotl, (Entity)this.owner, (float)speed, (int)2);
        }
    }

    private int randomIntInclusive(int p_25301_, int p_25302_) {
        return this.owner.m_217043_().m_188503_(p_25302_ - p_25301_ + 1) + p_25301_;
    }

    private void teleportToOwner(T axolotl) {
        BlockPos blockpos = this.owner.m_20183_();
        for (int i = 0; i < 10; ++i) {
            int j = this.randomIntInclusive(-3, 3);
            int k = this.randomIntInclusive(-1, 1);
            int l = this.randomIntInclusive(-3, 3);
            boolean flag = this.maybeTeleportTo(axolotl, blockpos.m_123341_() + j, blockpos.m_123342_() + k, blockpos.m_123343_() + l);
            if (!flag) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(T axolotl, int p_25304_, int p_25305_, int p_25306_) {
        if (Math.abs((double)p_25304_ - this.owner.m_20185_()) < 2.0 && Math.abs((double)p_25306_ - this.owner.m_20189_()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(axolotl, new BlockPos(p_25304_, p_25305_, p_25306_))) {
            return false;
        }
        axolotl.m_7678_((double)p_25304_ + 0.5, (double)p_25305_, (double)p_25306_ + 0.5, axolotl.m_146908_(), axolotl.m_146909_());
        axolotl.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        return true;
    }

    private boolean canTeleportTo(T axolotl, BlockPos pos) {
        BlockPathTypes blockpathtypes = WalkNodeEvaluator.m_77604_((BlockGetter)axolotl.m_9236_(), (BlockPos.MutableBlockPos)pos.m_122032_());
        if (axolotl.m_9236_().m_6425_(pos).m_192917_((Fluid)Fluids.f_76193_)) {
            return true;
        }
        if (blockpathtypes != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockPos blockpos = pos.m_121996_((Vec3i)axolotl.m_20183_());
        return axolotl.m_9236_().m_45756_(axolotl, axolotl.m_20191_().m_82338_(blockpos));
    }
}

