/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pet_home;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="pet_home", bus=EventBusSubscriber.Bus.MOD)
public class PetHomeConfig {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    private static final ModConfigSpec.BooleanValue ROTTEN_APPLE = BUILDER.comment("true if apples can turn into rotten apples if they despawn").define("rotten_apple", true);
    private static final ModConfigSpec.BooleanValue MOBCATCHER_ONLY_TAMABLE_ANIMAL = BUILDER.comment("Mob catcher only catches tamable animal").define("mobcatcherOnlyTamableAnimal", true);
    private static final ModConfigSpec.ConfigValue<List<? extends String>> MOBCATCHER_BLACKLIST = BUILDER.comment("entities that can't be caught").defineListAllowEmpty("mobcatcherBlacklist", List.of("minecraft:painting"), () -> BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.PAINTING).toString(), PetHomeConfig::validateEntityTypesName);
    private static final ModConfigSpec.DoubleValue BLAZING_PROTECTION_LOOT_CHANCE = BUILDER.comment("percent chance of nether fortress loot table containing Blazing Protection book:").defineInRange("blazing_protection_loot_chance", 0.2, 0.0, 1.0);
    private static final ModConfigSpec.IntValue PETSTORE_VILLAGE_WEIGHT = BUILDER.comment("the spawn weight of the pet store in villages, set to 0 to disable it entirely").defineInRange("petstore_village_weight", 17, 0, 1000);
    private static final ModConfigSpec.DoubleValue SINISTER_CARROT_LOOT_CHANCE = BUILDER.comment("percent chance of woodland mansion loot table containing sinister carrot:").defineInRange("sinister_carrot_loot_chance", 0.3, 0.0, 1.0);
    private static final ModConfigSpec.DoubleValue BUBBLING_LOOT_CHANCE = BUILDER.comment("percent chance of burried treasure loot table containing Bubbling book:").defineInRange("bubbling_loot_chance", 0.65, 0.0, 1.0);
    private static final ModConfigSpec.DoubleValue VAMPIRISM_LOOT_CHANCE = BUILDER.comment("percent chance of woodland mansion loot table containing Vampire book:").defineInRange("vampirism_loot_chance", 0.22, 0.0, 1.0);
    private static final ModConfigSpec.DoubleValue SONIC_BOOM_LOOT_CHANCE = BUILDER.comment("percent chance of woodland mansion loot table containing Sonic boom book:").defineInRange("sonic_boom_loot_chance", 0.6, 0.0, 1.0);
    private static final ModConfigSpec.DoubleValue PARALYSIS_LOOT_CHANCE = BUILDER.comment("percent chance of chest loot table containing paralysis book:").defineInRange("paralysis_loot_chance", 0.1, 0.0, 1.0);
    private static final ModConfigSpec.DoubleValue SHARE_LOOT_CHANCE = BUILDER.comment("percent chance of ender city loot table containing share book:").defineInRange("share_loot_chance", 0.5, 0.0, 1.0);
    private static final ModConfigSpec.DoubleValue ORE_SCENTING_LOOT_CHANCE = BUILDER.comment("percent chance of mineshaft loot table containing Ore Scenting book:").defineInRange("ore_scenting_loot_chance", 0.15, 0.0, 1.0);
    private static final ModConfigSpec.BooleanValue PROTECT_PETS_FROM_OWNER = BUILDER.comment("owner cannot hurt pet").define("protectPetsFromOwner", true);
    private static final ModConfigSpec.BooleanValue PROTECT_PETS_FROM_PETS = BUILDER.comment("pet cannot hurt pet").define("protectPetsFromPets", true);
    private static final ModConfigSpec.BooleanValue PROTECT_CHILDREN = BUILDER.comment("protect children animal").define("protectChildren", true);
    private static final ModConfigSpec.BooleanValue REFLECT_DAMAGE = BUILDER.comment("protect pet from ownder").define("reflectDamage", false);
    private static final ModConfigSpec.BooleanValue DISPLAY_HIT_WARNING = BUILDER.comment("owner cannot hurt pet").define("displayHitWarning", true);
    private static final ModConfigSpec.BooleanValue PROTECT_TEAM_MEMBERS = BUILDER.comment("PROTECT_TEAM_MEMBERS").define("protectTeamMembers", true);
    private static final ModConfigSpec.BooleanValue RESPECT_TEAM_RULES = BUILDER.comment("RESPECT_TEAM_RULES").define("respectTeamRules", true);
    private static final ModConfigSpec.ConfigValue<List<? extends String>> CAN_HURT_PET_ITEM = BUILDER.comment("can hurt pet item").defineListAllowEmpty("can_hurt_pet_item", List.of(), () -> BuiltInRegistries.ITEM.getKey((Object)Items.EGG).toString(), PetHomeConfig::validateItemName);
    private static final ModConfigSpec.ConfigValue<List<? extends String>> CAN_HURT_ALL_ITEM = BUILDER.comment("can always hurt item").defineListAllowEmpty("can_hurt_all", List.of(), () -> BuiltInRegistries.ITEM.getKey((Object)Items.EGG).toString(), PetHomeConfig::validateItemName);
    private static final ModConfigSpec.ConfigValue<List<? extends String>> NO_PROTECTION_ENTITY = BUILDER.comment("can always hurt").defineListAllowEmpty("no_protection_entity", List.of(), () -> BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.ZOMBIE).toString(), PetHomeConfig::validateEntityTypesName);
    private static final ModConfigSpec.ConfigValue<List<? extends String>> OTHER_SHOULD_PROTECT_ENTITY = BUILDER.comment("other entities that can be protected").defineListAllowEmpty("other_should_protect_entity", List.of("minecraft:villager"), () -> BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.VILLAGER).toString(), PetHomeConfig::validateEntityTypesName);
    private static final ModConfigSpec.ConfigValue<List<? extends String>> PLAYER_CANT_HURT_ENTITY = BUILDER.comment("entities player cant hurt").defineListAllowEmpty("player_cant_hurt_entity", List.of(), () -> BuiltInRegistries.ENTITY_TYPE.getKey((Object)EntityType.ZOMBIFIED_PIGLIN).toString(), PetHomeConfig::validateEntityTypesName);
    static final ModConfigSpec SPEC = BUILDER.build();
    public static double sinisterCarrotLootChance;
    public static double bubblingLootChance;
    public static double oreScentingLootChance;
    public static double vampirismLootChance;
    public static double shareLootChance;
    public static double sonicBoomLootChance;
    public static double blazingProtectionLootChance;
    public static double paralysisLootChance;
    public static boolean protectPetsFromOwner;
    public static int petstoreVillageWeight;
    public static boolean rottenApple;
    public static boolean protectPetsFromPets;
    public static boolean protectChildren;
    public static boolean reflectDamage;
    public static boolean displayHitWarning;
    public static boolean protectTeamMembers;
    public static boolean respectTeamRules;
    public static Set<EntityType<?>> noProtectionEntity;
    public static Set<EntityType<?>> otherShouldProtectionEntity;
    public static Set<EntityType<?>> playerCantHurtEntity;
    public static Set<Item> canHurtPetItem;
    public static Set<Item> canHurtAllItem;
    public static boolean mobcatcherOnlyTamableAnimal;
    public static Set<EntityType<?>> mobcatcherBlackList;

    private static boolean validateEntityTypesName(Object obj) {
        String itemName;
        if (obj instanceof String && BuiltInRegistries.ENTITY_TYPE.containsKey(ResourceLocation.parse((String)(itemName = (String)obj)))) {
            boolean flag = true;
            return flag;
        }
        boolean flag = false;
        return flag;
    }

    private static boolean validateItemName(Object obj) {
        String itemName;
        if (obj instanceof String && BuiltInRegistries.ITEM.containsKey(ResourceLocation.parse((String)(itemName = (String)obj)))) {
            boolean flag = true;
            return flag;
        }
        boolean flag = false;
        return flag;
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        mobcatcherOnlyTamableAnimal = (Boolean)MOBCATCHER_ONLY_TAMABLE_ANIMAL.get();
        mobcatcherBlackList = ((List)MOBCATCHER_BLACKLIST.get()).stream().map(entityTypeName -> (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)entityTypeName))).collect(Collectors.toSet());
        respectTeamRules = (Boolean)RESPECT_TEAM_RULES.get();
        protectPetsFromOwner = (Boolean)PROTECT_PETS_FROM_OWNER.get();
        protectChildren = (Boolean)PROTECT_CHILDREN.get();
        protectPetsFromPets = (Boolean)PROTECT_PETS_FROM_PETS.get();
        reflectDamage = (Boolean)REFLECT_DAMAGE.get();
        displayHitWarning = (Boolean)DISPLAY_HIT_WARNING.get();
        protectTeamMembers = (Boolean)PROTECT_TEAM_MEMBERS.get();
        rottenApple = (Boolean)ROTTEN_APPLE.get();
        blazingProtectionLootChance = (Double)BLAZING_PROTECTION_LOOT_CHANCE.get();
        petstoreVillageWeight = (Integer)PETSTORE_VILLAGE_WEIGHT.get();
        sinisterCarrotLootChance = (Double)SINISTER_CARROT_LOOT_CHANCE.get();
        bubblingLootChance = (Double)BUBBLING_LOOT_CHANCE.get();
        oreScentingLootChance = (Double)ORE_SCENTING_LOOT_CHANCE.get();
        vampirismLootChance = (Double)VAMPIRISM_LOOT_CHANCE.get();
        shareLootChance = (Double)SHARE_LOOT_CHANCE.get();
        sonicBoomLootChance = (Double)SONIC_BOOM_LOOT_CHANCE.get();
        paralysisLootChance = (Double)PARALYSIS_LOOT_CHANCE.get();
        blazingProtectionLootChance = (Double)BLAZING_PROTECTION_LOOT_CHANCE.get();
        noProtectionEntity = ((List)NO_PROTECTION_ENTITY.get()).stream().map(entityTypeName -> (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)entityTypeName))).collect(Collectors.toSet());
        otherShouldProtectionEntity = ((List)OTHER_SHOULD_PROTECT_ENTITY.get()).stream().map(entityTypeName -> (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)entityTypeName))).collect(Collectors.toSet());
        playerCantHurtEntity = ((List)PLAYER_CANT_HURT_ENTITY.get()).stream().map(entityTypeName -> (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)entityTypeName))).collect(Collectors.toSet());
        canHurtPetItem = ((List)CAN_HURT_PET_ITEM.get()).stream().map(i -> (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)i))).collect(Collectors.toSet());
        canHurtAllItem = ((List)CAN_HURT_ALL_ITEM.get()).stream().map(i -> (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)i))).collect(Collectors.toSet());
    }

    static {
        protectPetsFromOwner = true;
        protectPetsFromPets = true;
        protectChildren = true;
        protectTeamMembers = true;
        respectTeamRules = true;
    }
}

