/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pet_home.client;

import com.github.yzqdev.pet_home.PetHomeMod;
import com.github.yzqdev.pet_home.client.EventGetOutlineColor;
import com.github.yzqdev.pet_home.client.particle.ParticleBlight;
import com.github.yzqdev.pet_home.client.particle.ParticleDeflectionShield;
import com.github.yzqdev.pet_home.client.particle.ParticleGiantPop;
import com.github.yzqdev.pet_home.client.particle.ParticleIntimidation;
import com.github.yzqdev.pet_home.client.particle.ParticleMagnet;
import com.github.yzqdev.pet_home.client.particle.ParticlePsychicWall;
import com.github.yzqdev.pet_home.client.particle.ParticleQuestionMark;
import com.github.yzqdev.pet_home.client.particle.ParticleSimpleBubble;
import com.github.yzqdev.pet_home.client.particle.ParticleSniff;
import com.github.yzqdev.pet_home.client.particle.ParticleVampire;
import com.github.yzqdev.pet_home.client.particle.ParticleZZZ;
import com.github.yzqdev.pet_home.client.render.OreColorRegistry;
import com.github.yzqdev.pet_home.server.entity.HighlightedBlockEntity;
import com.github.yzqdev.pet_home.server.misc.PHParticleRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(value={Dist.CLIENT})
public class ClientGameEvents {
    public static Map<Entity, int[]> shadowPunchRenderData = new HashMap<Entity, int[]>();

    public static void registerClientListeners(IEventBus iEventBus) {
        iEventBus.addListener(ClientGameEvents::setupParticles);
    }

    public static void updateVisualDataForMob(Entity entity, int[] arr) {
        shadowPunchRenderData.put(entity, arr);
    }

    public static void setupParticles(RegisterParticleProvidersEvent event) {
        PetHomeMod.LOGGER.debug("Registered particle factories");
        event.registerSpecial((ParticleType)PHParticleRegistry.DEFLECTION_SHIELD.get(), (ParticleProvider)new ParticleDeflectionShield.Factory());
        event.registerSpriteSet((ParticleType)PHParticleRegistry.MAGNET.get(), ParticleMagnet.Factory::new);
        event.registerSpriteSet((ParticleType)PHParticleRegistry.ZZZ.get(), ParticleZZZ.Factory::new);
        event.registerSpriteSet((ParticleType)PHParticleRegistry.GIANT_POP.get(), ParticleGiantPop.Factory::new);
        event.registerSpriteSet((ParticleType)PHParticleRegistry.SIMPLE_BUBBLE.get(), ParticleSimpleBubble.Factory::new);
        event.registerSpriteSet((ParticleType)PHParticleRegistry.VAMPIRE.get(), ParticleVampire.Factory::new);
        event.registerSpriteSet((ParticleType)PHParticleRegistry.SNIFF.get(), ParticleSniff.Factory::new);
        event.registerSpriteSet((ParticleType)PHParticleRegistry.PSYCHIC_WALL.get(), ParticlePsychicWall.Factory::new);
        event.registerSpecial((ParticleType)PHParticleRegistry.INTIMIDATION.get(), (ParticleProvider)new ParticleIntimidation.Factory());
        event.registerSpriteSet((ParticleType)PHParticleRegistry.BLIGHT.get(), ParticleBlight.Factory::new);
        event.registerSpriteSet((ParticleType)PHParticleRegistry.QUESTION_MARK_PARTICLE_TYPE.get(), ParticleQuestionMark.Factory::new);
    }

    @SubscribeEvent
    public static void onOutlineColor(EventGetOutlineColor event) {
        if (event.getEntityIn() instanceof HighlightedBlockEntity) {
            event.setColor(OreColorRegistry.getBlockColor(((HighlightedBlockEntity)event.getEntityIn()).getBlockState()));
            event.setResult(EventGetOutlineColor.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public static void onAttackEntityFromClientEvent(InputEvent.InteractionKeyMappingTriggered event) {
    }
}

