/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pet_home.client;

import com.github.yzqdev.pet_home.client.render.ChainLightningRender;
import com.github.yzqdev.pet_home.client.render.LayerManager;
import com.github.yzqdev.pet_home.client.render.RecallBallRender;
import com.github.yzqdev.pet_home.client.render.RenderFeather;
import com.github.yzqdev.pet_home.client.render.RenderGiantBubble;
import com.github.yzqdev.pet_home.client.render.RenderHighlightedBlock;
import com.github.yzqdev.pet_home.client.render.RenderPsychicWall;
import com.github.yzqdev.pet_home.server.entity.PHEntityRegistry;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

@EventBusSubscriber(modid="pet_home", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class EntityRegEvent {
    @SubscribeEvent
    public static void registerEntityRender(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)PHEntityRegistry.RECALL_BALL.get(), RecallBallRender::new);
        event.registerEntityRenderer((EntityType)PHEntityRegistry.CHAIN_LIGHTNING.get(), ChainLightningRender::new);
        event.registerEntityRenderer((EntityType)PHEntityRegistry.GIANT_BUBBLE.get(), RenderGiantBubble::new);
        event.registerEntityRenderer((EntityType)PHEntityRegistry.PSYCHIC_WALL.get(), RenderPsychicWall::new);
        event.registerEntityRenderer((EntityType)PHEntityRegistry.HIGHLIGHTED_BLOCK.get(), RenderHighlightedBlock::new);
        event.registerEntityRenderer((EntityType)PHEntityRegistry.FEATHER.get(), RenderFeather::new);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onAddLayers(EntityRenderersEvent.AddLayers event) {
        ImmutableList entityTypes = ImmutableList.copyOf((Collection)BuiltInRegistries.ENTITY_TYPE.stream().filter(LayerManager::canApply).map(entityType -> entityType).collect(Collectors.toList()));
        entityTypes.forEach(entityType -> {
            String modId;
            ResourceLocation key = BuiltInRegistries.ENTITY_TYPE.getKey(entityType);
            if (key != null && !(modId = key.getNamespace()).equals("minecraft")) {
                System.out.println("EntityType: " + String.valueOf(key) + " | Mod: " + modId);
            }
            LayerManager.addLayerIfApplicable((EntityType<? extends LivingEntity>)entityType, event);
        });
    }

    @SubscribeEvent
    public static void registerLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
    }

    @SubscribeEvent
    public static void registerSpawnPlacements(RegisterSpawnPlacementsEvent event) {
    }

    @SubscribeEvent
    public static void addEntityAttributes(EntityAttributeCreationEvent event) {
    }
}

