/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pet_home.client.model;

import com.github.yzqdev.pet_home.client.model.AdvancedEntityModel;
import com.github.yzqdev.pet_home.client.model.BasicModelPart;
import com.github.yzqdev.pet_home.client.model.TabulaModelRenderUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

@OnlyIn(value=Dist.CLIENT)
public class AdvancedModelBox
extends BasicModelPart {
    public float defaultRotationX;
    public float defaultRotationY;
    public float defaultRotationZ;
    public float defaultOffsetX;
    public float defaultOffsetY;
    public float defaultOffsetZ;
    public float defaultPositionX;
    public float defaultPositionY;
    public float defaultPositionZ;
    public float scaleX = 1.0f;
    public float scaleY = 1.0f;
    public float scaleZ = 1.0f;
    public int textureOffsetX;
    public int textureOffsetY;
    public boolean scaleChildren;
    private AdvancedEntityModel model;
    private AdvancedModelBox parent;
    private int displayList;
    private boolean compiled;
    public ObjectList<TabulaModelRenderUtils.ModelBox> cubeList;
    public ObjectList<BasicModelPart> childModels;
    private float textureWidth;
    private float textureHeight;
    public float offsetX;
    public float offsetY;
    public float offsetZ;
    public String boxName = "";

    public AdvancedModelBox(AdvancedEntityModel model, String name) {
        super(model);
        this.textureWidth = model.texWidth;
        this.textureHeight = model.texHeight;
        this.model = model;
        this.cubeList = new ObjectArrayList();
        this.childModels = new ObjectArrayList();
        this.boxName = name;
    }

    public AdvancedModelBox(AdvancedEntityModel model) {
        this(model, null);
        this.textureWidth = model.texWidth;
        this.textureHeight = model.texHeight;
        this.cubeList = new ObjectArrayList();
        this.childModels = new ObjectArrayList();
    }

    public AdvancedModelBox(AdvancedEntityModel model, int textureOffsetX, int textureOffsetY) {
        this(model);
        this.textureWidth = model.texWidth;
        this.textureHeight = model.texHeight;
        this.setTextureOffset(textureOffsetX, textureOffsetY);
        this.cubeList = new ObjectArrayList();
        this.childModels = new ObjectArrayList();
    }

    public BasicModelPart setTexSize(int p_78787_1_, int p_78787_2_) {
        this.textureWidth = p_78787_1_;
        this.textureHeight = p_78787_2_;
        return this;
    }

    @Override
    public BasicModelPart addBox(String p_217178_1_, float p_217178_2_, float p_217178_3_, float p_217178_4_, int p_217178_5_, int p_217178_6_, int p_217178_7_, float p_217178_8_, int p_217178_9_, int p_217178_10_) {
        this.setTextureOffset(p_217178_9_, p_217178_10_);
        this.addBox(this.textureOffsetX, this.textureOffsetY, p_217178_2_, p_217178_3_, p_217178_4_, p_217178_5_, p_217178_6_, p_217178_7_, p_217178_8_, p_217178_8_, p_217178_8_, this.mirror, false);
        return this;
    }

    @Override
    public BasicModelPart addBox(float p_228300_1_, float p_228300_2_, float p_228300_3_, float p_228300_4_, float p_228300_5_, float p_228300_6_) {
        this.addBox(this.textureOffsetX, this.textureOffsetY, p_228300_1_, p_228300_2_, p_228300_3_, p_228300_4_, p_228300_5_, p_228300_6_, 0.0f, 0.0f, 0.0f, this.mirror, false);
        return this;
    }

    @Override
    public BasicModelPart addBox(float p_228304_1_, float p_228304_2_, float p_228304_3_, float p_228304_4_, float p_228304_5_, float p_228304_6_, boolean p_228304_7_) {
        this.addBox(this.textureOffsetX, this.textureOffsetY, p_228304_1_, p_228304_2_, p_228304_3_, p_228304_4_, p_228304_5_, p_228304_6_, 0.0f, 0.0f, 0.0f, p_228304_7_, false);
        return this;
    }

    @Override
    public void addBox(float p_228301_1_, float p_228301_2_, float p_228301_3_, float p_228301_4_, float p_228301_5_, float p_228301_6_, float p_228301_7_) {
        this.addBox(this.textureOffsetX, this.textureOffsetY, p_228301_1_, p_228301_2_, p_228301_3_, p_228301_4_, p_228301_5_, p_228301_6_, p_228301_7_, p_228301_7_, p_228301_7_, this.mirror, false);
    }

    @Override
    public void addBox(float p_228302_1_, float p_228302_2_, float p_228302_3_, float p_228302_4_, float p_228302_5_, float p_228302_6_, float p_228302_7_, float p_228302_8_, float p_228302_9_) {
        this.addBox(this.textureOffsetX, this.textureOffsetY, p_228302_1_, p_228302_2_, p_228302_3_, p_228302_4_, p_228302_5_, p_228302_6_, p_228302_7_, p_228302_8_, p_228302_9_, this.mirror, false);
    }

    @Override
    public void addBox(float p_228303_1_, float p_228303_2_, float p_228303_3_, float p_228303_4_, float p_228303_5_, float p_228303_6_, float p_228303_7_, boolean p_228303_8_) {
        this.addBox(this.textureOffsetX, this.textureOffsetY, p_228303_1_, p_228303_2_, p_228303_3_, p_228303_4_, p_228303_5_, p_228303_6_, p_228303_7_, p_228303_7_, p_228303_7_, p_228303_8_, false);
    }

    private void addBox(int p_228305_1_, int p_228305_2_, float p_228305_3_, float p_228305_4_, float p_228305_5_, float p_228305_6_, float p_228305_7_, float p_228305_8_, float p_228305_9_, float p_228305_10_, float p_228305_11_, boolean p_228305_12_, boolean p_228305_13_) {
        this.cubeList.add((Object)new TabulaModelRenderUtils.ModelBox(p_228305_1_, p_228305_2_, p_228305_3_, p_228305_4_, p_228305_5_, p_228305_6_, p_228305_7_, p_228305_8_, p_228305_9_, p_228305_10_, p_228305_11_, p_228305_12_, this.textureWidth, this.textureHeight));
    }

    public void setShouldScaleChildren(boolean scaleChildren) {
        this.scaleChildren = scaleChildren;
    }

    public void setScale(float scaleX, float scaleY, float scaleZ) {
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.scaleZ = scaleZ;
    }

    public void setScaleX(float scaleX) {
        this.scaleX = scaleX;
    }

    public void setScaleY(float scaleY) {
        this.scaleY = scaleY;
    }

    public void setScaleZ(float scaleZ) {
        this.scaleZ = scaleZ;
    }

    public void updateDefaultPose() {
        this.defaultRotationX = this.rotateAngleX;
        this.defaultRotationY = this.rotateAngleY;
        this.defaultRotationZ = this.rotateAngleZ;
        this.defaultPositionX = this.rotationPointX;
        this.defaultPositionY = this.rotationPointY;
        this.defaultPositionZ = this.rotationPointZ;
    }

    public void setPos(float xIn, float yIn, float zIn) {
        this.rotationPointX = xIn;
        this.rotationPointY = yIn;
        this.rotationPointZ = zIn;
    }

    public void resetToDefaultPose() {
        this.rotateAngleX = this.defaultRotationX;
        this.rotateAngleY = this.defaultRotationY;
        this.rotateAngleZ = this.defaultRotationZ;
        this.rotationPointX = this.defaultPositionX;
        this.rotationPointY = this.defaultPositionY;
        this.rotationPointZ = this.defaultPositionZ;
    }

    @Override
    public void addChild(BasicModelPart child) {
        super.addChild(child);
        this.childModels.add((Object)child);
        if (child instanceof AdvancedModelBox) {
            AdvancedModelBox advancedChild = (AdvancedModelBox)child;
            advancedChild.setParent(this);
        }
    }

    public AdvancedModelBox getParent() {
        return this.parent;
    }

    public void setParent(AdvancedModelBox parent) {
        this.parent = parent;
    }

    public void parentedPostRender(float scale) {
        if (this.parent != null) {
            this.parent.parentedPostRender(scale);
        }
    }

    public void renderWithParents(float scale) {
        if (this.parent != null) {
            this.parent.renderWithParents(scale);
        }
    }

    public void translateAndRotate(PoseStack matrixStackIn) {
        matrixStackIn.translate((double)(this.rotationPointX / 16.0f), (double)(this.rotationPointY / 16.0f), (double)(this.rotationPointZ / 16.0f));
        if (this.rotateAngleZ != 0.0f) {
            matrixStackIn.mulPose(Axis.ZP.rotation(this.rotateAngleZ));
        }
        if (this.rotateAngleY != 0.0f) {
            matrixStackIn.mulPose(Axis.YP.rotation(this.rotateAngleY));
        }
        if (this.rotateAngleX != 0.0f) {
            matrixStackIn.mulPose(Axis.XP.rotation(this.rotateAngleX));
        }
        matrixStackIn.scale(this.scaleX, this.scaleY, this.scaleZ);
    }

    @Override
    public void render(PoseStack poseStack, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (!(!this.showModel || this.cubeList.isEmpty() && this.childModels.isEmpty())) {
            poseStack.pushPose();
            this.translateAndRotate(poseStack);
            this.doRender(poseStack.last(), bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            ObjectListIterator var9 = this.childModels.iterator();
            if (!this.scaleChildren) {
                poseStack.scale(1.0f / Math.max(this.scaleX, 1.0E-4f), 1.0f / Math.max(this.scaleY, 1.0E-4f), 1.0f / Math.max(this.scaleZ, 1.0E-4f));
            }
            while (var9.hasNext()) {
                BasicModelPart lvt_10_1_ = (BasicModelPart)var9.next();
                lvt_10_1_.render(poseStack, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            }
            poseStack.popPose();
        }
    }

    private void doRender(PoseStack.Pose pose, VertexConsumer vertexConsumer, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        Matrix4f matrix4f = pose.pose();
        Matrix3f normal = pose.normal();
        for (TabulaModelRenderUtils.ModelBox lvt_12_1_ : this.cubeList) {
            for (TabulaModelRenderUtils.TexturedQuad lvt_16_1_ : lvt_12_1_.quads) {
                Vector3f lvt_17_1_ = new Vector3f((Vector3fc)lvt_16_1_.normal);
                lvt_17_1_.mul((Matrix3fc)normal);
                float lvt_18_1_ = lvt_17_1_.x();
                float lvt_19_1_ = lvt_17_1_.y();
                float lvt_20_1_ = lvt_17_1_.z();
                for (int lvt_21_1_ = 0; lvt_21_1_ < 4; ++lvt_21_1_) {
                    TabulaModelRenderUtils.PositionTextureVertex lvt_22_1_ = lvt_16_1_.vertexPositions[lvt_21_1_];
                    float lvt_23_1_ = lvt_22_1_.position.x() / 16.0f;
                    float lvt_24_1_ = lvt_22_1_.position.y() / 16.0f;
                    float lvt_25_1_ = lvt_22_1_.position.z() / 16.0f;
                    Vector4f lvt_26_1_ = new Vector4f(lvt_23_1_, lvt_24_1_, lvt_25_1_, 1.0f);
                    lvt_26_1_.mul((Matrix4fc)matrix4f);
                    vertexConsumer.addVertex(lvt_26_1_.x(), lvt_26_1_.y(), lvt_26_1_.z()).setColor(red, green, blue, alpha).setNormal(lvt_18_1_, lvt_19_1_, lvt_20_1_).setLight(packedLightIn).setOverlay(packedOverlayIn).setUv(lvt_22_1_.textureU, lvt_22_1_.textureV);
                }
            }
        }
    }

    public AdvancedEntityModel getModel() {
        return this.model;
    }

    private float calculateRotation(float speed, float degree, boolean invert, float offset, float weight, float f, float f1) {
        float movementScale = this.model.getMovementScale();
        float rotation = Mth.cos((float)(f * (speed * movementScale) + offset)) * (degree * movementScale) * f1 + weight * f1;
        return invert ? -rotation : rotation;
    }

    public void walk(float speed, float degree, boolean invert, float offset, float weight, float walk, float walkAmount) {
        this.rotateAngleX += this.calculateRotation(speed, degree, invert, offset, weight, walk, walkAmount);
    }

    public void flap(float speed, float degree, boolean invert, float offset, float weight, float flap, float flapAmount) {
        this.rotateAngleZ += this.calculateRotation(speed, degree, invert, offset, weight, flap, flapAmount);
    }

    public void swing(float speed, float degree, boolean invert, float offset, float weight, float swing, float swingAmount) {
        this.rotateAngleY += this.calculateRotation(speed, degree, invert, offset, weight, swing, swingAmount);
    }

    public void bob(float speed, float degree, boolean bounce, float f, float f1) {
        float movementScale = this.model.getMovementScale();
        float bob = (float)(Math.sin(f * (speed *= movementScale)) * (double)f1 * (double)(degree *= movementScale) - (double)(f1 * degree));
        if (bounce) {
            bob = (float)(-Math.abs(Math.sin(f * speed) * (double)f1 * (double)degree));
        }
        this.rotationPointY += bob;
    }

    @Override
    public AdvancedModelBox setTextureOffset(int textureOffsetX, int textureOffsetY) {
        this.textureOffsetX = textureOffsetX;
        this.textureOffsetY = textureOffsetY;
        return this;
    }

    public void transitionTo(AdvancedModelBox to, float timer, float maxTime) {
        this.rotateAngleX += (to.rotateAngleX - this.rotateAngleX) / maxTime * timer;
        this.rotateAngleY += (to.rotateAngleY - this.rotateAngleY) / maxTime * timer;
        this.rotateAngleZ += (to.rotateAngleZ - this.rotateAngleZ) / maxTime * timer;
        this.rotationPointX += (to.rotationPointX - this.rotationPointX) / maxTime * timer;
        this.rotationPointY += (to.rotationPointY - this.rotationPointY) / maxTime * timer;
        this.rotationPointZ += (to.rotationPointZ - this.rotationPointZ) / maxTime * timer;
        this.offsetX += (to.offsetX - this.offsetX) / maxTime * timer;
        this.offsetY += (to.offsetY - this.offsetY) / maxTime * timer;
        this.offsetZ += (to.offsetZ - this.offsetZ) / maxTime * timer;
    }
}

