/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pet_home.client.particle;

import com.github.yzqdev.pet_home.server.item.PHItemRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ParticleDeflectionShield
extends Particle {
    private float xRot;
    private float yRot;

    ParticleDeflectionShield(ClientLevel lvl, double x, double y, double z, float xRot, float yRot) {
        super(lvl, x, y, z);
        this.setSize(1.0f, 1.0f);
        this.gravity = 0.0f;
        this.lifetime = 15 + new Random().nextInt(7);
        this.xRot = xRot;
        this.yRot = yRot;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.CUSTOM;
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float partialTick) {
        Vec3 vec3 = camera.getPosition();
        PoseStack posestack = new PoseStack();
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.getInstance().renderBuffers().bufferSource();
        float f = (float)(Mth.lerp((double)partialTick, (double)this.xo, (double)this.x) - vec3.x());
        float f1 = (float)(Mth.lerp((double)partialTick, (double)this.yo, (double)this.y) - vec3.y());
        float f2 = (float)(Mth.lerp((double)partialTick, (double)this.zo, (double)this.z) - vec3.z());
        float lerpAge = (float)this.age + partialTick;
        float ageProgress = lerpAge / (float)this.lifetime;
        float fadeTime = 0.15f;
        float fadeIn = Math.min(ageProgress, fadeTime) / fadeTime;
        float fadeOut = Mth.clamp((float)(ageProgress - (1.0f - fadeTime)), (float)0.0f, (float)fadeTime) / fadeTime;
        float up = -1.0f + fadeIn + (float)Math.sin(lerpAge * 0.3f) * 0.03f;
        float down = -1.0f * fadeOut;
        float scale = (fadeIn - fadeOut) * 1.85f;
        posestack.pushPose();
        posestack.translate(f, f1 + up + down, f2);
        posestack.mulPose(Axis.YP.rotationDegrees(this.yRot));
        posestack.mulPose(Axis.XN.rotationDegrees(this.xRot));
        posestack.scale(scale, scale, scale);
        Minecraft.getInstance().getItemRenderer().renderStatic(new ItemStack((ItemLike)PHItemRegistry.DEFLECTION_SHIELD.get()), ItemDisplayContext.GROUND, 240, OverlayTexture.NO_OVERLAY, posestack, (MultiBufferSource)multibuffersource$buffersource, (Level)this.level, 0);
        multibuffersource$buffersource.endBatch();
        posestack.popPose();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new ParticleDeflectionShield(worldIn, x, y, z, (float)xSpeed, (float)ySpeed);
        }
    }
}

