/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pet_home.client.particle;

import com.github.yzqdev.pet_home.PetHomeMod;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.NeoForgeRenderTypes;

public class ParticleIntimidation
extends Particle {
    private float xRot;
    private float yRot;
    private int entityId;

    ParticleIntimidation(ClientLevel lvl, double x, double y, double z, int entityId, float xRot, float yRot) {
        super(lvl, x, y, z);
        this.setSize(1.0f, 1.0f);
        this.gravity = 0.0f;
        this.lifetime = 22 + new Random().nextInt(7);
        this.entityId = entityId;
        this.xRot = xRot;
        this.yRot = yRot;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.CUSTOM;
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float partialTick) {
        Entity entity = Minecraft.getInstance().level.getEntity(this.entityId);
        if (entity != null) {
            Vec3 vec3 = camera.getPosition();
            PoseStack posestack = new PoseStack();
            MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.getInstance().renderBuffers().bufferSource();
            float f = (float)(Mth.lerp((double)partialTick, (double)this.xo, (double)this.x) - vec3.x());
            float f1 = (float)(Mth.lerp((double)partialTick, (double)this.yo, (double)this.y) - vec3.y());
            float f2 = (float)(Mth.lerp((double)partialTick, (double)this.zo, (double)this.z) - vec3.z());
            float lerpAge = (float)this.age + partialTick;
            float ageProgress = lerpAge / (float)this.lifetime;
            float fadeTime = 0.15f;
            float fadeIn = Math.min(ageProgress, fadeTime) / fadeTime;
            float fadeOut = Mth.clamp((float)(ageProgress - (1.0f - fadeTime)), (float)0.0f, (float)fadeTime) / fadeTime;
            float up = 0.2f + (2.0f + entity.getBbHeight()) * fadeIn + (float)Math.sin(lerpAge * 0.3f) * 0.03f;
            float down = -3.0f * fadeOut;
            float scale = (fadeIn - fadeOut) * 1.5f;
            posestack.pushPose();
            posestack.translate(f, f1 + (up + down), f2);
            posestack.mulPose(Axis.XP.rotationDegrees(180.0f));
            posestack.mulPose(Axis.YP.rotationDegrees(this.yRot));
            posestack.scale(scale, scale, scale);
            this.renderEntity(entity, 0.0, 0.0, 0.0, scale, partialTick, posestack, (MultiBufferSource)multibuffersource$buffersource, this.getLightColor(partialTick));
            multibuffersource$buffersource.endBatch();
            posestack.popPose();
        }
    }

    public <E extends Entity> void renderEntity(E entityIn, double x, double y, double z, float scale, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int packedLight) {
        EntityRenderer render = null;
        EntityRenderDispatcher manager = Minecraft.getInstance().getEntityRenderDispatcher();
        try {
            render = manager.getRenderer(entityIn);
            if (render instanceof LivingEntityRenderer) {
                boolean prevSit;
                LivingEntityRenderer livingEntityRenderer = (LivingEntityRenderer)render;
                EntityModel model = livingEntityRenderer.getModel();
                ResourceLocation tex = livingEntityRenderer.getTextureLocation(entityIn);
                float alpha = Math.min(scale, 1.0f) * 0.5f;
                boolean bl = prevSit = entityIn instanceof TamableAnimal && ((TamableAnimal)entityIn).isInSittingPose();
                if (entityIn instanceof TamableAnimal) {
                    ((TamableAnimal)entityIn).setInSittingPose(false);
                }
                float bob = entityIn instanceof Wolf ? ((Wolf)entityIn).getTailAngle() : (float)entityIn.tickCount + partialTicks;
                model.prepareMobModel(entityIn, 1.0f, 0.0f, partialTicks);
                model.setupAnim(entityIn, 0.0f, 0.0f, bob, 0.0f, this.xRot);
                model.renderToBuffer(matrixStack, bufferIn.getBuffer(NeoForgeRenderTypes.getItemLayeredTranslucent((ResourceLocation)tex)).setColor(1.0f, 1.0f, 1.0f, alpha), packedLight, OverlayTexture.NO_OVERLAY);
                if (entityIn instanceof TamableAnimal) {
                    ((TamableAnimal)entityIn).setInSittingPose(prevSit);
                }
            }
        }
        catch (Throwable throwable3) {
            PetHomeMod.LOGGER.warn("could not render intimidating effect");
            this.remove();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new ParticleIntimidation(worldIn, x, y, z, (int)xSpeed, (float)ySpeed, (float)zSpeed);
        }
    }
}

