/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pet_home.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ParticleSniff
extends SimpleAnimatedParticle {
    private float targetX = 0.0f;
    private float targetY = 0.0f;
    private float targetZ = 0.0f;

    private ParticleSniff(ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ, SpriteSet sprites) {
        super(world, x, y, z, sprites, 0.0f);
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        float grey = this.random.nextFloat() * 0.2f;
        this.rCol = 0.5f + grey;
        this.gCol = 0.5f + grey;
        this.bCol = 0.5f + grey;
        this.targetX = (float)motionX;
        this.targetY = (float)motionY;
        this.targetZ = (float)motionZ;
        this.quadSize = 0.3f;
        this.lifetime = 10 + this.random.nextInt(10);
        this.pickSprite(sprites);
    }

    public void tick() {
        super.tick();
        float speed = 1.0f / (float)this.lifetime;
        this.quadSize = 0.3f - 0.2f * ((float)this.age / (float)this.lifetime);
        double moveX = (double)this.targetX - this.x;
        double moveY = (double)this.targetY - this.y;
        double moveZ = (double)this.targetZ - this.z;
        this.setAlpha(1.0f - (float)this.age / (float)this.lifetime);
        this.xd += moveX * (double)speed;
        this.yd += moveY * (double)speed;
        this.zd += moveZ * (double)speed;
        this.xd *= 0.8;
        this.yd *= 0.8;
        this.zd *= 0.8;
    }

    public int getLightColor(float p_107249_) {
        BlockPos blockpos = BlockPos.containing((double)this.x, (double)this.y, (double)this.z);
        return this.level.hasChunkAt(blockpos) ? LevelRenderer.getLightColor((BlockAndTintGetter)this.level, (BlockPos)blockpos) : 0;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ParticleSniff p = new ParticleSniff(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
            return p;
        }
    }
}

