/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pet_home.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ParticleZZZ
extends SimpleAnimatedParticle {
    private float sinOffset;
    private float cosOffset;
    private float rotationDir;
    private float initialX;
    private float initialZ;

    private ParticleZZZ(ClientLevel world, double x, double y, double z, double motionX, double motionY, double motionZ, SpriteSet sprites) {
        super(world, x, y, z, sprites, 0.0f);
        this.xd = (float)motionX;
        this.yd = (float)motionY;
        this.zd = (float)motionZ;
        this.quadSize = 0.1f + this.random.nextFloat() * 0.1f;
        this.lifetime = 16 + this.random.nextInt(6);
        this.gravity = -0.08f;
        this.sinOffset = this.random.nextFloat();
        this.cosOffset = this.random.nextFloat();
        this.rotationDir = this.random.nextBoolean() ? 1.0f : -1.0f;
        this.initialX = (float)x;
        this.initialZ = (float)z;
        this.pickSprite(sprites);
    }

    public void tick() {
        super.tick();
        float xTarget = this.initialX + (float)Math.cos((float)this.age * 0.3f + this.cosOffset * 4.0f) * 0.2f * this.rotationDir;
        float zTarget = this.initialZ + (float)Math.sin((float)this.age * 0.3f + this.sinOffset * 4.0f) * 0.2f * this.rotationDir;
        this.xd = (double)0.3f * ((double)xTarget - this.x);
        this.zd = (double)0.3f * ((double)zTarget - this.z);
        this.setAlpha(1.0f - (float)this.age / (float)this.lifetime);
    }

    public int getLightColor(float partialTicks) {
        float f = ((float)this.age + partialTicks) / (float)this.lifetime;
        f = Mth.clamp((float)f, (float)0.0f, (float)1.0f);
        int i = super.getLightColor(partialTicks);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new ParticleZZZ(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }
    }
}

