/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pet_home.client.render;

import com.github.yzqdev.pet_home.client.render.LightningBoltData;
import com.github.yzqdev.pet_home.client.render.LightningRender;
import com.github.yzqdev.pet_home.server.entity.ChainLightningEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.joml.Vector4f;

public class ChainLightningRender
extends EntityRenderer<ChainLightningEntity> {
    private LightningRender lightningRender = new LightningRender();
    private LightningBoltData.BoltRenderInfo lightningBoltData = new LightningBoltData.BoltRenderInfo(1.3f, 0.15f, 0.5f, 0.25f, new Vector4f(0.1f, 0.3f, 0.5f, 0.5f), 0.45f);

    public ChainLightningRender(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn);
    }

    public boolean shouldRender(ChainLightningEntity entity, Frustum frustum, double x, double y, double z) {
        Entity next = entity.getFromEntity();
        return next != null && frustum.isVisible(entity.getBoundingBox().minmax(next.getBoundingBox())) || super.shouldRender((Entity)entity, frustum, x, y, z);
    }

    public void render(ChainLightningEntity entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light) {
        super.render((Entity)entity, yaw, partialTicks, poseStack, buffer, light);
        poseStack.pushPose();
        Entity from = entity.getFromEntity();
        float x = (float)Mth.lerp((double)partialTicks, (double)entity.xo, (double)entity.getX());
        float y = (float)Mth.lerp((double)partialTicks, (double)entity.yo, (double)entity.getY());
        float z = (float)Mth.lerp((double)partialTicks, (double)entity.zo, (double)entity.getZ());
        if (from != null) {
            LightningBoltData bolt = new LightningBoltData(this.lightningBoltData, from.getEyePosition(), entity.position(), 5).size(0.1f).lifespan(2).spawn(LightningBoltData.SpawnFunction.NO_DELAY);
            this.lightningRender.update(null, bolt, partialTicks);
            poseStack.translate(-x, -y, -z);
            this.lightningRender.render(partialTicks, poseStack, buffer);
        }
        poseStack.popPose();
    }

    public ResourceLocation getTextureLocation(ChainLightningEntity entity) {
        return null;
    }
}

