/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pet_home.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.Util;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.TheEndPortalRenderer;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public class DIRenderTypes
extends RenderType {
    protected static final RenderStateShard.TexturingStateShard IFRAME_TEXTURING = new RenderStateShard.TexturingStateShard("entity_glint_texturing", () -> DIRenderTypes.setupIframeShading(3.0f, 7L), () -> RenderSystem.resetTextureMatrix());
    protected static final RenderStateShard.TexturingStateShard SHADOW_HAND_TEXTURING = new RenderStateShard.TexturingStateShard("entity_glint_texturing", () -> DIRenderTypes.setupShadowHandShading(0.5f, 2L), () -> RenderSystem.resetTextureMatrix());
    protected static final RenderStateShard.TexturingStateShard PSYCHIC_WALL_TEXTURING = new RenderStateShard.TexturingStateShard("entity_glint_texturing", () -> DIRenderTypes.setupPsychicWallTexturing(0.5f, 40L), () -> RenderSystem.resetTextureMatrix());
    public static final RenderType IFRAME_GLINT = DIRenderTypes.create((String)"iframe_glint", (VertexFormat)DefaultVertexFormat.POSITION_TEX, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RENDERTYPE_ENTITY_GLINT_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ResourceLocation.parse((String)"pet_home:textures/immunity_frame_overlay.png"), true, false)).setWriteMaskState(COLOR_DEPTH_WRITE).setCullState(NO_CULL).setDepthTestState(EQUAL_DEPTH_TEST).setTransparencyState(GLINT_TRANSPARENCY).setTexturingState(IFRAME_TEXTURING).setOverlayState(OVERLAY).createCompositeState(true));
    public static final RenderType VOID_CLOUD = DIRenderTypes.create((String)"void_cloud", (VertexFormat)DefaultVertexFormat.POSITION, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RENDERTYPE_END_PORTAL_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)RenderStateShard.MultiTextureStateShard.builder().add(TheEndPortalRenderer.END_SKY_LOCATION, false, false).add(ResourceLocation.parse((String)"pet_home:textures/void_cloud.png"), false, false).build()).setLightmapState(LIGHTMAP).createCompositeState(false));
    public static final RenderType SHADOW_HAND_ENTITY = DIRenderTypes.create((String)"shadow_hand_entity", (VertexFormat)DefaultVertexFormat.POSITION_TEX, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RENDERTYPE_ENTITY_GLINT_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ResourceLocation.parse((String)"pet_home:textures/shadow_hand.png"), false, false)).setWriteMaskState(COLOR_DEPTH_WRITE).setTexturingState(SHADOW_HAND_TEXTURING).setLightmapState(LIGHTMAP).setCullState(RenderStateShard.NO_CULL).createCompositeState(false));
    public static final RenderType PSYCHIC_WALL = DIRenderTypes.create((String)"psychic_wall2", (VertexFormat)DefaultVertexFormat.POSITION_TEX, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.RENDERTYPE_GLINT_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ResourceLocation.parse((String)"pet_home:textures/psychic_wall_overlay.png"), false, false)).setTexturingState(PSYCHIC_WALL_TEXTURING).setLightmapState(LIGHTMAP).setCullState(RenderStateShard.NO_CULL).setTransparencyState(RenderStateShard.LIGHTNING_TRANSPARENCY).setDepthTestState(LEQUAL_DEPTH_TEST).createCompositeState(true));
    public static final RenderType PSYCHIC_WALL_BORDER = DIRenderTypes.create((String)"psychic_wall2", (VertexFormat)DefaultVertexFormat.POSITION_TEX, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.RENDERTYPE_GLINT_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ResourceLocation.parse((String)"pet_home:textures/psychic_wall_border.png"), true, false)).setLightmapState(LIGHTMAP).setCullState(RenderStateShard.NO_CULL).setTransparencyState(RenderStateShard.LIGHTNING_TRANSPARENCY).setDepthTestState(LEQUAL_DEPTH_TEST).createCompositeState(true));
    public static final RenderType HEALING_AURA = DIRenderTypes.create((String)"healing_aura", (VertexFormat)DefaultVertexFormat.POSITION_TEX, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.RENDERTYPE_GLINT_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ResourceLocation.parse((String)"pet_home:textures/healing_aura.png"), true, false)).setLightmapState(LIGHTMAP).setCullState(RenderStateShard.NO_CULL).setTransparencyState(RenderStateShard.LIGHTNING_TRANSPARENCY).setWriteMaskState(COLOR_DEPTH_WRITE).setDepthTestState(LEQUAL_DEPTH_TEST).createCompositeState(true));
    public static final RenderType TRANSLUCENT_NO_CULL = DIRenderTypes.translucentNoCull();

    public DIRenderTypes(String p_173178_, VertexFormat p_173179_, VertexFormat.Mode p_173180_, int p_173181_, boolean p_173182_, boolean p_173183_, Runnable p_173184_, Runnable p_173185_) {
        super(p_173178_, p_173179_, p_173180_, p_173181_, p_173182_, p_173183_, p_173184_, p_173185_);
    }

    public static RenderType getZombieOverlay(ResourceLocation texture, int x, int y) {
        return DIRenderTypes.create((String)"zombie_overlay", (VertexFormat)DefaultVertexFormat.POSITION_TEX, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)true, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RENDERTYPE_ENTITY_GLINT_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(ResourceLocation.parse((String)"pet_home:textures/zombie_overlay.png"), false, false)).setWriteMaskState(COLOR_DEPTH_WRITE).setCullState(NO_CULL).setDepthTestState(EQUAL_DEPTH_TEST).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setTexturingState((RenderStateShard.TexturingStateShard)new ZombieTexturing("zombie", x, y)).setOverlayState(OVERLAY).createCompositeState(true));
    }

    private static RenderType translucentNoCull() {
        RenderType.CompositeRenderType type = DIRenderTypes.create((String)"translucent_no_cull", (VertexFormat)DefaultVertexFormat.BLOCK, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)0x200000, (boolean)true, (boolean)true, (RenderType.CompositeState)RenderType.CompositeState.builder().setLightmapState(LIGHTMAP).setShaderState(RENDERTYPE_TRANSLUCENT_SHADER).setCullState(NO_CULL).setTextureState((RenderStateShard.EmptyTextureStateShard)BLOCK_SHEET_MIPPED).setTransparencyState(TRANSLUCENT_TRANSPARENCY).setOutputState(TRANSLUCENT_TARGET).createCompositeState(true));
        return type;
    }

    private static void setupShadowHandShading(float in, long time) {
        long i = Util.getMillis() * time;
        float f = (float)(i % 110000L) / 110000.0f;
        float f1 = (float)(i % 30000L) / 30000.0f;
        Matrix4f matrix4f = new Matrix4f().translation(0.0f, -f1, 0.0f);
        matrix4f.scale(in);
        RenderSystem.setTextureMatrix((Matrix4f)matrix4f);
    }

    private static void setupIframeShading(float in, long time) {
        long i = Util.getMillis() * time;
        float f1 = (float)(i % 30000L) / 30000.0f;
        Matrix4f matrix4f = new Matrix4f().translation(0.0f, f1, 0.0f);
        matrix4f.rotateZ(0.7853982f).scale(in);
        RenderSystem.setTextureMatrix((Matrix4f)matrix4f);
    }

    private static void setupPsychicWallTexturing(float in, long time) {
        long i = Util.getMillis() * 2L;
        float f1 = (float)(i % 30000L) / 30000.0f;
        float f2 = (float)Math.sin((float)i / 20000.0f) + 1.0f;
        float f3 = (float)Math.cos((float)i / 20000.0f) + 1.0f;
        Matrix4f matrix4f = new Matrix4f().translation(1.0f + f2, 1.0f + f3, 0.0f);
        matrix4f.scale(in);
        RenderSystem.setTextureMatrix((Matrix4f)matrix4f);
    }

    private static class ZombieTexturing
    extends RenderStateShard.TexturingStateShard {
        public ZombieTexturing(String name, int x, int y) {
            super(name, () -> ZombieTexturing.setupZombieTexturing(x, y), () -> RenderSystem.resetTextureMatrix());
        }

        private static void setupZombieTexturing(int x, int y) {
            Matrix4f matrix4f = new Matrix4f().translation(0.0f, 0.0f, 0.0f);
            matrix4f.scale((float)x / 64.0f, (float)y / 64.0f, 1.0f);
            RenderSystem.setTextureMatrix((Matrix4f)matrix4f);
        }
    }
}

