/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pet_home.client.render;

import com.github.yzqdev.pet_home.PetHomeMod;
import com.github.yzqdev.pet_home.client.render.LayerPetOverlays;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;

public class LayerManager {
    public static boolean canApply(EntityType<?> type) {
        return true;
    }

    public static void addLayerIfApplicable(EntityType<? extends LivingEntity> entityType, EntityRenderersEvent.AddLayers event) {
        if (entityType == EntityType.ENDER_DRAGON) {
            return;
        }
        try {
            EntityRenderer renderer = event.getRenderer(entityType);
            if (renderer instanceof LivingEntityRenderer) {
                LivingEntityRenderer livingEntityRenderer = (LivingEntityRenderer)renderer;
                livingEntityRenderer.addLayer((RenderLayer)new LayerPetOverlays((RenderLayerParent)livingEntityRenderer));
            } else {
                PetHomeMod.LOGGER.warn("Could not apply pet overlays layer to {}. Renderer is not a LivingEntityRenderer.", (Object)BuiltInRegistries.ENTITY_TYPE.getKey(entityType));
            }
        }
        catch (Exception e) {
            PetHomeMod.LOGGER.warn("Failed to apply pet overlays layer to {}: {}", (Object)BuiltInRegistries.ENTITY_TYPE.getKey(entityType), (Object)e.getMessage());
        }
    }
}

