/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pet_home.client.render;

import com.github.yzqdev.pet_home.client.ClientGameEvents;
import com.github.yzqdev.pet_home.client.model.BlazingBarModel;
import com.github.yzqdev.pet_home.client.model.ShadowHandModel;
import com.github.yzqdev.pet_home.client.render.DIRenderTypes;
import com.github.yzqdev.pet_home.client.render.LightningBoltData;
import com.github.yzqdev.pet_home.client.render.LightningRender;
import com.github.yzqdev.pet_home.datagen.ModEnchantments;
import com.github.yzqdev.pet_home.server.item.PHItemRegistry;
import com.github.yzqdev.pet_home.util.TameableUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.NeoForgeRenderTypes;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector4f;

public class LayerPetOverlays
extends RenderLayer {
    private static final ItemStack MAGNET = new ItemStack((ItemLike)PHItemRegistry.MAGNET.get());
    private static final int CLOUD_COUNT = 14;
    private static final Vec3[] CLOUD_OFFSETS = new Vec3[14];
    private static final Vec3[] CLOUD_SCALES = new Vec3[14];
    private static final ShadowHandModel SHADOW_HAND_MODEL = new ShadowHandModel();
    private static final BlazingBarModel BLAZING_BAR_MODEL = new BlazingBarModel();
    private static final ResourceLocation BLAZE_TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/entity/blaze.png");
    private static final ResourceLocation AURA_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"pet_home", (String)"textures/healing_aura.png");
    private static final Map<ResourceLocation, Integer> MODELS_TO_XSIZE = new HashMap<ResourceLocation, Integer>();
    private static final Map<ResourceLocation, Integer> MODELS_TO_YSIZE = new HashMap<ResourceLocation, Integer>();
    private final RenderLayerParent parent;
    private final LightningRender lightningRender = new LightningRender();
    private final LightningBoltData.BoltRenderInfo healthBoltData = new LightningBoltData.BoltRenderInfo(0.3f, 0.0f, 0.0f, 0.0f, new Vector4f(0.4f, 0.0f, 0.0f, 0.4f), 0.2f);
    private final LightningBoltData.BoltRenderInfo shadowBoltData = new LightningBoltData.BoltRenderInfo(0.3f, 0.0f, 0.0f, 0.0f, new Vector4f(1.0f, 1.0f, 1.0f, 1.0f), 0.2f);

    public LayerPetOverlays(RenderLayerParent parent) {
        super(parent);
        this.parent = parent;
    }

    private static void addVertexPairAlex(VertexConsumer p_174308_, Matrix4f p_174309_, float p_174310_, float p_174311_, float p_174312_, int p_174313_, int p_174314_, int p_174315_, int p_174316_, float p_174317_, float p_174318_, float p_174319_, float p_174320_, int p_174321_, boolean p_174322_) {
        float f = (float)p_174321_ / 8.0f;
        int i = (int)Mth.lerp((float)f, (float)p_174313_, (float)p_174314_);
        int j = (int)Mth.lerp((float)f, (float)p_174315_, (float)p_174316_);
        int k = LightTexture.pack((int)i, (int)j);
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = p_174310_ * f;
        float f6 = p_174311_ < 0.0f ? p_174311_ * f * f : p_174311_ - p_174311_ * (1.0f - f) * (1.0f - f);
        float f7 = p_174312_ * f;
        p_174308_.addVertex(p_174309_, f5 - p_174319_, f6 + p_174318_, f7 + p_174320_).setColor(f2, f3, f4, 1.0f).setUv2(k, k);
        p_174308_.addVertex(p_174309_, f5 + p_174319_, f6 + p_174317_ - p_174318_, f7 - p_174320_).setColor(f2, f3, f4, 1.0f).setUv2(k, k);
    }

    public static <E extends Entity> void renderShadowString(Entity from, Vec3 fromVec, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, Vec3 to) {
        poseStack.pushPose();
        double d3 = fromVec.x;
        double d4 = fromVec.y;
        double d5 = fromVec.z;
        poseStack.translate(d3, d4, d5);
        float f = (float)(to.x - d3);
        float f1 = (float)(to.y - d4);
        float f2 = (float)(to.z - d5);
        float f3 = 0.025f;
        VertexConsumer vertexconsumer = bufferSource.getBuffer(RenderType.leash());
        Matrix4f matrix4f = poseStack.last().pose();
        BlockPos blockpos = BlockPos.containing((Position)fromVec);
        BlockPos blockpos1 = BlockPos.containing((Position)to);
        int i = 0;
        int j = from.level().getBrightness(LightLayer.BLOCK, blockpos1);
        int k = from.level().getBrightness(LightLayer.SKY, blockpos);
        int l = from.level().getBrightness(LightLayer.SKY, blockpos1);
        for (int i1 = 0; i1 <= 8; ++i1) {
            float width = 0.05f - (float)i1 / 8.0f * 0.025f;
            LayerPetOverlays.addVertexPairAlex(vertexconsumer, matrix4f, f, f1, f2, i, j, k, l, 0.2f, width, width, width, i1, false);
        }
        poseStack.popPose();
    }

    private static void vertex(VertexConsumer p_114090_, Matrix4f p_114091_, PoseStack.Pose p_114092_, int p_114093_, float p_114094_, int p_114095_, int p_114096_, int p_114097_, float alpha) {
        p_114090_.addVertex(p_114091_, p_114094_ - 0.5f, (float)p_114095_ - 0.5f, 0.0f).setColor(255.0f, 255.0f, 255.0f, alpha * 255.0f).setUv((float)p_114096_, (float)p_114097_).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(p_114093_, p_114093_).setNormal(p_114092_, 0.0f, 1.0f, 0.0f);
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, Entity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (TameableUtils.isTamed(entity)) {
            int t;
            int shadowHandCount;
            Entity owner;
            Entity suck;
            LivingEntity living = (LivingEntity)entity;
            float f = Mth.rotLerp((float)partialTicks, (float)living.yBodyRotO, (float)living.yBodyRot);
            float realAge = (float)living.tickCount + partialTicks;
            if (TameableUtils.hasEnchant(living, ModEnchantments.IMMUNITY_FRAME) && TameableUtils.getImmuneTime((LivingEntity)entity) > 0) {
                VertexConsumer ivertexbuilder = bufferIn.getBuffer(DIRenderTypes.IFRAME_GLINT);
                float alpha = 0.5f;
                matrixStackIn.pushPose();
                this.getParentModel().renderToBuffer(matrixStackIn, ivertexbuilder, packedLightIn, LivingEntityRenderer.getOverlayCoords((LivingEntity)((LivingEntity)entity), (float)0.0f));
                matrixStackIn.popPose();
            }
            if (TameableUtils.hasEnchant(living, ModEnchantments.MAGNETIC) && (suck = TameableUtils.getPetAttackTarget(living)) != null) {
                double d0 = Mth.lerp((double)partialTicks, (double)suck.xo, (double)suck.getX()) - Mth.lerp((double)partialTicks, (double)living.xo, (double)living.getX());
                double d1 = Mth.lerp((double)partialTicks, (double)suck.yo, (double)suck.getY()) - Mth.lerp((double)partialTicks, (double)living.yo, (double)living.getY());
                double d2 = Mth.lerp((double)partialTicks, (double)suck.zo, (double)suck.getZ()) - Mth.lerp((double)partialTicks, (double)living.zo, (double)living.getZ());
                double d3 = d0 * d0 + d2 * d2 + d1 * d1;
                double d4 = Math.sqrt(d0 * d0 + d2 * d2);
                float f1 = (float)(Mth.atan2((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                float f2 = (float)(-(Mth.atan2((double)d1, (double)d4) * 57.2957763671875));
                matrixStackIn.pushPose();
                matrixStackIn.mulPose(Axis.YN.rotationDegrees(f));
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(f1));
                matrixStackIn.mulPose(Axis.XP.rotationDegrees(f2));
                matrixStackIn.pushPose();
                float bob1 = (float)Math.sin(realAge * 0.5f) * 0.05f;
                float bob2 = (float)Math.sin(realAge * 0.3f) * 0.09f - 0.03f;
                float bob3 = (float)Math.cos(realAge * 0.1f) * 0.05f;
                matrixStackIn.translate(bob1, 1.25f - entity.getBbHeight() * 0.5f - bob2, -entity.getBbWidth() - 0.125f - bob3);
                matrixStackIn.mulPose(Axis.XN.rotationDegrees(90.0f));
                matrixStackIn.scale(1.6f, 1.6f, 3.0f);
                Minecraft.getInstance().getItemRenderer().renderStatic(MAGNET, ItemDisplayContext.GROUND, packedLightIn, OverlayTexture.NO_OVERLAY, matrixStackIn, bufferIn, entity.level(), entity.getId());
                matrixStackIn.popPose();
                matrixStackIn.popPose();
            }
            if (TameableUtils.hasEnchant(living, ModEnchantments.HEALTH_SIPHON) && (owner = TameableUtils.getOwnerOf((Entity)living)) != null && owner.isAlive() && owner.distanceTo((Entity)living) < 100.0f) {
                float x = (float)Mth.lerp((double)partialTicks, (double)entity.xo, (double)entity.getX());
                float y = (float)Mth.lerp((double)partialTicks, (double)entity.yo, (double)entity.getY());
                float z = (float)Mth.lerp((double)partialTicks, (double)entity.zo, (double)entity.getZ());
                if (living.hurtTime > 0 && living.hurtTime == living.hurtDuration - 1) {
                    float height = -2.0f + entity.getBbHeight() * 0.8f;
                    float ownerHeight = -2.0f + owner.getBbHeight() * 0.6f;
                    LightningBoltData bolt = new LightningBoltData(this.healthBoltData, new Vec3((double)x, (double)(y + height), (double)z), owner.position().add(0.0, (double)ownerHeight, 0.0), 3).size(0.5f).lifespan(5).spawn(LightningBoltData.SpawnFunction.NO_DELAY);
                    this.lightningRender.update(living, bolt, partialTicks);
                }
                matrixStackIn.pushPose();
                matrixStackIn.mulPose(Axis.YN.rotationDegrees(f));
                matrixStackIn.mulPose(Axis.XN.rotationDegrees(180.0f));
                matrixStackIn.pushPose();
                matrixStackIn.translate(-x, -y, -z);
                this.lightningRender.render(partialTicks, matrixStackIn, bufferIn);
                matrixStackIn.popPose();
                matrixStackIn.popPose();
            }
            if (TameableUtils.hasEnchant(living, ModEnchantments.VOID_CLOUD) && !living.isInWaterOrBubble() && !living.onGround() && TameableUtils.getFallDistance(living) >= 3.0f) {
                matrixStackIn.pushPose();
                matrixStackIn.translate(0.4f, 1.25f + entity.getBbHeight(), 0.2f);
                matrixStackIn.mulPose(Axis.YN.rotationDegrees(f));
                matrixStackIn.mulPose(Axis.XN.rotationDegrees(180.0f));
                for (int i = 0; i < 14; ++i) {
                    float xSin = (float)Math.sin(realAge * 0.05f + (float)i * 2.0f) * 0.1f;
                    float ySin = (float)Math.cos(realAge * 0.05f + (float)i * 2.0f) * 0.1f;
                    float zSin = (float)Math.sin(realAge * 0.05f + (float)i * 2.0f - 2.0f) * 0.1f;
                    matrixStackIn.pushPose();
                    matrixStackIn.translate(LayerPetOverlays.CLOUD_OFFSETS[i].x + (double)xSin, LayerPetOverlays.CLOUD_OFFSETS[i].y + (double)ySin, LayerPetOverlays.CLOUD_OFFSETS[i].z + (double)zSin);
                    matrixStackIn.scale((float)LayerPetOverlays.CLOUD_SCALES[i].x + xSin, (float)LayerPetOverlays.CLOUD_SCALES[i].y + ySin, (float)LayerPetOverlays.CLOUD_SCALES[i].z + xSin);
                    this.renderVoidCloudCube(entity, matrixStackIn, bufferIn.getBuffer(DIRenderTypes.VOID_CLOUD));
                    matrixStackIn.popPose();
                }
                matrixStackIn.popPose();
            }
            if ((shadowHandCount = TameableUtils.getEnchantLevel(living, ModEnchantments.SHADOW_HANDS)) > 0) {
                Entity punching = TameableUtils.getPetAttackTarget(living);
                double d0 = 0.0;
                double d1 = 0.0;
                double d2 = 0.0;
                if (punching != null) {
                    d0 = Mth.lerp((double)partialTicks, (double)punching.xo, (double)punching.getX()) - Mth.lerp((double)partialTicks, (double)living.xo, (double)living.getX());
                    d1 = Mth.lerp((double)partialTicks, (double)punching.yo, (double)punching.getY()) - Mth.lerp((double)partialTicks, (double)living.yo, (double)living.getY());
                    d2 = Mth.lerp((double)partialTicks, (double)punching.zo, (double)punching.getZ()) - Mth.lerp((double)partialTicks, (double)living.zo, (double)living.getZ());
                }
                double d3 = d0 * d0 + d2 * d2 + d1 * d1;
                double d4 = Math.sqrt(d0 * d0 + d2 * d2);
                float f1 = (float)(Mth.atan2((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                float f2 = (float)(-(Mth.atan2((double)d1, (double)d4) * 57.2957763671875));
                for (int i = 0; i < shadowHandCount; ++i) {
                    float punch = this.getPunchFor(living, i, partialTicks) / 10.0f;
                    VertexConsumer vertexconsumer = bufferIn.getBuffer(DIRenderTypes.SHADOW_HAND_ENTITY);
                    float xSpread = shadowHandCount <= 1 ? 0.0f : (float)i / (float)(shadowHandCount - 1) - 0.5f;
                    float xOffset = shadowHandCount <= 1 ? 0.0f : Mth.sin((float)((float)((double)xSpread * Math.PI))) * 1.8f;
                    float zOffset = shadowHandCount <= 1 ? 0.25f : Mth.cos((float)((float)((double)xSpread * Math.PI))) * 1.8f;
                    float yOffset = -zOffset * 0.3f;
                    Vec3 fromPos = new Vec3(0.0, (double)(1.25f - entity.getBbHeight() * 0.5f), (double)(-entity.getBbWidth() * 0.3f));
                    Vec3 handTranslate = new Vec3((double)(xOffset * entity.getBbWidth()), (double)(1.0f + yOffset) + Math.sin(realAge * 0.2f + (float)i * 1.5f) * (double)0.15f, (double)(zOffset * entity.getBbWidth()));
                    if (punching != null) {
                        Vec3 vec3 = new Vec3(d0, d1, d2).scale((double)punch);
                        handTranslate = handTranslate.add(vec3).yRot((float)Math.PI + f1 * ((float)Math.PI / 180));
                    }
                    matrixStackIn.pushPose();
                    if (punching != null) {
                        matrixStackIn.mulPose(Axis.YN.rotationDegrees(f));
                        matrixStackIn.mulPose(Axis.YP.rotationDegrees(f1));
                        matrixStackIn.mulPose(Axis.XP.rotationDegrees(f2));
                    }
                    matrixStackIn.pushPose();
                    matrixStackIn.translate(handTranslate.x, handTranslate.y, handTranslate.z);
                    matrixStackIn.pushPose();
                    matrixStackIn.translate(0.0f, -1.15f, -0.15f);
                    SHADOW_HAND_MODEL.animateShadowHand(punch, i, shadowHandCount, realAge);
                    SHADOW_HAND_MODEL.renderToBuffer(matrixStackIn, vertexconsumer, packedLightIn, LivingEntityRenderer.getOverlayCoords((LivingEntity)((LivingEntity)entity), (float)0.0f));
                    matrixStackIn.popPose();
                    matrixStackIn.popPose();
                    matrixStackIn.pushPose();
                    LayerPetOverlays.renderShadowString(entity, fromPos, partialTicks, matrixStackIn, bufferIn, handTranslate);
                    matrixStackIn.popPose();
                    matrixStackIn.popPose();
                }
            }
            if (TameableUtils.hasEnchant(living, ModEnchantments.BLAZING_PROTECTION)) {
                int bars = TameableUtils.getBlazingProtectionBars(living);
                float f1 = realAge * 7.0f;
                float seperation = 360.0f / ((float)TameableUtils.getEnchantLevel(living, ModEnchantments.BLAZING_PROTECTION) * 2.0f);
                VertexConsumer vertexconsumer = bufferIn.getBuffer(NeoForgeRenderTypes.getUnlitTranslucent((ResourceLocation)BLAZE_TEXTURE));
                matrixStackIn.pushPose();
                matrixStackIn.mulPose(Axis.YN.rotationDegrees(f));
                for (int i = 0; i < bars; ++i) {
                    matrixStackIn.pushPose();
                    matrixStackIn.mulPose(Axis.YP.rotationDegrees(f1 += seperation));
                    float bob = (float)Math.sin((double)(realAge * 0.6f) + Math.toRadians(seperation * (float)i)) * 0.15f - 0.07f;
                    matrixStackIn.translate(0.0f, 0.4f - entity.getBbHeight() * 0.5f - bob, -entity.getBbWidth() - 0.2f);
                    BLAZING_BAR_MODEL.animateBar(f1);
                    BLAZING_BAR_MODEL.renderToBuffer(matrixStackIn, vertexconsumer, 240, LivingEntityRenderer.getOverlayCoords((LivingEntity)((LivingEntity)entity), (float)0.0f), 1);
                    matrixStackIn.popPose();
                }
                matrixStackIn.popPose();
            }
            if (TameableUtils.hasEnchant(living, ModEnchantments.HEALING_AURA) && (t = TameableUtils.getHealingAuraTime(living)) > 0) {
                float time = t > 20 ? 200.0f - Math.max(180.0f, (float)t + partialTicks) : (float)t - partialTicks;
                float pulse = 0.9f + (float)(Math.sin(realAge * 0.08f) * (double)0.1f + (double)0.1f);
                float healscale = Math.min(time, 20.0f) / 20.0f * 2.2f * pulse;
                matrixStackIn.pushPose();
                matrixStackIn.translate(0.0f, 1.8f - entity.getBbHeight() * 0.5f, 0.0f);
                matrixStackIn.mulPose(Axis.YN.rotationDegrees(f));
                matrixStackIn.mulPose(Axis.YP.rotationDegrees(realAge * 3.0f));
                matrixStackIn.mulPose(Axis.XP.rotationDegrees(90.0f));
                matrixStackIn.scale(3.0f * healscale, 3.0f * healscale, 3.0f * healscale);
                VertexConsumer vertexconsumer = bufferIn.getBuffer(DIRenderTypes.HEALING_AURA);
                PoseStack.Pose posestack$pose = matrixStackIn.last();
                Matrix4f matrix4f = posestack$pose.pose();
                Matrix3f matrix3f = posestack$pose.normal();
                LayerPetOverlays.vertex(vertexconsumer, matrix4f, posestack$pose, 240, 0.0f, 0, 0, 1, 1.0f);
                LayerPetOverlays.vertex(vertexconsumer, matrix4f, posestack$pose, 240, 1.0f, 0, 1, 1, 1.0f);
                LayerPetOverlays.vertex(vertexconsumer, matrix4f, posestack$pose, 240, 1.0f, 1, 1, 0, 1.0f);
                LayerPetOverlays.vertex(vertexconsumer, matrix4f, posestack$pose, 240, 0.0f, 1, 0, 0, 1.0f);
                matrixStackIn.popPose();
            }
        }
    }

    private float getPunchFor(LivingEntity living, int i, float partialTicks) {
        int[] arr = TameableUtils.getShadowPunchTimes(living);
        if (arr.length > i) {
            if (ClientGameEvents.shadowPunchRenderData.containsKey(living) && ClientGameEvents.shadowPunchRenderData.get(living).length > i) {
                int[] prevArr = ClientGameEvents.shadowPunchRenderData.get(living);
                return (float)prevArr[i] + (float)(arr[i] - prevArr[i]) * partialTicks;
            }
            return arr[i];
        }
        return 0.0f;
    }

    private void renderVoidCloudCube(Entity entity, PoseStack poseStack, VertexConsumer consumer) {
        Matrix4f cubeAt = poseStack.last().pose();
        this.renderVoidCloudFace(entity, cubeAt, consumer, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, Direction.SOUTH);
        this.renderVoidCloudFace(entity, cubeAt, consumer, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, Direction.NORTH);
        this.renderVoidCloudFace(entity, cubeAt, consumer, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, Direction.EAST);
        this.renderVoidCloudFace(entity, cubeAt, consumer, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, Direction.WEST);
        this.renderVoidCloudFace(entity, cubeAt, consumer, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, Direction.DOWN);
        this.renderVoidCloudFace(entity, cubeAt, consumer, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, Direction.UP);
    }

    private void renderVoidCloudFace(Entity entity, Matrix4f p_173696_, VertexConsumer p_173697_, float p_173698_, float p_173699_, float p_173700_, float p_173701_, float p_173702_, float p_173703_, float p_173704_, float p_173705_, Direction p_173706_) {
        p_173697_.addVertex(p_173696_, p_173698_, p_173700_, p_173702_).setOverlay(240);
        p_173697_.addVertex(p_173696_, p_173699_, p_173700_, p_173703_).setOverlay(240);
        p_173697_.addVertex(p_173696_, p_173699_, p_173701_, p_173704_).setOverlay(240);
        p_173697_.addVertex(p_173696_, p_173698_, p_173701_, p_173705_).setOverlay(240);
    }

    static {
        Random random = new Random(500L);
        for (int i = 0; i < 14; ++i) {
            LayerPetOverlays.CLOUD_OFFSETS[i] = new Vec3((double)(random.nextFloat() - 0.5f), (double)(0.2f * (random.nextFloat() - 0.5f)), (double)(random.nextFloat() - 0.5f)).scale((double)1.2f);
            LayerPetOverlays.CLOUD_SCALES[i] = new Vec3((double)(0.6f + random.nextFloat() * 0.2f), (double)(0.4f + random.nextFloat() * 0.2f), (double)(0.4f + random.nextFloat() * 0.2f));
        }
    }
}

