/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pet_home.client.render;

import com.github.yzqdev.pet_home.client.model.RecallBallModel;
import com.github.yzqdev.pet_home.server.entity.RecallBallEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;

public class RecallBallRender
extends EntityRenderer<RecallBallEntity> {
    private RecallBallModel recallBallModel = new RecallBallModel();
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"pet_home", (String)"textures/recall_ball.png");

    public RecallBallRender(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn);
    }

    public void render(RecallBallEntity entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light) {
        super.render((Entity)entity, yaw, partialTicks, poseStack, buffer, light);
        poseStack.pushPose();
        poseStack.mulPose(new Quaternionf().rotateX((float)Math.PI));
        poseStack.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entity.yRotO, (float)entity.getYRot())));
        poseStack.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entity.xRotO, (float)entity.getXRot())));
        VertexConsumer vertexconsumer = buffer.getBuffer(this.recallBallModel.renderType(this.getTextureLocation(entity)));
        poseStack.translate(0.0f, -1.65f, 0.0f);
        this.recallBallModel.animateBall(entity, partialTicks);
        this.recallBallModel.renderToBuffer(poseStack, vertexconsumer, light, OverlayTexture.NO_OVERLAY, 1);
        poseStack.popPose();
    }

    @NotNull
    public ResourceLocation getTextureLocation(RecallBallEntity entity) {
        return TEXTURE;
    }
}

