/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pet_home.client.render;

import com.github.yzqdev.pet_home.server.entity.FeatherEntity;
import com.github.yzqdev.pet_home.server.item.PHItemRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;

public class RenderFeather
extends EntityRenderer<FeatherEntity> {
    private ItemStack feather = new ItemStack((ItemLike)Items.FEATHER);

    public RenderFeather(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn);
    }

    public void render(FeatherEntity entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light) {
        super.render((Entity)entity, yaw, partialTicks, poseStack, buffer, light);
        Player player = entity.getPlayerOwner();
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.1f, 0.0f);
        poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        poseStack.mulPose(new Quaternionf().rotateZ(0.61086524f));
        Minecraft.getInstance().getItemRenderer().renderStatic(this.feather, ItemDisplayContext.GROUND, light, OverlayTexture.NO_OVERLAY, poseStack, buffer, entity.level(), entity.getId());
        poseStack.popPose();
        if (player != null) {
            float f3;
            double d6;
            double d5;
            double d4;
            poseStack.pushPose();
            int i = player.getMainArm() == HumanoidArm.RIGHT ? 1 : -1;
            ItemStack itemstack = player.getMainHandItem();
            if (!itemstack.is((Item)PHItemRegistry.FEATHER_ON_A_STICK.get())) {
                i = -i;
            }
            float f = player.getAttackAnim(partialTicks);
            float f1 = Mth.sin((float)(Mth.sqrt((float)f) * (float)Math.PI));
            float f2 = Mth.lerp((float)partialTicks, (float)player.yBodyRotO, (float)player.yBodyRot) * ((float)Math.PI / 180);
            double d0 = Mth.sin((float)f2);
            double d1 = Mth.cos((float)f2);
            double d2 = (double)i * 0.35;
            double d3 = 0.8;
            if ((this.entityRenderDispatcher.options == null || this.entityRenderDispatcher.options.getCameraType().isFirstPerson()) && player == Minecraft.getInstance().player) {
                double d7 = 960.0 / (double)((Integer)this.entityRenderDispatcher.options.fov().get()).intValue();
                Vec3 vec3 = this.entityRenderDispatcher.camera.getNearPlane().getPointOnPlane((float)i * 0.525f, -0.1f);
                vec3 = vec3.scale(d7);
                vec3 = vec3.yRot(f1 * 0.5f);
                vec3 = vec3.xRot(-f1 * 0.7f);
                d4 = Mth.lerp((double)partialTicks, (double)player.xo, (double)player.getX()) + vec3.x;
                d5 = Mth.lerp((double)partialTicks, (double)player.yo, (double)player.getY()) + vec3.y;
                d6 = Mth.lerp((double)partialTicks, (double)player.zo, (double)player.getZ()) + vec3.z;
                f3 = player.getEyeHeight();
            } else {
                d4 = Mth.lerp((double)partialTicks, (double)player.xo, (double)player.getX()) - d1 * d2 - d0 * 0.8;
                d5 = player.yo + (double)player.getEyeHeight() + (player.getY() - player.yo) * (double)partialTicks - 0.55;
                d6 = Mth.lerp((double)partialTicks, (double)player.zo, (double)player.getZ()) - d0 * d2 + d1 * 0.8;
                f3 = player.isCrouching() ? -0.1875f : 0.0f;
            }
            double d9 = Mth.lerp((double)partialTicks, (double)entity.xo, (double)entity.getX());
            double d10 = Mth.lerp((double)partialTicks, (double)entity.yo, (double)entity.getY()) + 0.25;
            double d8 = Mth.lerp((double)partialTicks, (double)entity.zo, (double)entity.getZ());
            float f4 = (float)(d4 - d9);
            float f5 = (float)(d5 - d10) + f3;
            float f6 = (float)(d6 - d8);
            VertexConsumer vertexconsumer1 = buffer.getBuffer(RenderType.lineStrip());
            PoseStack.Pose posestack$pose1 = poseStack.last();
            int j = 16;
            for (int k = 0; k <= 16; ++k) {
                RenderFeather.stringVertex(f4, f5, f6, vertexconsumer1, posestack$pose1, RenderFeather.fraction(k, 16), RenderFeather.fraction(k + 1, 16));
            }
            poseStack.popPose();
        }
    }

    public ResourceLocation getTextureLocation(FeatherEntity entity) {
        return null;
    }

    private static float fraction(int p_114691_, int p_114692_) {
        return (float)p_114691_ / (float)p_114692_;
    }

    private static void stringVertex(float p_174119_, float p_174120_, float p_174121_, VertexConsumer p_174122_, PoseStack.Pose p_174123_, float p_174124_, float p_174125_) {
        float f = p_174119_ * p_174124_;
        float f1 = p_174120_ * (p_174124_ * p_174124_ + p_174124_) * 0.5f + 0.25f;
        float f2 = p_174121_ * p_174124_;
        float f3 = p_174119_ * p_174125_ - f;
        float f4 = p_174120_ * (p_174125_ * p_174125_ + p_174125_) * 0.5f + 0.25f - f1;
        float f5 = p_174121_ * p_174125_ - f2;
        float f6 = Mth.sqrt((float)(f3 * f3 + f4 * f4 + f5 * f5));
        p_174122_.addVertex(p_174123_.pose(), f, f1, f2).setColor(0, 0, 0, 255).setNormal(p_174123_, f3 /= f6, f4 /= f6, f5 /= f6);
    }
}

