/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pet_home.client.render;

import com.github.yzqdev.pet_home.server.entity.GiantBubbleEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class RenderGiantBubble
extends EntityRenderer<GiantBubbleEntity> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"pet_home", (String)"textures/giant_bubble.png");
    private static final RenderType RENDER_TYPE = RenderType.entityCutoutNoCull((ResourceLocation)TEXTURE);

    public RenderGiantBubble(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn);
    }

    public void render(GiantBubbleEntity entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light) {
        super.render((Entity)entity, yaw, partialTicks, poseStack, buffer, light);
        poseStack.pushPose();
        float age = (float)entity.tickCount + partialTicks;
        float bubbleWobbleXZ = (float)Math.sin(age * 0.3f) * 0.2f;
        float bubbleWobbleY = (float)Math.cos(age * 0.3f) * 0.2f;
        poseStack.scale(2.6f + bubbleWobbleXZ, 2.6f + bubbleWobbleY, 2.6f + bubbleWobbleXZ);
        poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        poseStack.mulPose(new Quaternionf().rotateY((float)Math.PI));
        PoseStack.Pose posestack$pose = poseStack.last();
        Matrix4f matrix4f = posestack$pose.pose();
        Matrix3f matrix3f = posestack$pose.normal();
        VertexConsumer vertexconsumer = buffer.getBuffer(RENDER_TYPE);
        RenderGiantBubble.vertex(vertexconsumer, matrix4f, posestack$pose, light, 0.0f, 0, 0, 1);
        RenderGiantBubble.vertex(vertexconsumer, matrix4f, posestack$pose, light, 1.0f, 0, 1, 1);
        RenderGiantBubble.vertex(vertexconsumer, matrix4f, posestack$pose, light, 1.0f, 1, 1, 0);
        RenderGiantBubble.vertex(vertexconsumer, matrix4f, posestack$pose, light, 0.0f, 1, 0, 0);
        poseStack.popPose();
    }

    private static void vertex(VertexConsumer p_114090_, Matrix4f p_114091_, PoseStack.Pose p_114092_, int p_114093_, float p_114094_, int p_114095_, int p_114096_, int p_114097_) {
        p_114090_.addVertex(p_114091_, p_114094_ - 0.5f, (float)p_114095_ - 0.25f, 0.0f).setColor(255, 255, 255, 255).setUv((float)p_114096_, (float)p_114097_).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(p_114093_, p_114093_).setNormal(p_114092_, 0.0f, 1.0f, 0.0f);
    }

    public ResourceLocation getTextureLocation(GiantBubbleEntity entity) {
        return TEXTURE;
    }
}

