/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pet_home.compat.jade;

import com.github.yzqdev.pet_home.datagen.LangDefinition;
import com.github.yzqdev.pet_home.util.TameableUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public enum PetHomeComponentProvider implements IEntityComponentProvider
{
    INSTANCE;


    public void appendTooltip(ITooltip iTooltip, EntityAccessor entityAccessor, IPluginConfig iPluginConfig) {
        Entity entity = entityAccessor.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            List<Component> enchants = TameableUtils.getEnchantDescriptions(livingEntity);
            BlockPos hasPetbed = TameableUtils.getPetBedPos(livingEntity);
            if (hasPetbed != null) {
                iTooltip.add((Component)Component.translatable((String)LangDefinition.ConstantMsg.has_pet_bed_at_pos, (Object[])new Object[]{hasPetbed.toShortString()}).withStyle(ChatFormatting.RED));
            }
            if (enchants.size() > 1) {
                for (Component enchant : enchants) {
                    iTooltip.add(enchant);
                }
            }
        }
    }

    public ResourceLocation getUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"pet_home", (String)"collar_tag");
    }
}

