/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pet_home.datagen.loot;

import com.github.yzqdev.pet_home.datagen.loot.LootTableGen;
import com.github.yzqdev.pet_home.datagen.loot.PHLootModifier;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.data.GlobalLootModifierProvider;
import net.neoforged.neoforge.common.loot.AddTableLootModifier;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootTableIdCondition;

public class GlobalLootModifier
extends GlobalLootModifierProvider {
    public GlobalLootModifier(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, "pet_home");
    }

    public void start() {
        this.add("sinister_carrot", (IGlobalLootModifier)new PHLootModifier(new LootItemCondition[]{new LootTableIdCondition.Builder(BuiltInLootTables.WOODLAND_MANSION.location()).build()}, 0), new ICondition[0]);
        this.add("ore_scenting_enchanted_book", (IGlobalLootModifier)new PHLootModifier(new LootItemCondition[]{new LootTableIdCondition.Builder(BuiltInLootTables.ABANDONED_MINESHAFT.location()).build()}, 4), new ICondition[0]);
        this.add("bubbling_enchanted_book", (IGlobalLootModifier)new PHLootModifier(new LootItemCondition[]{new LootTableIdCondition.Builder(BuiltInLootTables.BURIED_TREASURE.location()).build()}, 1), new ICondition[0]);
        this.add("vampirism_enchanted_book", (IGlobalLootModifier)new PHLootModifier(new LootItemCondition[]{new LootTableIdCondition.Builder(BuiltInLootTables.WOODLAND_MANSION.location()).build()}, 2), new ICondition[0]);
        this.add("blazing_protection_enchanted_book", (IGlobalLootModifier)new PHLootModifier(new LootItemCondition[]{new LootTableIdCondition.Builder(BuiltInLootTables.NETHER_BRIDGE.location()).build()}, 6), new ICondition[0]);
        this.add("share_enchanted_book", (IGlobalLootModifier)new PHLootModifier(new LootItemCondition[]{new LootTableIdCondition.Builder(BuiltInLootTables.END_CITY_TREASURE.location()).build()}, 3), new ICondition[0]);
        this.add("sonic_boom_enchanted_book", (IGlobalLootModifier)new PHLootModifier(new LootItemCondition[]{new LootTableIdCondition.Builder(BuiltInLootTables.ANCIENT_CITY.location()).build()}, 5), new ICondition[0]);
        this.add("paralysis_enchanted_book", (IGlobalLootModifier)new PHLootModifier(new LootItemCondition[]{AnyOfCondition.anyOf((LootItemCondition.Builder[])this.manyChests(BuiltInLootTables.ABANDONED_MINESHAFT, BuiltInLootTables.DESERT_PYRAMID, BuiltInLootTables.FISHING, BuiltInLootTables.SPAWN_BONUS_CHEST)).build()}, 7), new ICondition[0]);
        this.add("tough_enchant_boot", (IGlobalLootModifier)new AddTableLootModifier(new LootItemCondition[]{LootTableIdCondition.builder((ResourceLocation)BuiltInLootTables.ABANDONED_MINESHAFT.location()).build()}, LootTableGen.PET_PROTECTION_TABLE), new ICondition[0]);
    }

    @SafeVarargs
    private LootTableIdCondition.Builder[] manyChests(ResourceKey<LootTable> ... lootablekey) {
        return (LootTableIdCondition.Builder[])Arrays.stream(lootablekey).map(i -> LootTableIdCondition.builder((ResourceLocation)i.location())).toArray(LootTableIdCondition.Builder[]::new);
    }
}

