/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pet_home.datagen.loot;

import com.github.yzqdev.pet_home.datagen.ModEnchantments;
import com.github.yzqdev.pet_home.datagen.ModTags;
import com.github.yzqdev.pet_home.server.item.PHItemRegistry;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.EnchantRandomlyFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetEnchantmentsFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class LootTableGen {
    public static final ResourceKey<LootTable> PET_LOOT_TABLE = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"pet_home", (String)"chests/petshop_chest"));
    public static final ResourceKey<LootTable> PET_PROTECTION_TABLE = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"pet_home", (String)"chests/pet_protection_loot"));

    private ItemStack enchantedBook(ResourceKey<Enchantment> enchantmentKey, RandomSource randomSource, LootContext context) {
        Registry reg = context.getLevel().registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        Enchantment enchant = (Enchantment)reg.get(enchantmentKey);
        int maxLevels = enchant.getMaxLevel();
        return EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance(reg.wrapAsHolder((Object)enchant), maxLevels > 1 ? 1 + randomSource.nextInt(maxLevels - 1) : 1));
    }

    public static class BlockLootTables
    extends BlockLootSubProvider {
        public final Set<Block> knownBlocks = new HashSet<Block>();

        public BlockLootTables(HolderLookup.Provider provider) {
            super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
        }

        public void generate() {
        }

        public void add(Block block, LootTable.Builder builder) {
            this.knownBlocks.add(block);
            super.add(block, builder);
        }

        public Iterable<Block> getKnownBlocks() {
            return this.knownBlocks;
        }
    }

    public record ChestLootTables(HolderLookup.Provider provider) implements LootTableSubProvider
    {
        private Holder<Enchantment> getEnchantment(ResourceKey<Enchantment> key) {
            return this.provider.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(key);
        }

        public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> consumer) {
            consumer.accept(PET_PROTECTION_TABLE, LootTable.lootTable().withPool(LootPool.lootPool().name("enchant").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceCondition.randomChance((float)0.05f)).add(this.enchantItem(Items.BOOK, ModEnchantments.TOUGH, 1, 4))));
            consumer.accept(PET_LOOT_TABLE, LootTable.lootTable().withPool(LootPool.lootPool().name("rotten_apple").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceCondition.randomChance((float)0.05f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)PHItemRegistry.ROTTEN_APPLE.get())))).withPool(LootPool.lootPool().name("sinister_carrot").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceCondition.randomChance((float)0.05f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)PHItemRegistry.SINISTER_CARROT.get())))).withPool(LootPool.lootPool().name("enchant").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceCondition.randomChance((float)0.15f)).add(this.enchantItem(Items.BOOK, ModEnchantments.BUBBLING, 1, 2)).add(this.enchantItem(Items.BOOK, ModEnchantments.AMPHIBIOUS, 1, 1)).add(this.enchantItem(Items.BOOK, ModEnchantments.VAMPIRE, 1, 2))).withPool(LootPool.lootPool().name("petshop_chest_collars").setRolls((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)).when(LootItemRandomChanceCondition.randomChance((float)0.5f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)PHItemRegistry.COLLAR_TAG.get())).setWeight(1).apply((LootItemFunction.Builder)EnchantRandomlyFunction.randomEnchantment().withOneOf((HolderSet)this.provider.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(ModTags.TradableEnchantmentKey)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)PHItemRegistry.COLLAR_TAG.get())).setWeight(2))).withPool(LootPool.lootPool().name("petshop_chest").setRolls((NumberProvider)UniformGenerator.between((float)5.0f, (float)12.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.TROPICAL_FISH).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)5.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BONE).setWeight(4).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LEAD).setWeight(4).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.IRON_HORSE_ARMOR).setWeight(2).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.AXOLOTL_BUCKET).setWeight(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.TADPOLE_BUCKET).setWeight(2)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.EMERALD).setWeight(3).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CARROT).setWeight(4).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))))));
        }

        private LootPoolEntryContainer.Builder<?> enchantItem(Item item, ResourceKey<Enchantment> enchant, int weight, Integer maxLevel) {
            Holder<Enchantment> enchantment = this.getEnchantment(enchant);
            return LootItem.lootTableItem((ItemLike)item).setWeight(weight).apply((LootItemFunction.Builder)new SetEnchantmentsFunction.Builder(true).withEnchantment(enchantment, (NumberProvider)UniformGenerator.between((float)1.0f, (float)maxLevel.intValue())));
        }
    }
}

