/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pet_home.datagen.loot;

import com.github.yzqdev.pet_home.PetHomeConfig;
import com.github.yzqdev.pet_home.datagen.ModEnchantments;
import com.github.yzqdev.pet_home.server.item.PHItemRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import javax.annotation.Nonnull;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;

public class PHLootModifier
extends LootModifier {
    public static final MapCodec<PHLootModifier> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)LOOT_CONDITIONS_CODEC.fieldOf("conditions").forGetter(lm -> lm.conditions), (App)Codec.INT.fieldOf("loot_type").orElse((Object)0).forGetter(configuration -> configuration.lootType)).apply((Applicative)inst, PHLootModifier::new));
    private final int lootType;

    protected PHLootModifier(LootItemCondition[] conditionsIn, int lootType) {
        super(conditionsIn);
        this.lootType = lootType;
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        switch (this.lootType) {
            case 0: {
                if (!((double)context.getRandom().nextFloat() < PetHomeConfig.sinisterCarrotLootChance)) break;
                generatedLoot.add((Object)new ItemStack((ItemLike)PHItemRegistry.SINISTER_CARROT.get(), context.getRandom().nextInt(1, 2)));
                break;
            }
            case 1: {
                if (!((double)context.getRandom().nextFloat() < PetHomeConfig.bubblingLootChance)) break;
                generatedLoot.add((Object)this.enchantedBook(ModEnchantments.BUBBLING, context.getRandom(), context));
                break;
            }
            case 2: {
                if (!((double)context.getRandom().nextFloat() < PetHomeConfig.vampirismLootChance)) break;
                generatedLoot.add((Object)this.enchantedBook(ModEnchantments.VAMPIRE, context.getRandom(), context));
                break;
            }
            case 3: {
                if (!((double)context.getRandom().nextFloat() < PetHomeConfig.shareLootChance)) break;
                generatedLoot.add((Object)this.enchantedBook(ModEnchantments.SHARE, context.getRandom(), context));
                break;
            }
            case 4: {
                if (!((double)context.getRandom().nextFloat() < PetHomeConfig.oreScentingLootChance)) break;
                generatedLoot.add((Object)this.enchantedBook(ModEnchantments.ORE_SCENTING, context.getRandom(), context));
                break;
            }
            case 5: {
                if (!((double)context.getRandom().nextFloat() < PetHomeConfig.sonicBoomLootChance)) break;
                generatedLoot.add((Object)this.enchantedBook(ModEnchantments.SonicBoom, context.getRandom(), context));
                break;
            }
            case 6: {
                if (!((double)context.getRandom().nextFloat() < PetHomeConfig.blazingProtectionLootChance)) break;
                generatedLoot.add((Object)this.enchantedBook(ModEnchantments.BLAZING_PROTECTION, context.getRandom(), context));
                break;
            }
            case 7: {
                if (!((double)context.getRandom().nextFloat() < PetHomeConfig.paralysisLootChance)) break;
                generatedLoot.add((Object)this.enchantedBook(ModEnchantments.PARALYSIS, context.getRandom(), context));
            }
        }
        return generatedLoot;
    }

    private ItemStack enchantedBook(ResourceKey<Enchantment> enchantmentKey, RandomSource randomSource, LootContext context) {
        Registry reg = context.getLevel().registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        Enchantment enchant = (Enchantment)reg.get(enchantmentKey);
        int maxLevels = enchant.getMaxLevel();
        return EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance(reg.wrapAsHolder((Object)enchant), maxLevels > 1 ? 1 + randomSource.nextInt(maxLevels - 1) : 1));
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

