/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pet_home.network;

import com.github.yzqdev.pet_home.ModConstants;
import com.github.yzqdev.pet_home.network.PropertiesMessage;
import com.github.yzqdev.pet_home.util.CitadelEntityData;
import com.mojang.logging.LogUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.slf4j.Logger;

public class ClientPayloadHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ClientPayloadHandler INSTANCE = new ClientPayloadHandler();

    public static ClientPayloadHandler getInstance() {
        return INSTANCE;
    }

    public static void handleData(PropertiesMessage data, IPayloadContext context) {
        context.enqueueWork(() -> {
            CompoundTag compound = data.compound();
            int entityID = data.entityID();
            String propertyID = data.propertyID();
            if (compound != null && Minecraft.getInstance().level != null) {
                Entity entity = Minecraft.getInstance().level.getEntity(entityID);
                if (propertyID.equals(ModConstants.entityDataTagUpdate) && entity instanceof LivingEntity) {
                    CitadelEntityData.setCitadelTag((LivingEntity)entity, compound);
                }
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"my_mod.networking.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }
}

