/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pet_home.network;

import com.github.yzqdev.pet_home.ModConstants;
import com.github.yzqdev.pet_home.network.PropertiesMessage;
import com.github.yzqdev.pet_home.util.CitadelEntityData;
import com.mojang.logging.LogUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.slf4j.Logger;

public class ServerPayloadHandler {
    private static final ServerPayloadHandler INSTANCE = new ServerPayloadHandler();
    private static final Logger LOGGER = LogUtils.getLogger();

    public static ServerPayloadHandler getInstance() {
        return INSTANCE;
    }

    public static void handleData(PropertiesMessage data, IPayloadContext context) {
        context.enqueueWork(() -> {
            LOGGER.info(String.valueOf(data.entityID()));
            Level level = context.player().level();
            Entity e = level.getEntity(data.entityID());
            if (e instanceof LivingEntity && data.propertyID().equals(ModConstants.entityDataTagUpdate)) {
                CitadelEntityData.setCitadelTag((LivingEntity)e, data.compound());
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"my_mod.networking.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }
}

