/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pet_home.server;

import com.github.yzqdev.pet_home.PetHomeConfig;
import com.github.yzqdev.pet_home.client.ClientGameEvents;
import com.github.yzqdev.pet_home.datagen.ModEnchantments;
import com.github.yzqdev.pet_home.server.PHDataComponents;
import com.github.yzqdev.pet_home.server.block.PetBedBlock;
import com.github.yzqdev.pet_home.server.block.PetBedBlockEntity;
import com.github.yzqdev.pet_home.server.entity.ChainLightningEntity;
import com.github.yzqdev.pet_home.server.entity.GiantBubbleEntity;
import com.github.yzqdev.pet_home.server.entity.PHEntityRegistry;
import com.github.yzqdev.pet_home.server.entity.PHVillagerRegistry;
import com.github.yzqdev.pet_home.server.entity.PsychicWallEntity;
import com.github.yzqdev.pet_home.server.entity.RecallBallEntity;
import com.github.yzqdev.pet_home.server.item.NetItem;
import com.github.yzqdev.pet_home.server.item.PHItemRegistry;
import com.github.yzqdev.pet_home.server.item.Type;
import com.github.yzqdev.pet_home.server.misc.LanternRequest;
import com.github.yzqdev.pet_home.server.misc.ModEffects;
import com.github.yzqdev.pet_home.server.misc.PHDamageTypes;
import com.github.yzqdev.pet_home.server.misc.PHParticleRegistry;
import com.github.yzqdev.pet_home.server.misc.PHSoundRegistry;
import com.github.yzqdev.pet_home.server.misc.PHWorldData;
import com.github.yzqdev.pet_home.server.misc.RespawnRequest;
import com.github.yzqdev.pet_home.server.misc.trades.BuyingItemTrade;
import com.github.yzqdev.pet_home.server.misc.trades.EnchantItemTrade;
import com.github.yzqdev.pet_home.server.misc.trades.SellingItemTrade;
import com.github.yzqdev.pet_home.server.misc.trades.SellingRandomEnchantedBook;
import com.github.yzqdev.pet_home.util.FriendlyFireCommon;
import com.github.yzqdev.pet_home.util.LivingUtils;
import com.github.yzqdev.pet_home.util.TameableUtils;
import com.github.yzqdev.pet_home.worldgen.VillageHouseManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.SkeletonHorse;
import net.minecraft.world.entity.animal.horse.ZombieHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.EntityInvulnerabilityCheckEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import net.neoforged.neoforge.event.entity.EntityMountEvent;
import net.neoforged.neoforge.event.entity.EntityTeleportEvent;
import net.neoforged.neoforge.event.entity.EntityTravelToDimensionEvent;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.item.ItemExpireEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;
import org.antlr.v4.runtime.misc.Triple;

@EventBusSubscriber(modid="pet_home", bus=EventBusSubscriber.Bus.GAME)
public class ServerProxy {
    public static List<Triple<Entity, ServerLevel, UUID>> teleportingPets = new ArrayList<Triple<Entity, ServerLevel, UUID>>();
    private static final String[] KEY_TYPES = new String[]{"desc", "description", "info"};

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        if (TameableUtils.isTamed((Entity)event.getEntity()) && TameableUtils.getPetBedPos(event.getEntity()) != null) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void serverStart(ServerAboutToStartEvent event) {
        RegistryAccess.Frozen registryAccess = event.getServer().registryAccess();
        VillageHouseManager.addAllHouses((RegistryAccess)registryAccess);
    }

    @SubscribeEvent
    public static void onTameHurt(EntityInvulnerabilityCheckEvent event) {
    }

    @SubscribeEvent
    public static void onServerTick(LevelTickEvent.Post tick) {
        if (!tick.getLevel().isClientSide && tick.getLevel() instanceof ServerLevel) {
            for (Triple<Entity, ServerLevel, UUID> triple : teleportingPets) {
                Entity entity = (Entity)triple.a;
                ServerLevel endpointWorld = (ServerLevel)triple.b;
                UUID ownerUUID = (UUID)triple.c;
                entity.unRide();
                entity.setLevel((Level)endpointWorld);
                Player player = endpointWorld.getPlayerByUUID(ownerUUID);
                if (player == null) continue;
                Entity teleportedEntity = entity.getType().create((Level)endpointWorld);
                if (teleportedEntity != null) {
                    teleportedEntity.restoreFrom(entity);
                    Vec3 toPos = player.position();
                    EntityDimensions dimensions = entity.getDimensions(entity.getPose());
                    AABB suffocationBox = new AABB((double)(-dimensions.width() / 2.0f), 0.0, (double)(-dimensions.width() / 2.0f), (double)(dimensions.width() / 2.0f), (double)dimensions.height(), (double)(dimensions.width() / 2.0f));
                    while (!endpointWorld.noCollision(entity, suffocationBox.move(toPos.x, toPos.y, toPos.z)) && toPos.y < 300.0) {
                        toPos = toPos.add(0.0, 1.0, 0.0);
                    }
                    teleportedEntity.moveTo(toPos.x, toPos.y, toPos.z, entity.getYRot(), entity.getXRot());
                    teleportedEntity.setYHeadRot(entity.getYHeadRot());
                    teleportedEntity.fallDistance = 0.0f;
                    teleportedEntity.setPortalCooldown();
                    endpointWorld.addFreshEntity(teleportedEntity);
                }
                entity.remove(Entity.RemovalReason.DISCARDED);
            }
            teleportingPets.clear();
        }
    }

    @SubscribeEvent
    public static void onEntityTravelToDimension(EntityTravelToDimensionEvent event) {
        Level level;
        if (!event.isCanceled() && (level = event.getEntity().level()) instanceof ServerLevel) {
            MinecraftServer server;
            ServerLevel toLevel;
            ServerLevel serverLevel = (ServerLevel)level;
            if (event.getEntity() instanceof Player && (toLevel = (server = serverLevel.getServer()).getLevel(event.getDimension())) != null) {
                ServerProxy.teleportNearbyPets((Player)event.getEntity(), event.getEntity().position(), event.getEntity().position(), event.getEntity().level(), (Level)toLevel);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityTeleport(EntityTeleportEvent event) {
        if (event.getEntity() instanceof Player) {
            ServerProxy.teleportNearbyPets((Player)event.getEntity(), event.getPrev(), event.getTarget(), event.getEntity().level(), event.getEntity().level());
        }
    }

    private static void teleportNearbyPets(Player owner, Vec3 fromPos, Vec3 toPos, Level fromLevel, Level toLevel) {
        double dist = 20.0;
        boolean removeAndReadd = fromLevel.dimension() != toLevel.dimension();
        Predicate<Entity> enchantedPet = animal -> animal instanceof Mob && TameableUtils.isPetOf(owner, animal) && TameableUtils.isValidTeleporter((LivingEntity)owner, (Mob)animal);
        for (Mob entity : fromLevel.getEntitiesOfClass(Mob.class, new AABB(fromPos.x - dist, fromPos.y - dist, fromPos.z - dist, fromPos.x + dist, fromPos.y + dist, fromPos.z + dist), EntitySelector.NO_SPECTATORS.and(enchantedPet))) {
            if (removeAndReadd) {
                teleportingPets.add((Triple<Entity, ServerLevel, UUID>)new Triple((Object)entity, (Object)toLevel, (Object)owner.getUUID()));
                continue;
            }
            EntityDimensions dimensions = entity.getDimensions(entity.getPose());
            AABB suffocationBox = new AABB((double)(-dimensions.width() / 2.0f), 0.0, (double)(-dimensions.width() / 2.0f), (double)(dimensions.width() / 2.0f), (double)dimensions.height(), (double)(dimensions.width() / 2.0f));
            while (!toLevel.noCollision((Entity)entity, suffocationBox.move(toPos.x, toPos.y, toPos.z)) && toPos.y < 300.0) {
                toPos = toPos.add(0.0, 1.0, 0.0);
            }
            entity.fallDistance = 0.0f;
            ChunkPos chunkpos = new ChunkPos(BlockPos.containing((double)toPos.x, (double)toPos.y, (double)toPos.z));
            ((ServerLevel)entity.level()).getChunkSource().addRegionTicket(TicketType.POST_TELEPORT, chunkpos, 0, (Object)entity.getId());
            entity.level().getChunk(chunkpos.x, chunkpos.z);
            entity.teleportTo(toPos.x, toPos.y, toPos.z);
            entity.setPortalCooldown();
        }
    }

    @SubscribeEvent
    public static void onProjectileImpactEvent(ProjectileImpactEvent event) {
        if (event.getRayTraceResult() instanceof EntityHitResult) {
            Player player;
            Entity hit = ((EntityHitResult)event.getRayTraceResult()).getEntity();
            if (event.getProjectile().getOwner() instanceof Player && TameableUtils.isPetOf(player = (Player)event.getProjectile().getOwner(), hit)) {
                event.setCanceled(true);
            }
            if (TameableUtils.isTamed(hit)) {
                AbstractArrow arrow;
                Entity entity = event.getEntity();
                if (entity instanceof AbstractArrow && (arrow = (AbstractArrow)entity).getPierceLevel() > 0) {
                    arrow.setPierceLevel((byte)0);
                    arrow.remove(Entity.RemovalReason.DISCARDED);
                    event.setCanceled(true);
                    return;
                }
                if (TameableUtils.hasEnchant((LivingEntity)hit, ModEnchantments.DEFLECTION)) {
                    event.setCanceled(true);
                    float xRot = event.getProjectile().getXRot();
                    float yRot = event.getProjectile().yRotO;
                    Vec3 vec3 = event.getProjectile().position().subtract(hit.position()).normalize().scale((double)(hit.getBbWidth() + 0.5f));
                    Vec3 vec32 = hit.position().add(vec3);
                    hit.level().addParticle((ParticleOptions)PHParticleRegistry.DEFLECTION_SHIELD.get(), vec32.x, vec32.y, vec32.z, (double)xRot, (double)yRot, 0.0);
                    event.getProjectile().setDeltaMovement(event.getProjectile().getDeltaMovement().scale(-0.2));
                    event.getProjectile().setYRot(yRot + 180.0f);
                    event.getProjectile().setXRot(xRot + 180.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityMount(EntityMountEvent event) {
        if (event.getEntityBeingMounted() instanceof GiantBubbleEntity && event.isDismounting() && event.getEntityBeingMounted().isAlive()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onLivingDamage(LivingIncomingDamageEvent event) {
        Entity entity;
        Level level = event.getEntity().level();
        if (!level.isClientSide() && FriendlyFireCommon.preventAttack((Entity)event.getEntity(), event.getSource(), event.getAmount())) {
            event.setCanceled(true);
            event.getEntity().setLastHurtByMob(null);
            entity = event.getSource().getEntity();
            if (entity instanceof LivingEntity) {
                LivingEntity trueSource = (LivingEntity)entity;
                trueSource.setLastHurtByMob(null);
            }
        }
        if ((entity = event.getSource().getEntity()) instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            if (TameableUtils.isTamed((Entity)event.getEntity()) && !event.getSource().is(PHDamageTypes.SIPHON)) {
                UUID owner;
                Entity owner2;
                int bars;
                LivingEntity beingAttacked = event.getEntity();
                boolean flag = false;
                if (TameableUtils.hasEnchant(event.getEntity(), ModEnchantments.BLAZING_PROTECTION) && (bars = TameableUtils.getBlazingProtectionBars(event.getEntity())) > 0) {
                    LivingEntity livingAttacker;
                    if (attacker instanceof LivingEntity && !TameableUtils.hasSameOwnerAs(livingAttacker = attacker, (Entity)event.getEntity())) {
                        livingAttacker.igniteForTicks(20 * (5 + event.getEntity().getRandom().nextInt(3)));
                        livingAttacker.knockback(0.4, event.getEntity().getX() - livingAttacker.getX(), event.getEntity().getZ() - livingAttacker.getZ());
                    }
                    event.setCanceled(true);
                    flag = true;
                    if (attacker != null) {
                        for (int i = 0; i < 3 + event.getEntity().getRandom().nextInt(3); ++i) {
                            attacker.level().addParticle((ParticleOptions)ParticleTypes.FLAME, event.getEntity().getRandomX((double)0.8f), event.getEntity().getRandomY(), event.getEntity().getRandomZ((double)0.8f), 0.0, 0.0, 0.0);
                        }
                    }
                    event.getEntity().playSound((SoundEvent)PHSoundRegistry.BLAZING_PROTECTION.get(), 1.0f, event.getEntity().getVoicePitch());
                    TameableUtils.setBlazingProtectionBars(event.getEntity(), bars - 1);
                    TameableUtils.setBlazingProtectionCooldown(event.getEntity(), 600);
                }
                if (TameableUtils.isTamed((Entity)event.getEntity()) && !flag && TameableUtils.hasEnchant(event.getEntity(), ModEnchantments.HEALTH_SIPHON) && (owner2 = TameableUtils.getOwnerOf((Entity)event.getEntity())) != null && owner2.isAlive() && owner2.distanceTo((Entity)event.getEntity()) < 100.0f && owner2 != event.getEntity()) {
                    owner2.hurt(event.getSource(), event.getAmount());
                    event.setCanceled(true);
                    flag = true;
                    event.getEntity().hurt(PHDamageTypes.causeSiphonDamage(owner2.level().registryAccess()), 0.0f);
                }
                if (!flag && TameableUtils.hasEnchant(event.getEntity(), ModEnchantments.TOTAL_RECALL) && (double)(event.getEntity().getHealth() - event.getAmount()) <= 2.0 && (owner = TameableUtils.getOwnerUUIDOf((Entity)event.getEntity())) != null) {
                    LivingEntity livingEntity = event.getEntity();
                    if (livingEntity instanceof Mob) {
                        Mob mob = (Mob)livingEntity;
                        mob.playAmbientSound();
                    }
                    event.getEntity().playSound(SoundEvents.ENDER_CHEST_CLOSE, 1.0f, 1.5f);
                    RecallBallEntity recallBall = (RecallBallEntity)((EntityType)PHEntityRegistry.RECALL_BALL.get()).create(event.getEntity().level());
                    recallBall.setOwnerUUID(owner);
                    CompoundTag tag = new CompoundTag();
                    event.getEntity().addAdditionalSaveData(tag);
                    recallBall.setContainedData(tag);
                    recallBall.setContainedEntityType(BuiltInRegistries.ENTITY_TYPE.getKey((Object)event.getEntity().getType()).toString());
                    recallBall.setPos(event.getEntity().getX(), Math.max(event.getEntity().getY(), (double)(event.getEntity().level().getMinBuildHeight() + 1)), event.getEntity().getZ());
                    recallBall.setYRot(event.getEntity().getYRot());
                    recallBall.setInvulnerable(true);
                    event.getEntity().stopRiding();
                    if (event.getEntity().level().addFreshEntity((Entity)recallBall)) {
                        event.getEntity().discard();
                    }
                    flag = true;
                    event.setCanceled(true);
                }
            }
            if (event.getSource().getEntity() != null && TameableUtils.isTamed(event.getSource().getEntity())) {
                List<LivingEntity> nearbyHealers;
                int lightningLevel = TameableUtils.getEnchantLevel(attacker, ModEnchantments.CHAIN_LIGHTNING);
                int bubblingLevel = TameableUtils.getEnchantLevel(attacker, ModEnchantments.BUBBLING);
                int vampireLevel = TameableUtils.getEnchantLevel(attacker, ModEnchantments.VAMPIRE);
                if (lightningLevel > 0) {
                    ChainLightningEntity lightning = (ChainLightningEntity)((EntityType)PHEntityRegistry.CHAIN_LIGHTNING.get()).create(event.getEntity().level());
                    lightning.setCreatorEntityID(attacker.getId());
                    lightning.setFromEntityID(attacker.getId());
                    lightning.setToEntityID(event.getEntity().getId());
                    lightning.copyPosition((Entity)event.getEntity());
                    lightning.setChainsLeft(3 + lightningLevel * 3);
                    event.getEntity().level().addFreshEntity((Entity)lightning);
                    event.getEntity().playSound((SoundEvent)PHSoundRegistry.CHAIN_LIGHTNING.get(), 1.0f, 1.0f);
                }
                if (vampireLevel > 0 && attacker.getHealth() < attacker.getMaxHealth()) {
                    float f = Mth.clamp((float)(event.getAmount() * (float)vampireLevel * 0.5f), (float)1.0f, (float)10.0f);
                    attacker.heal(f);
                    if (event.getEntity().level() instanceof ServerLevel) {
                        for (int i = 0; i < 5 + event.getEntity().getRandom().nextInt(3); ++i) {
                            double f1 = event.getEntity().getRandomX((double)0.7f);
                            double f2 = event.getEntity().getY((double)(0.4f + event.getEntity().getRandom().nextFloat() * 0.2f));
                            double f3 = event.getEntity().getRandomZ((double)0.7f);
                            Vec3 motion = attacker.getEyePosition().subtract(f1, f2, f3).normalize().scale((double)0.2f);
                            ((ServerLevel)event.getEntity().level()).sendParticles((ParticleOptions)((SimpleParticleType)PHParticleRegistry.VAMPIRE.get()), f1, f2, f3, 1, motion.x, motion.y, motion.z, (double)0.2f);
                        }
                    }
                }
                if (bubblingLevel > 0 && !(event.getEntity().getRootVehicle() instanceof GiantBubbleEntity) && (event.getEntity().onGround() || event.getEntity().isInWaterOrBubble() || event.getEntity().isInLava())) {
                    GiantBubbleEntity bubble = (GiantBubbleEntity)((EntityType)PHEntityRegistry.GIANT_BUBBLE.get()).create(event.getEntity().level());
                    bubble.copyPosition((Entity)event.getEntity());
                    event.getEntity().startRiding((Entity)bubble, true);
                    bubble.setpopsIn(bubblingLevel * 40 + 40);
                    event.getEntity().level().addFreshEntity((Entity)bubble);
                    event.getEntity().playSound((SoundEvent)PHSoundRegistry.GIANT_BUBBLE_INFLATE.get(), 1.0f, 1.0f);
                }
                if (TameableUtils.hasEnchant(attacker, ModEnchantments.FROST_FANG)) {
                    event.getEntity().setTicksFrozen(event.getEntity().getTicksRequiredToFreeze() + 200);
                    Vec3 vec3 = event.getEntity().getEyePosition().subtract(attacker.getEyePosition()).normalize().scale((double)(attacker.getBbWidth() + 0.5f));
                    Vec3 vec32 = attacker.getEyePosition().add(vec3);
                    for (int i = 0; i < 3 + attacker.getRandom().nextInt(3); ++i) {
                        float f1 = 0.2f * (attacker.getRandom().nextFloat() - 1.0f);
                        float f2 = 0.2f * (attacker.getRandom().nextFloat() - 1.0f);
                        float f3 = 0.2f * (attacker.getRandom().nextFloat() - 1.0f);
                        attacker.level().addParticle((ParticleOptions)ParticleTypes.SNOWFLAKE, vec32.x + (double)f1, vec32.y + (double)f2, vec32.z + (double)f3, 0.0, 0.0, 0.0);
                    }
                    TameableUtils.setFrozenTimeTag(event.getEntity(), 60);
                }
                if (!event.getEntity().level().isClientSide && TameableUtils.hasEnchant(attacker, ModEnchantments.WARPING_BITE)) {
                    for (int i = 0; i < 16; ++i) {
                        double d3 = event.getEntity().getX() + (attacker.getRandom().nextDouble() - 0.5) * 16.0;
                        double d4 = Mth.clamp((double)(event.getEntity().getY() + (double)(attacker.getRandom().nextInt(16) - 8)), (double)event.getEntity().level().getMinBuildHeight(), (double)(event.getEntity().level().getMinBuildHeight() + ((ServerLevel)event.getEntity().level()).getLogicalHeight() - 1));
                        double d5 = event.getEntity().getZ() + (attacker.getRandom().nextDouble() - 0.5) * 16.0;
                        if (!event.getEntity().randomTeleport(d3, d4, d5, true)) continue;
                        SoundEvent soundevent = event.getEntity() instanceof Fox ? SoundEvents.FOX_TELEPORT : SoundEvents.CHORUS_FRUIT_TELEPORT;
                        event.getEntity().playSound(soundevent, 1.0f, 1.0f);
                        break;
                    }
                }
                if (!event.isCanceled() && !(nearbyHealers = TameableUtils.getNearbyHealers(event.getEntity())).isEmpty()) {
                    for (LivingEntity healer : nearbyHealers) {
                        TameableUtils.setHealingAuraImpulse(healer, true);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityHurtPre(LivingDamageEvent.Pre event) {
        LivingEntity maidLiving;
        Entity maid = event.getSource().getEntity();
        LivingEntity monster = event.getEntity();
        Level level = monster.level();
        float chance = level.random.nextFloat();
        if (maid instanceof LivingEntity && TameableUtils.hasEnchant(maidLiving = (LivingEntity)maid, ModEnchantments.VIOLENT)) {
            if ((double)chance < 0.01) {
                monster.die(monster.damageSources().mobAttack(maidLiving));
            } else if ((double)chance < 0.11) {
                monster.addEffect(new MobEffectInstance(MobEffects.POISON, 100));
            } else if ((double)chance < 0.21) {
                int paralysicLevel = 1;
                monster.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, paralysicLevel * 20, 100, false, false));
                monster.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, paralysicLevel * 20, 100, false, false));
                monster.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, paralysicLevel * 20, 100, false, false));
            } else if ((double)chance < 0.41) {
                event.setNewDamage(event.getOriginalDamage() + 3.0f);
            } else if ((double)chance < 0.6) {
                monster.igniteForTicks(100);
            } else if ((double)chance < 0.7) {
                if (monster.getHealth() > 30.0f) {
                    event.setNewDamage(monster.getHealth() / 3.0f);
                } else {
                    event.setNewDamage(event.getOriginalDamage() + 5.0f);
                }
            } else if ((double)chance < 0.8) {
                monster.addEffect(new MobEffectInstance(ModEffects.DRUNK, 100));
            } else {
                monster.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 20, 50, false, false));
                monster.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 20, 50, false, false));
            }
        }
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingDamageEvent.Post event) {
        int paralysicLevel;
        int shareEnchantLevel;
        LivingEntity hurtEntity = event.getEntity();
        Entity attacker = event.getSource().getEntity();
        if (TameableUtils.hasEnchant(hurtEntity, ModEnchantments.CHAOS) && attacker instanceof LivingEntity) {
            ((LivingEntity)attacker).addEffect(new MobEffectInstance(ModEffects.DRUNK, 120, 1));
        }
        if ((shareEnchantLevel = TameableUtils.getEnchantLevel(hurtEntity, ModEnchantments.SHARE)) > 0 && attacker instanceof LivingEntity) {
            LivingEntity attackerLiving = (LivingEntity)attacker;
            Set<LivingEntity> monsterEntities = TameableUtils.getNearbyMobs(hurtEntity, 20.0).stream().filter(i -> i instanceof Enemy).collect(Collectors.toSet());
            if (monsterEntities.size() > 1) {
                float originalDamage = event.getOriginalDamage();
                monsterEntities.forEach(i -> i.hurt(event.getSource(), (float)((double)originalDamage * 0.3)));
            }
        }
        if ((paralysicLevel = TameableUtils.getEnchantLevel(hurtEntity, ModEnchantments.PARALYSIS)) > 0 && attacker instanceof LivingEntity) {
            LivingEntity attackerLiving = (LivingEntity)attacker;
            attackerLiving.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, paralysicLevel * 20, 100, false, false));
            attackerLiving.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, paralysicLevel * 20, 100, false, false));
            attackerLiving.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, paralysicLevel * 20, 100, false, false));
        }
        if (FriendlyFireCommon.preventAttack((Entity)event.getEntity(), event.getSource(), event.getNewDamage())) {
            event.getEntity().setLastHurtByMob(null);
            Entity entity = event.getSource().getEntity();
            if (entity instanceof LivingEntity) {
                LivingEntity trueSource = (LivingEntity)entity;
                trueSource.setLastHurtByMob(null);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorldEvent(EntityJoinLevelEvent event) {
        LivingEntity living;
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity && TameableUtils.couldBeTamed((Entity)(living = (LivingEntity)entity))) {
            PHWorldData data;
            if (TameableUtils.hasEnchant(living, ModEnchantments.HEALTH_BOOST)) {
                living.setHealth((float)Math.max((double)living.getHealth(), TameableUtils.getSafePetHealth(living)));
            }
            if (living.isAlive() && TameableUtils.isTamed((Entity)living) && (data = PHWorldData.get(living.level())) != null) {
                data.removeMatchingLanternRequests(living.getUUID());
            }
        }
    }

    @SubscribeEvent
    public static void onEntityLeaveWorld(EntityLeaveLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (!living.level().isClientSide && living.isAlive() && TameableUtils.isTamed((Entity)living) && TameableUtils.shouldUnloadToLantern(living)) {
                UUID ownerUUID = TameableUtils.getOwnerUUIDOf(event.getEntity());
                String saveName = event.getEntity().hasCustomName() ? event.getEntity().getCustomName().getString() : "";
                PHWorldData data = PHWorldData.get(living.level());
                if (data != null) {
                    LanternRequest request = new LanternRequest(living.getUUID(), BuiltInRegistries.ENTITY_TYPE.getKey((Object)event.getEntity().getType()).toString(), ownerUUID, living.blockPosition(), event.getEntity().level().dayTime(), saveName);
                    data.addLanternRequest(request);
                }
            }
            if (TameableUtils.couldBeTamed((Entity)living) && TameableUtils.hasEnchant(living, ModEnchantments.HEALTH_BOOST)) {
                TameableUtils.setSafePetHealth(living, living.getHealth());
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDie(LivingDeathEvent event) {
        if (TameableUtils.isTamed((Entity)event.getEntity())) {
            BlockPos bedPos = TameableUtils.getPetBedPos(event.getEntity());
            if (bedPos != null) {
                CompoundTag data = new CompoundTag();
                event.getEntity().addAdditionalSaveData(data);
                String saveName = event.getEntity().hasCustomName() ? event.getEntity().getCustomName().getString() : "";
                RespawnRequest request = new RespawnRequest(BuiltInRegistries.ENTITY_TYPE.getKey((Object)event.getEntity().getType()).toString(), TameableUtils.getPetBedDimension(event.getEntity()), data, bedPos, event.getEntity().level().dayTime(), saveName);
                PHWorldData worldData = PHWorldData.get(event.getEntity().level());
                if (worldData != null) {
                    worldData.addRespawnRequest(request);
                }
            }
            if (!(event.getEntity() instanceof TamableAnimal)) {
                Entity owner = TameableUtils.getOwnerOf((Entity)event.getEntity());
                if (!event.getEntity().level().isClientSide && event.getEntity().level().getGameRules().getBoolean(GameRules.RULE_SHOWDEATHMESSAGES) && owner instanceof ServerPlayer) {
                    owner.sendSystemMessage(event.getEntity().getCombatTracker().getDeathMessage());
                }
            }
        }
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Start event) {
        float dist = 30.0f;
        Vec3 center = event.getExplosion().center();
        Vec3 bottom = center.add((double)(-dist), (double)(-dist), (double)(-dist));
        Vec3 top = center.add((double)dist, (double)dist, (double)dist);
        Predicate<Entity> defusal = animal -> TameableUtils.isTamed(animal) && TameableUtils.hasEnchant((LivingEntity)animal, ModEnchantments.DEFUSAL);
        boolean flag = false;
        for (LivingEntity defuser : event.getLevel().getEntitiesOfClass(LivingEntity.class, new AABB(bottom, top), EntitySelector.NO_SPECTATORS.and(defusal))) {
            float level = 10 * TameableUtils.getEnchantLevel(defuser, ModEnchantments.DEFUSAL);
            if (!(defuser.distanceToSqr(center) <= (double)(level * level))) continue;
            flag = true;
            break;
        }
        if (flag) {
            event.setCanceled(true);
            float pitch = 1.5f + new Random().nextFloat();
            event.getLevel().playSound(null, center.x, center.y, center.z, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, pitch);
            Level level = event.getLevel();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                for (int i = 0; i < 5; ++i) {
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.CLOUD, center.x, center.y + 1.0, center.z, 5, 0.0, 0.0, 0.0, (double)0.2f);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        BlockEntity blockEntity;
        if (event.getState().getBlock() instanceof PetBedBlock && (blockEntity = event.getLevel().getBlockEntity(event.getPos())) instanceof PetBedBlockEntity) {
            PetBedBlockEntity petBedBlockEntity = (PetBedBlockEntity)blockEntity;
            petBedBlockEntity.removeAllRequestsFor(event.getPlayer());
            petBedBlockEntity.resetBedsForNearbyPets();
        }
    }

    @SubscribeEvent
    public static void onItemDespawnEvent(ItemExpireEvent event) {
        if (event.getEntity().getItem().getItem() == Items.APPLE && PetHomeConfig.rottenApple) {
            Random random = new Random();
            if (random.nextFloat() < 0.1f * (float)event.getEntity().getItem().getCount()) {
                event.getEntity().getItem().shrink(1);
                event.setExtraLife(10);
                ItemEntity rotten = new ItemEntity(event.getEntity().level(), event.getEntity().getX(), event.getEntity().getY(), event.getEntity().getZ(), new ItemStack((ItemLike)PHItemRegistry.ROTTEN_APPLE.get()));
                event.getEntity().level().addFreshEntity((Entity)rotten);
            }
        }
    }

    public static void mobTick(EntityTickEvent.Pre event, LivingEntity attacker) {
        List genericMobs = attacker.level().getEntitiesOfClass(Monster.class, LivingUtils.getBoundingBoxAroundEntity((Entity)attacker, 10.0));
        Random random = new Random();
        if (attacker.hasEffect(ModEffects.DRUNK) && attacker instanceof Monster) {
            double x = attacker.getX();
            double y = attacker.getY() + (double)attacker.getBbHeight() + 0.4;
            double z = attacker.getZ();
            if (attacker.level().getGameTime() % 10L == 0L) {
                ((ServerLevel)attacker.level()).sendParticles((ParticleOptions)((SimpleParticleType)PHParticleRegistry.QUESTION_MARK_PARTICLE_TYPE.get()), x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
            if (genericMobs == null) {
                return;
            }
            Monster Monster2 = (Monster)attacker;
            if (genericMobs.size() <= 0) {
                return;
            }
            Monster others = (Monster)genericMobs.get(random.nextInt(genericMobs.size()));
            if (genericMobs.size() > 2) {
                while (others == Monster2) {
                    others = (Monster)genericMobs.get(random.nextInt(genericMobs.size()));
                }
            }
            if (others == null) {
                Monster2.setTarget((LivingEntity)null);
            } else {
                LivingUtils.setAttackTarget(Monster2, others);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(EntityTickEvent.Pre event) {
        Entity entity = event.getEntity();
        if (entity instanceof Mob) {
            Entity blocking2;
            int shepherdLvl;
            int psychicWallLevel;
            Mob mob;
            Entity punching2;
            int oreLvl;
            Object punchProgress;
            Entity entity2;
            int shadowHandsLevel;
            Level targetX2;
            int insightLevel;
            int i;
            Player petOwner;
            Entity owner;
            int bars;
            Mob pet = (Mob)entity;
            ServerProxy.mobTick(event, (LivingEntity)pet);
            if (TameableUtils.hasEnchant((LivingEntity)pet, ModEnchantments.BLAZING_PROTECTION) && !event.getEntity().level().isClientSide && (bars = TameableUtils.getBlazingProtectionBars((LivingEntity)pet)) < 2 * TameableUtils.getEnchantLevel((LivingEntity)pet, ModEnchantments.BLAZING_PROTECTION)) {
                int cooldown = TameableUtils.getBlazingProtectionCooldown((LivingEntity)pet);
                if (cooldown > 0) {
                    --cooldown;
                } else {
                    TameableUtils.setBlazingProtectionBars((LivingEntity)pet, bars + 1);
                    cooldown = 200;
                }
                TameableUtils.setBlazingProtectionCooldown((LivingEntity)pet, cooldown);
            }
            if (TameableUtils.hasEnchant((LivingEntity)pet, ModEnchantments.NIGHT_VISION) && TameableUtils.isTamed((Entity)pet) && (owner = TameableUtils.getOwnerOf((Entity)pet)).distanceToSqr((Entity)pet) < 10.0 && owner instanceof Player && !(petOwner = (Player)owner).hasEffect(MobEffects.NIGHT_VISION) && pet.tickCount % 40 == 0) {
                petOwner.addEffect(new MobEffectInstance(MobEffects.NIGHT_VISION, 6000));
            }
            if (TameableUtils.hasEnchant((LivingEntity)pet, ModEnchantments.XP_Transfer)) {
                TameableUtils.xpTransfer((LivingEntity)pet);
            }
            if (TameableUtils.hasEnchant((LivingEntity)pet, ModEnchantments.VOID_CLOUD) && !pet.isInWaterOrBubble() && pet.fallDistance > 3.0f && !pet.onGround()) {
                double targetZ;
                Entity owner2 = TameableUtils.getOwnerOf((Entity)pet);
                boolean shouldMoveToOwnerXZ = owner2 != null && Math.abs(owner2.getY() - pet.getY()) < 1.0;
                double targetX2 = shouldMoveToOwnerXZ ? owner2.getX() : pet.getX();
                double targetY = Math.max((double)((float)pet.level().getMinBuildHeight() + 0.5f), owner2 == null ? 64.0 : (owner2.getY() < pet.getY() ? owner2.getY() + (double)0.6f : owner2.getY(1.0) + (double)pet.getBbHeight()));
                if (owner2 != null && owner2.getRootVehicle() == pet) {
                    targetY = Math.min((double)((float)pet.level().getMinBuildHeight() + 0.5f), pet.getY() - 0.5);
                }
                double d = targetZ = shouldMoveToOwnerXZ ? owner2.getZ() : pet.getZ();
                if (pet.verticalCollision) {
                    pet.setOnGround(true);
                    targetX2 += (double)((pet.getRandom().nextFloat() - 0.5f) * 4.0f);
                    targetZ += (double)((pet.getRandom().nextFloat() - 0.5f) * 4.0f);
                }
                Vec3 move = new Vec3(targetX2 - pet.getX(), targetY - pet.getY(), targetZ - pet.getZ());
                pet.setDeltaMovement(pet.getDeltaMovement().add(move.normalize().scale(0.15)).multiply(0.5, 0.5, 0.5));
                if (pet.level() instanceof ServerLevel) {
                    TameableUtils.setFallDistance((LivingEntity)pet, pet.fallDistance);
                    ((ServerLevel)pet.level()).sendParticles((ParticleOptions)ParticleTypes.REVERSE_PORTAL, pet.getRandomX(1.5), pet.getY() - (double)pet.getRandom().nextFloat(), pet.getRandomZ(1.5), 0, 0.0, (double)-0.2f, 0.0, 1.0);
                }
            }
            if (TameableUtils.hasEnchant((LivingEntity)pet, ModEnchantments.IMMUNITY_FRAME) && !event.getEntity().level().isClientSide && (i = TameableUtils.getImmuneTime((LivingEntity)pet)) > 0) {
                TameableUtils.setImmuneTime((LivingEntity)pet, i - 1);
            }
            if (pet.hasEffect(MobEffects.POISON) && TameableUtils.hasEnchant((LivingEntity)pet, ModEnchantments.POISON_RESISTANCE)) {
                pet.removeEffect(MobEffects.POISON);
            }
            if (TameableUtils.hasEnchant((LivingEntity)pet, ModEnchantments.BLIGHT_CURSE)) {
                TameableUtils.destroyRandomPlants((LivingEntity)pet);
            }
            if (TameableUtils.hasEnchant((LivingEntity)pet, ModEnchantments.REJUVENATION)) {
                TameableUtils.absorbExpOrbs((LivingEntity)pet);
            }
            if (TameableUtils.hasEnchant((LivingEntity)pet, ModEnchantments.INFAMY_CURSE)) {
                TameableUtils.aggroRandomMonsters((LivingEntity)pet);
            }
            if (TameableUtils.hasEnchant((LivingEntity)pet, ModEnchantments.AMPHIBIOUS)) {
                pet.setAirSupply(pet.getMaxAirSupply());
            }
            if (TameableUtils.hasEnchant((LivingEntity)pet, ModEnchantments.INTIMIDATION)) {
                TameableUtils.scareRandomMonsters((LivingEntity)pet, TameableUtils.getEnchantLevel((LivingEntity)pet, ModEnchantments.INTIMIDATION));
            }
            if ((insightLevel = TameableUtils.getEnchantLevel((LivingEntity)pet, ModEnchantments.INSIGHT)) > 0 && (targetX2 = entity.level()) instanceof ServerLevel) {
                boolean brightness;
                ServerLevel serverLevel = (ServerLevel)targetX2;
                boolean bl = brightness = serverLevel.getMaxLocalRawBrightness(pet.getOnPos().above()) < 9;
                if (brightness) {
                    TameableUtils.applyGlowingEffect((LivingEntity)pet, insightLevel);
                }
            }
            if (TameableUtils.hasEnchant((LivingEntity)pet, ModEnchantments.SonicBoom)) {
                Mob attacker = pet;
                LivingEntity beingAttacked = pet.getTarget();
                if (beingAttacked != null && (pet.closerThan((Entity)beingAttacked, 10.0, 20.0) || TameableUtils.getNearbyMobs((LivingEntity)pet, 10.0).size() > 3) && pet.tickCount % 200 == 0) {
                    System.out.println("\u51b2\u51fb\u6ce2!");
                    TameableUtils.performSonicBook((LivingEntity)attacker, beingAttacked, (ServerLevel)attacker.level());
                }
            }
            if ((shadowHandsLevel = TameableUtils.getEnchantLevel((LivingEntity)pet, ModEnchantments.SHADOW_HANDS)) > 0 && (entity2 = event.getEntity()) instanceof Mob) {
                Mob mob2 = (Mob)entity2;
                ClientGameEvents.updateVisualDataForMob(event.getEntity(), TameableUtils.getShadowPunchTimes((LivingEntity)mob2));
                if (!mob2.level().isClientSide) {
                    Entity targetEntity = TameableUtils.getPetAttackTarget((LivingEntity)mob2);
                    Entity punching2 = targetEntity instanceof Player || targetEntity instanceof TamableAnimal ? null : targetEntity;
                    punchProgress = TameableUtils.getShadowPunchTimes((LivingEntity)mob2);
                    if (punching2 != null && punching2.isAlive() && mob2.hasLineOfSight(punching2) && mob2.distanceTo(punching2) < 16.0f) {
                        int[] striking = TameableUtils.getShadowPunchStriking((LivingEntity)mob2);
                        if (punchProgress == null || ((Object)punchProgress).length < shadowHandsLevel) {
                            int[] clean = new int[shadowHandsLevel];
                            TameableUtils.setShadowPunchTimes((LivingEntity)mob2, clean);
                            TameableUtils.setShadowPunchStriking((LivingEntity)mob2, clean);
                        } else {
                            int cooldown = TameableUtils.getShadowPunchCooldown((LivingEntity)mob2);
                            if (cooldown <= 0) {
                                int start;
                                boolean flag = false;
                                for (int i2 = start = shadowHandsLevel == 1 ? 0 : mob2.getRandom().nextInt(shadowHandsLevel - 1); i2 < shadowHandsLevel; ++i2) {
                                    if (striking[i2] != 0) continue;
                                    striking[i2] = 1;
                                    flag = true;
                                    break;
                                }
                                if (flag) {
                                    TameableUtils.setShadowPunchCooldown((LivingEntity)mob2, 5);
                                }
                            } else {
                                TameableUtils.setShadowPunchCooldown((LivingEntity)mob2, cooldown - 1);
                            }
                            for (int i3 = 0; i3 < Math.min(shadowHandsLevel, Math.min(striking.length, ((Object)punchProgress).length)); ++i3) {
                                if (striking[i3] != 0) {
                                    if (punchProgress[i3] < 10) {
                                        punchProgress[i3] = punchProgress[i3] + true;
                                    } else {
                                        punching2.hurt(punching2.damageSources().mobAttack((LivingEntity)mob2), (float)Mth.clamp((int)shadowHandsLevel, (int)2, (int)4));
                                        striking[i3] = 0;
                                    }
                                }
                                if (striking[i3] != 0 || punchProgress[i3] <= 0) continue;
                                punchProgress[i3] = punchProgress[i3] - true;
                            }
                            TameableUtils.setShadowPunchStriking((LivingEntity)mob2, striking);
                            TameableUtils.setShadowPunchTimes((LivingEntity)mob2, (int[])punchProgress);
                        }
                    } else {
                        if (punching2 != null) {
                            boolean flag = true;
                            for (int i4 = 0; i4 < Math.min(shadowHandsLevel, ((Object)punchProgress).length); ++i4) {
                                if (punchProgress[i4] <= 0) continue;
                                punchProgress[i4] = punchProgress[i4] - true;
                                flag = false;
                            }
                            TameableUtils.setShadowPunchStriking((LivingEntity)mob2, new int[shadowHandsLevel]);
                            TameableUtils.setShadowPunchTimes((LivingEntity)mob2, (int[])punchProgress);
                            if (flag) {
                                TameableUtils.setPetAttackTarget((LivingEntity)mob2, -1);
                            }
                        }
                        LivingEntity punchingTarget = null;
                        if (mob2.getTarget() != null) {
                            punchingTarget = mob2.getTarget();
                        } else {
                            Entity i3 = TameableUtils.getOwnerOf((Entity)mob2);
                            if (i3 instanceof LivingEntity) {
                                LivingEntity owner3 = (LivingEntity)i3;
                                if (owner3.getLastHurtByMob() != null && owner3.getLastHurtByMob().isAlive() && !TameableUtils.hasSameOwnerAs((LivingEntity)mob2, (Entity)owner3.getLastHurtByMob())) {
                                    punchingTarget = owner3.getLastHurtByMob();
                                }
                                if (owner3.getLastHurtMob() != null && owner3.getLastHurtMob().isAlive() && !TameableUtils.hasSameOwnerAs((LivingEntity)mob2, (Entity)owner3.getLastHurtMob())) {
                                    punchingTarget = owner3.getLastHurtMob();
                                }
                            }
                        }
                        if (punchingTarget != null && punchingTarget.isAlive()) {
                            TameableUtils.setPetAttackTarget((LivingEntity)mob2, punchingTarget.getId());
                        }
                    }
                }
            }
            if ((oreLvl = TameableUtils.getEnchantLevel((LivingEntity)pet, ModEnchantments.ORE_SCENTING)) > 0 && !event.getEntity().level().isClientSide && event.getEntity().isAlive()) {
                int interval = 100 + Math.max(150, 550 - oreLvl * 100);
                TameableUtils.detectRandomOres((LivingEntity)pet, interval, 5 + oreLvl * 2, oreLvl * 50, oreLvl * 3);
            }
            if (TameableUtils.hasEnchant((LivingEntity)pet, ModEnchantments.LINKED_INVENTORY) && (punching2 = event.getEntity()) instanceof Mob && !(mob = (Mob)punching2).canPickUpLoot()) {
                mob.setCanPickUpLoot(true);
            }
            if (TameableUtils.hasEnchant((LivingEntity)pet, ModEnchantments.HEALING_AURA) && !pet.level().isClientSide) {
                int time = TameableUtils.getHealingAuraTime((LivingEntity)pet);
                if (time > 0) {
                    List<LivingEntity> hurtNearby = TameableUtils.getAuraHealables((LivingEntity)pet);
                    punchProgress = hurtNearby.iterator();
                    while (punchProgress.hasNext()) {
                        LivingEntity needsHealing = (LivingEntity)punchProgress.next();
                        if (needsHealing.hasEffect(MobEffects.REGENERATION)) continue;
                        needsHealing.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 100, TameableUtils.getEnchantLevel((LivingEntity)pet, ModEnchantments.HEALING_AURA) - 1));
                    }
                    if (--time == 0) {
                        time = -600 - pet.getRandom().nextInt(600);
                    }
                } else if (time < 0) {
                    ++time;
                } else if ((pet.tickCount + pet.getId()) % 200 == 0 || TameableUtils.getHealingAuraImpulse((LivingEntity)pet)) {
                    List<LivingEntity> hurtNearby = TameableUtils.getAuraHealables((LivingEntity)pet);
                    if (!hurtNearby.isEmpty()) {
                        time = 200;
                    }
                    TameableUtils.setHealingAuraImpulse((LivingEntity)pet, false);
                }
                TameableUtils.setHealingAuraTime((LivingEntity)pet, time);
            }
            if ((psychicWallLevel = TameableUtils.getEnchantLevel((LivingEntity)pet, ModEnchantments.PSYCHIC_WALL)) > 0 && (punchProgress = event.getEntity()) instanceof Mob) {
                Mob mob3 = (Mob)punchProgress;
                if (!event.getEntity().level().isClientSide) {
                    int cooldown = TameableUtils.getPsychicWallCooldown((LivingEntity)mob3);
                    if (cooldown > 0) {
                        TameableUtils.setPsychicWallCooldown((LivingEntity)mob3, cooldown - 1);
                    } else {
                        LivingEntity blocking2 = null;
                        Mob blockingFrom = null;
                        if (mob3.getTarget() != null) {
                            blocking2 = mob3.getTarget();
                            blockingFrom = mob3;
                        } else {
                            Entity start = TameableUtils.getOwnerOf((Entity)mob3);
                            if (start instanceof LivingEntity) {
                                LivingEntity owner4 = (LivingEntity)start;
                                if (owner4.getLastHurtByMob() != null && owner4.getLastHurtByMob().isAlive() && !TameableUtils.hasSameOwnerAs((LivingEntity)mob3, (Entity)owner4.getLastHurtByMob())) {
                                    blocking2 = owner4.getLastHurtByMob();
                                    blockingFrom = owner4;
                                }
                                if (owner4.getLastHurtMob() != null && owner4.getLastHurtMob().isAlive() && !TameableUtils.hasSameOwnerAs((LivingEntity)mob3, (Entity)owner4.getLastHurtMob())) {
                                    blocking2 = owner4.getLastHurtMob();
                                    blockingFrom = owner4;
                                }
                            }
                        }
                        if (blocking2 != null) {
                            int width = psychicWallLevel + 1;
                            float yAdditional = blocking2.getBbHeight() * 0.5f + (float)width * 0.5f;
                            Vec3 vec3 = blockingFrom.position().add(0.0, (double)yAdditional, 0.0);
                            Vec3 vec32 = blocking2.position().add(0.0, (double)yAdditional, 0.0);
                            Vec3 vec33 = vec3.add(vec32);
                            Vec3 avg = new Vec3(vec33.x / 2.0, Math.floor(vec33.y / 2.0), vec33.z / 2.0);
                            Vec3 rotationFrom = avg.subtract(vec3);
                            Direction dir = Direction.getNearest((double)rotationFrom.x, (double)rotationFrom.y, (double)rotationFrom.z);
                            PsychicWallEntity wall = (PsychicWallEntity)((EntityType)PHEntityRegistry.PSYCHIC_WALL.get()).create(mob3.level());
                            wall.setPos(avg.x, avg.y, avg.z);
                            wall.setBlockWidth(width);
                            wall.setCreatorId(mob3.getUUID());
                            wall.setLifespan(psychicWallLevel * 100);
                            wall.setWallDirection(dir);
                            mob3.level().addFreshEntity((Entity)wall);
                            TameableUtils.setPsychicWallCooldown((LivingEntity)mob3, psychicWallLevel * 200 + 40);
                        }
                    }
                }
            }
            if ((shepherdLvl = TameableUtils.getEnchantLevel((LivingEntity)pet, ModEnchantments.SHEPHERD)) > 0) {
                TameableUtils.attractAnimals((LivingEntity)pet, shepherdLvl * 3);
            }
            if (TameableUtils.hasEnchant((LivingEntity)pet, ModEnchantments.MAGNETIC) && (blocking2 = event.getEntity()) instanceof Mob) {
                Mob mob4 = (Mob)blocking2;
                Entity sucking = TameableUtils.getPetAttackTarget((LivingEntity)mob4);
                if (!mob4.level().isClientSide) {
                    if (mob4.getTarget() == null || !mob4.getTarget().isAlive() || mob4.distanceTo((Entity)mob4.getTarget()) < 0.5f + mob4.getBbWidth() || mob4.getRootVehicle() instanceof GiantBubbleEntity) {
                        if (TameableUtils.getPetAttackTargetID((LivingEntity)mob4) != -1) {
                            TameableUtils.setPetAttackTarget((LivingEntity)mob4, -1);
                        }
                    } else {
                        TameableUtils.setPetAttackTarget((LivingEntity)mob4, mob4.getTarget().getId());
                    }
                } else if (sucking != null) {
                    double dist = mob4.distanceTo(sucking);
                    Vec3 start = mob4.position().add(0.0, (double)(mob4.getBbHeight() * 0.5f), 0.0);
                    Vec3 end = sucking.position().add(0.0, (double)(sucking.getBbHeight() * 0.5f), 0.0).subtract(start);
                    for (float distStep = mob4.getBbWidth() + 0.8f; distStep < (float)((int)Math.ceil(dist)); distStep += 1.0f) {
                        Vec3 vec3 = start.add(end.scale((double)distStep / dist));
                        float f1 = 0.5f * (mob4.getRandom().nextFloat() - 0.5f);
                        float f2 = 0.5f * (mob4.getRandom().nextFloat() - 0.5f);
                        float f3 = 0.5f * (mob4.getRandom().nextFloat() - 0.5f);
                        mob4.level().addParticle((ParticleOptions)PHParticleRegistry.MAGNET.get(), vec3.x + (double)f1, vec3.y + (double)f2, vec3.z + (double)f3, 0.0, 0.0, 0.0);
                    }
                }
                if (sucking != null) {
                    if (mob4.tickCount % 15 == 0) {
                        mob4.playSound((SoundEvent)PHSoundRegistry.MAGNET_LOOP.get(), 1.0f, 1.0f);
                    }
                    mob4.setDeltaMovement(mob4.getDeltaMovement().multiply(0.88, 1.0, 0.88));
                    Vec3 move = new Vec3(mob4.getX() - sucking.getX(), mob4.getY() - (double)sucking.getEyeHeight() / 2.0 - sucking.getY(), mob4.getZ() - sucking.getZ());
                    sucking.setDeltaMovement(sucking.getDeltaMovement().add(move.normalize().scale(mob4.onGround() ? 0.15 : 0.05)));
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onInteractWithEntity(PlayerInteractEvent.EntityInteract event) {
        LivingEntity living;
        Entity entityID;
        Player player = event.getEntity();
        InteractionHand hand = event.getHand();
        Level level = event.getLevel();
        Entity pet = event.getTarget();
        ItemStack itemstack = event.getItemStack();
        if (!level.isClientSide() && itemstack.is(PHItemRegistry.NET_ITEM)) {
            if (!pet.isAlive() || NetItem.containsEntity(itemstack)) {
                return;
            }
            NetItem netItem = (NetItem)itemstack.getItem();
            if (netItem.getType() == Type.EMPTY) {
                entityID = pet.getType();
                if (!NetItem.canCatchMob(pet)) {
                    event.setCanceled(true);
                    return;
                }
                ItemStack newStack = new ItemStack((ItemLike)PHItemRegistry.NET_HAS_ITEM.get());
                CompoundTag nbt = NetItem.getNBTfromEntity(pet);
                ItemStack newerStack = newStack.split(1);
                newerStack.set(PHDataComponents.ENTITY_HOLDER, (Object)nbt);
                player.swing(hand);
                player.setItemInHand(hand, newStack);
                if (!player.addItem(newerStack)) {
                    ItemEntity itemEntity = new ItemEntity(player.level(), player.getX(), player.getY(), player.getZ(), newerStack);
                    player.level().addFreshEntity((Entity)itemEntity);
                }
                pet.discard();
                player.getCooldowns().addCooldown(itemstack.getItem(), 5);
            }
        }
        if ((entityID = event.getTarget()) instanceof LivingEntity) {
            living = (LivingEntity)entityID;
            if (TameableUtils.isPetOf(player, pet)) {
                FoodProperties foodProperty;
                if (TameableUtils.hasEnchant(living, ModEnchantments.GLUTTONOUS) && (foodProperty = itemstack.getItem().getFoodProperties(itemstack, living)) != null && living.getHealth() < living.getMaxHealth()) {
                    living.heal((float)Math.floor((float)foodProperty.nutrition() * 1.5f));
                    if (!event.getEntity().isCreative()) {
                        itemstack.shrink(1);
                    }
                    living.playSound(living.getRandom().nextBoolean() ? SoundEvents.PLAYER_BURP : SoundEvents.GENERIC_EAT, 1.0f, living.getVoicePitch());
                    event.setCanceled(true);
                    event.setCancellationResult(InteractionResult.SUCCESS);
                }
                if (itemstack.is((Item)PHItemRegistry.COLLAR_TAG.get())) {
                    if (!event.getEntity().level().isClientSide && living.isAlive()) {
                        ItemEnchantments itemEnchantments = itemstack.getTagEnchantments();
                        Map<ResourceLocation, Integer> entityEnchantments = TameableUtils.getEnchants(living);
                        if (itemstack.has(DataComponents.CUSTOM_NAME)) {
                            living.setCustomName(itemstack.getHoverName());
                        }
                        if (!event.getEntity().isCreative()) {
                            itemstack.shrink(1);
                        }
                        if (TameableUtils.hasCollar(living)) {
                            Optional reg;
                            ItemStack collarFrom = new ItemStack((ItemLike)PHItemRegistry.COLLAR_TAG.get());
                            if (entityEnchantments != null && (reg = living.level().registryAccess().registry(Registries.ENCHANTMENT)).isPresent()) {
                                for (Map.Entry<ResourceLocation, Integer> entry : entityEnchantments.entrySet()) {
                                    Enchantment oneEnchant = (Enchantment)((Registry)reg.get()).get(entry.getKey());
                                    if (oneEnchant == null) continue;
                                    collarFrom.enchant(((Registry)reg.get()).wrapAsHolder((Object)oneEnchant), entry.getValue().intValue());
                                }
                            }
                            living.spawnAtLocation(collarFrom);
                        }
                        living.playSound((SoundEvent)PHSoundRegistry.COLLAR_TAG.get(), 1.0f, 1.0f);
                        if (!itemEnchantments.isEmpty()) {
                            TameableUtils.clearEnchants(living);
                            TameableUtils.addEnchant(living, itemEnchantments);
                        } else {
                            TameableUtils.clearEnchants(living);
                        }
                    }
                    event.setCanceled(true);
                    event.setCancellationResult(InteractionResult.SUCCESS);
                }
                if (TameableUtils.isTamed(event.getTarget()) && player.getItemInHand(hand).is((Item)PHItemRegistry.DEED_OF_OWNERSHIP.get())) {
                    TamableAnimal tamableAnimal = (TamableAnimal)pet;
                    tamableAnimal.setTame(false, false);
                    tamableAnimal.setOwnerUUID(null);
                    tamableAnimal.setOrderedToSit(false);
                    tamableAnimal.setInSittingPose(false);
                    player.swing(hand);
                    event.setCanceled(true);
                }
            }
        }
        if (pet instanceof LivingEntity) {
            Rabbit rabbit;
            CompoundTag horseExtras;
            Horse horse;
            living = (LivingEntity)pet;
            if (pet.getType() == EntityType.HORSE && itemstack.is(PHItemRegistry.ROTTEN_APPLE) && EventHooks.canLivingConvert((LivingEntity)living, (EntityType)EntityType.ZOMBIE_HORSE, timer -> {})) {
                player.swing(hand);
                horse = (Horse)pet;
                horse.playSound(SoundEvents.HORSE_DEATH, 0.8f, horse.getVoicePitch());
                horse.playSound(SoundEvents.ZOMBIE_INFECT, 0.8f, horse.getVoicePitch());
                horseExtras = new CompoundTag();
                if (!horse.getBodyArmorItem().isEmpty()) {
                    horse.spawnAtLocation(horse.getBodyArmorItem().copy());
                    horse.setItemSlot(EquipmentSlot.CHEST, ItemStack.EMPTY);
                }
                horse.addAdditionalSaveData(horseExtras);
                for (int i = 0; i < 6 + horse.getRandom().nextInt(5); ++i) {
                    horse.level().addParticle((ParticleOptions)ParticleTypes.SNEEZE, horse.getRandomX(1.0), horse.getRandomY(), horse.getRandomZ(1.0), 0.0, 0.0, 0.0);
                }
                ZombieHorse zombie = (ZombieHorse)EntityType.ZOMBIE_HORSE.create(horse.level());
                if (horse.isLeashed()) {
                    zombie.setLeashedTo(horse.getLeashHolder(), true);
                }
                zombie.moveTo(horse.getX(), horse.getY(), horse.getZ(), horse.getYRot(), horse.getXRot());
                zombie.setNoAi(horse.isNoAi());
                zombie.setBaby(horse.isBaby());
                if (horse.hasCustomName()) {
                    zombie.setCustomName(horse.getCustomName());
                    zombie.setCustomNameVisible(horse.isCustomNameVisible());
                }
                zombie.readAdditionalSaveData(horseExtras);
                zombie.setPersistenceRequired();
                EventHooks.onLivingConvert((LivingEntity)horse, (LivingEntity)zombie);
                player.level().addFreshEntity((Entity)zombie);
                horse.discard();
                if (!player.isCreative()) {
                    itemstack.shrink(1);
                }
            }
            if (pet.getType() == EntityType.RABBIT && itemstack.is(PHItemRegistry.SINISTER_CARROT) && TameableUtils.isTamed(pet) && TameableUtils.isPetOf(player, pet) && EventHooks.canLivingConvert((LivingEntity)living, (EntityType)EntityType.RABBIT, timer -> {}) && pet instanceof Rabbit && (rabbit = (Rabbit)pet).getVariant() != Rabbit.Variant.EVIL) {
                player.swing(hand);
                rabbit.playSound(SoundEvents.RABBIT_ATTACK, 0.8f, rabbit.getVoicePitch());
                rabbit.playSound(SoundEvents.ZOMBIE_INFECT, 0.8f, rabbit.getVoicePitch());
                rabbit.setVariant(Rabbit.Variant.EVIL);
                if (!player.isCreative()) {
                    itemstack.shrink(1);
                }
            }
            if (pet.getType() == EntityType.ZOMBIE_HORSE && itemstack.is(PHItemRegistry.SINISTER_CARROT) && EventHooks.canLivingConvert((LivingEntity)living, (EntityType)EntityType.SKELETON_HORSE, timer -> {})) {
                player.swing(hand);
                horse = (ZombieHorse)pet;
                horse.playSound(SoundEvents.HORSE_DEATH, 0.8f, horse.getVoicePitch());
                horse.playSound(SoundEvents.ZOMBIE_INFECT, 0.8f, horse.getVoicePitch());
                horseExtras = new CompoundTag();
                horse.addAdditionalSaveData(horseExtras);
                for (int i = 0; i < 6 + horse.getRandom().nextInt(5); ++i) {
                    horse.level().addParticle((ParticleOptions)ParticleTypes.SNEEZE, horse.getRandomX(1.0), horse.getRandomY(), horse.getRandomZ(1.0), 0.0, 0.0, 0.0);
                }
                SkeletonHorse skeleton = (SkeletonHorse)EntityType.SKELETON_HORSE.create(horse.level());
                if (horse.isLeashed()) {
                    skeleton.setLeashedTo(horse.getLeashHolder(), true);
                }
                skeleton.moveTo(horse.getX(), horse.getY(), horse.getZ(), horse.getYRot(), horse.getXRot());
                skeleton.setNoAi(horse.isNoAi());
                skeleton.setBaby(horse.isBaby());
                if (horse.hasCustomName()) {
                    skeleton.setCustomName(horse.getCustomName());
                    skeleton.setCustomNameVisible(horse.isCustomNameVisible());
                }
                skeleton.readAdditionalSaveData(horseExtras);
                skeleton.setPersistenceRequired();
                EventHooks.onLivingConvert((LivingEntity)horse, (LivingEntity)skeleton);
                player.level().addFreshEntity((Entity)skeleton);
                horse.discard();
                if (!player.isCreative()) {
                    itemstack.shrink(1);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onVillagerTrades(VillagerTradesEvent event) {
        if (event.getType() == PHVillagerRegistry.ANIMAL_TAMER.get()) {
            ArrayList<Object> level1 = new ArrayList<Object>();
            ArrayList<Object> level2 = new ArrayList<Object>();
            ArrayList<Object> level3 = new ArrayList<Object>();
            ArrayList<Object> level4 = new ArrayList<Object>();
            ArrayList<Object> level5 = new ArrayList<Object>();
            level1.add(new SellingItemTrade(Items.BONE, 3, 6, 6, 1));
            level1.add(new SellingItemTrade(Items.EGG, 3, 6, 6, 1));
            level1.add(new SellingItemTrade(Items.COD, 2, 6, 1));
            level1.add(new SellingRandomEnchantedBook(1));
            level2.add(new SellingItemTrade(Items.TROPICAL_FISH_BUCKET, 2, 1, 6, 7));
            level2.add(new BuyingItemTrade((ItemLike)Items.CARROT, 5, 1, 12, 7));
            level2.add(new BuyingItemTrade((ItemLike)Items.STICK, 20, 1, 12, 6));
            level2.add(new SellingItemTrade(Items.APPLE, 4, 12, 3, 7));
            level2.add(new SellingRandomEnchantedBook(5));
            level3.add(new SellingItemTrade((Item)PHItemRegistry.ROTTEN_APPLE.get(), 4, 1, 1, 10));
            level3.add(new SellingRandomEnchantedBook(10));
            level3.add(new SellingItemTrade(Items.TADPOLE_BUCKET, 6, 1, 4, 13));
            level3.add(new SellingItemTrade((Item)PHItemRegistry.COLLAR_TAG.get(), 4, 1, 6, 6));
            level3.add(new EnchantItemTrade((Item)PHItemRegistry.COLLAR_TAG.get(), 20, 2, 8, 3, 10));
            level4.add(new SellingItemTrade(Items.AXOLOTL_BUCKET, 11, 1, 2, 15));
            level4.add(new SellingItemTrade(Items.TURTLE_EGG, 26, 1, 2, 15));
            level4.add(new SellingRandomEnchantedBook(15));
            level4.add(new EnchantItemTrade((Item)PHItemRegistry.COLLAR_TAG.get(), 40, 3, 18, 3, 15));
            level5.add(new SellingItemTrade(Items.GOLDEN_CARROT, 6, 1, 6, 10));
            level5.add(new SellingItemTrade(Items.GOLDEN_APPLE, 10, 1, 6, 10));
            level5.add(new SellingItemTrade((Item)PHItemRegistry.COLLAR_TAG.get(), 6, 1, 6, 10));
            level5.add(new EnchantItemTrade((Item)PHItemRegistry.COLLAR_TAG.get(), 50, 4, 38, 3, 20));
            level5.add(new SellingRandomEnchantedBook(15));
            event.getTrades().put(1, level1);
            event.getTrades().put(2, level2);
            event.getTrades().put(3, level3);
            event.getTrades().put(4, level4);
            event.getTrades().put(5, level5);
        }
    }

    private static MutableComponent getDescription(String baseKey, int level) {
        for (String keyType : KEY_TYPES) {
            String key = baseKey + keyType;
            if (I18n.exists((String)key)) {
                return Component.translatable((String)key).withStyle(ChatFormatting.DARK_GRAY);
            }
            if (!I18n.exists((String)(key = key + "." + level))) continue;
            return Component.translatable((String)key).withStyle(ChatFormatting.DARK_GRAY);
        }
        return null;
    }

    private static MutableComponent getDescription(Holder<Enchantment> enchantment, ResourceLocation id, int level) {
        ComponentContents componentContents;
        MutableComponent description = ServerProxy.getDescription("enchantment." + id.getNamespace() + "." + id.getPath() + ".", level);
        if (description == null && (componentContents = ((Enchantment)enchantment.value()).description().getContents()) instanceof TranslatableContents) {
            TranslatableContents translatable = (TranslatableContents)componentContents;
            description = ServerProxy.getDescription(translatable.getKey() + ".", level);
        }
        return description;
    }

    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        ItemEnchantments enchantments;
        List tooltip = event.getToolTip();
        ItemStack stack = event.getItemStack();
        if (!ModList.get().isLoaded("enchdesc") && !stack.isEmpty() && stack.getItem() instanceof EnchantedBookItem && (enchantments = (ItemEnchantments)stack.get(DataComponents.STORED_ENCHANTMENTS)) != null && !enchantments.isEmpty()) {
            for (Holder enchantmentHolder : enchantments.keySet()) {
                MutableComponent description;
                Enchantment e = (Enchantment)enchantmentHolder.value();
                if (!enchantmentHolder.getKey().location().getNamespace().contains("pet_home") || (description = ServerProxy.getDescription((Holder<Enchantment>)enchantmentHolder, ((ResourceKey)enchantmentHolder.unwrapKey().orElseThrow()).location(), e.getMaxLevel())) == null) continue;
                tooltip.add(description);
            }
        }
    }
}

