/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pet_home.server.block;

import com.github.yzqdev.pet_home.server.block.PHTileEntityRegistry;
import com.github.yzqdev.pet_home.server.block.PetBedBlockEntity;
import com.github.yzqdev.pet_home.server.misc.PHParticleRegistry;
import com.github.yzqdev.pet_home.server.misc.PHTagRegistry;
import com.github.yzqdev.pet_home.util.TameableUtils;
import com.mojang.serialization.MapCodec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PetBedBlock
extends BaseEntityBlock {
    private static final VoxelShape COLLIDE_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0);
    private static final VoxelShape SELECT_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private static Random random = new Random();

    public PetBedBlock(String variantName, DyeColor color) {
        super(BlockBehaviour.Properties.of().mapColor(color).pushReaction(PushReaction.BLOCK).sound(SoundType.WOOD).strength(0.8f).noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (TameableUtils.isTamed(entity) && !entity.getType().is(PHTagRegistry.REFUSES_PET_BEDS) && !level.isClientSide && (entity.tickCount + entity.getId()) % 10 == 0 && random.nextInt(6) == 0) {
            TameableUtils.setPetBedPos((LivingEntity)entity, pos);
            TameableUtils.setPetBedDimension((LivingEntity)entity, level.dimension().toString());
            Vec3 look = new Vec3(0.0, 0.0, (double)(-entity.getBbWidth())).yRot((float)Math.toRadians(180.0f - entity.getYHeadRot()));
            Vec3 vec3 = entity.getEyePosition().add(look);
            Vec3 vec32 = look.scale(0.5);
            for (int i = 0; i < 2 + random.nextInt(2); ++i) {
                vec3 = vec3.subtract(vec32);
                double d1 = (1.0f - random.nextFloat()) * 0.6f;
                double d2 = (1.0f - random.nextFloat()) * 0.6f;
                double d3 = (1.0f - random.nextFloat()) * 0.6f;
                ((ServerLevel)level).sendParticles((ParticleOptions)((SimpleParticleType)PHParticleRegistry.ZZZ.get()), vec3.x + d1, vec3.y + d2, vec3.z + d3, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        super.entityInside(state, level, pos, entity);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        boolean flag = fluidstate.getType() == Fluids.WATER;
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> context) {
        context.add(new Property[]{FACING, WATERLOGGED});
    }

    public BlockState rotate(BlockState state, Rotation mirror) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)mirror.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public VoxelShape getShape(BlockState p_49038_, BlockGetter p_49039_, BlockPos p_49040_, CollisionContext p_49041_) {
        return SELECT_SHAPE;
    }

    public VoxelShape getCollisionShape(BlockState p_52357_, BlockGetter p_52358_, BlockPos p_52359_, CollisionContext p_52360_) {
        return COLLIDE_SHAPE;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState state2, LevelAccessor accessor, BlockPos pos, BlockPos pos2) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            accessor.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)accessor));
        }
        return super.updateShape(state, direction, state2, accessor, pos, pos2);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return null;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PetBedBlockEntity(pos, state);
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level p_152180_, BlockState p_152181_, BlockEntityType<T> p_152182_) {
        return p_152180_.isClientSide ? null : PetBedBlock.createTickerHelper(p_152182_, (BlockEntityType)((BlockEntityType)PHTileEntityRegistry.PET_BED.get()), PetBedBlockEntity::tick);
    }
}

