/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pet_home.server.block;

import com.github.yzqdev.pet_home.server.block.PHTileEntityRegistry;
import com.github.yzqdev.pet_home.server.block.PetBedBlock;
import com.github.yzqdev.pet_home.server.misc.PHWorldData;
import com.github.yzqdev.pet_home.server.misc.RespawnRequest;
import com.github.yzqdev.pet_home.util.IComandableMob;
import com.github.yzqdev.pet_home.util.TameableUtils;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class PetBedBlockEntity
extends BlockEntity {
    public PetBedBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)PHTileEntityRegistry.PET_BED.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, PetBedBlockEntity blockEntity) {
        PHWorldData data;
        long time = level.dayTime() % 24000L;
        if (time == 1L && (data = PHWorldData.get(level)) != null) {
            List<RespawnRequest> requestList = data.getRespawnRequestsFor(level, pos);
            for (RespawnRequest request : requestList) {
                if (!PetBedBlockEntity.addAndRemoveEntity(level, pos, (Direction)state.getValue((Property)PetBedBlock.FACING), request)) continue;
                data.removeRespawnRequest(request);
            }
        }
    }

    public void removeAllRequestsFor(@Nullable Player message) {
        PHWorldData data = PHWorldData.get(this.level);
        if (data != null) {
            List<RespawnRequest> requestList = data.getRespawnRequestsFor(this.level, this.getBlockPos());
            for (RespawnRequest request : requestList) {
                data.removeRespawnRequest(request);
                if (message == null) continue;
                message.displayClientMessage((Component)Component.translatable((String)"message.pet_home.goodbye", (Object[])new Object[]{request.getNametag()}), false);
            }
        }
    }

    private static boolean addAndRemoveEntity(Level level, BlockPos pos, Direction dir, RespawnRequest request) {
        Entity entity;
        EntityType type = request.getEntityType();
        if (type != null && (entity = type.create(level)) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.readAdditionalSaveData(request.getEntityData());
            living.setPos(Vec3.upFromBottomCenterOf((Vec3i)pos, (double)0.8f));
            living.setHealth(living.getMaxHealth());
            if (!request.getNametag().isEmpty()) {
                living.setCustomName((Component)Component.translatable((String)request.getNametag()));
            }
            switch (dir) {
                case NORTH: {
                    living.setYRot(180.0f);
                    break;
                }
                case EAST: {
                    living.setYRot(-90.0f);
                    break;
                }
                case SOUTH: {
                    living.setYRot(0.0f);
                    break;
                }
                case WEST: {
                    living.setYRot(90.0f);
                }
            }
            if (living instanceof IComandableMob) {
                ((IComandableMob)living).setCommand(1);
            }
            if (living instanceof TamableAnimal) {
                ((TamableAnimal)living).setOrderedToSit(true);
            }
            level.addFreshEntity((Entity)living);
            Entity owner = TameableUtils.getOwnerOf(entity);
            if (owner instanceof Player) {
                ((Player)owner).displayClientMessage((Component)Component.translatable((String)"message.pet_home.respawn", (Object[])new Object[]{entity.getName()}), false);
            }
            return true;
        }
        return false;
    }

    public void resetBedsForNearbyPets() {
        Predicate<Entity> pet = animal -> TameableUtils.isTamed(animal) && TameableUtils.getPetBedPos((LivingEntity)animal) != null && TameableUtils.getPetBedPos((LivingEntity)animal).equals((Object)this.getBlockPos());
        List list = this.level.getEntitiesOfClass(LivingEntity.class, new AABB(this.getBlockPos().offset(-10, -5, -10).getCenter(), this.getBlockPos().offset(10, 5, 10).getCenter()), EntitySelector.NO_SPECTATORS.and(pet));
        for (LivingEntity entity : list) {
            Entity owner = TameableUtils.getOwnerOf((Entity)entity);
            if (!(owner instanceof Player)) continue;
            ((Player)owner).displayClientMessage((Component)Component.translatable((String)"message.pet_home.remove_respawn", (Object[])new Object[]{entity.getName()}), false);
            TameableUtils.removePetBedPos(entity);
        }
    }
}

