/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pet_home.server.block;

import com.github.yzqdev.pet_home.server.block.PHTileEntityRegistry;
import com.github.yzqdev.pet_home.server.misc.LanternRequest;
import com.github.yzqdev.pet_home.server.misc.PHWorldData;
import com.github.yzqdev.pet_home.util.ChunkLoader;
import com.github.yzqdev.pet_home.util.TameableUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class WaywardLanternBlockEntity
extends BlockEntity {
    private int checkAgainIn = 100;
    private int entityLoadTimeout = 0;
    private List<LanternRequest> workingRequests = new ArrayList<LanternRequest>();
    private List<UUID> finishedRequests = new ArrayList<UUID>();

    public WaywardLanternBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)PHTileEntityRegistry.WAYWARD_LANTERN.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, WaywardLanternBlockEntity te) {
        block9: {
            block8: {
                PHWorldData data;
                if (!te.finishedRequests.isEmpty()) {
                    data = PHWorldData.get(level);
                    te.workingRequests.removeIf(lanternRequest -> te.finishedRequests.contains(lanternRequest.getPetUUID()));
                    for (UUID uuid : te.finishedRequests) {
                        data.removeMatchingLanternRequests(uuid);
                    }
                    te.finishedRequests.clear();
                }
                if (!te.workingRequests.isEmpty()) break block8;
                if (te.checkAgainIn > 0) {
                    --te.checkAgainIn;
                } else {
                    te.checkAgainIn = 200 + level.random.nextInt(400);
                    data = PHWorldData.get(level);
                    for (Player player : WaywardLanternBlockEntity.getPlayers(level, pos)) {
                        te.workingRequests.addAll(data.getLanternRequestsFor(player.getUUID()));
                    }
                }
                break block9;
            }
            if (!(level instanceof ServerLevel)) break block9;
            ServerLevel serverLevel = (ServerLevel)level;
            for (LanternRequest request : te.workingRequests) {
                WaywardLanternBlockEntity.loadChunksAround(serverLevel, request.getPetUUID(), request.getChunkPosition(), true);
                Entity entityFromChunk = serverLevel.getEntity(request.getPetUUID());
                ++te.entityLoadTimeout;
                if (entityFromChunk == null && te.entityLoadTimeout <= 200) continue;
                te.entityLoadTimeout = 0;
                if (entityFromChunk != null) {
                    BlockPos putAt = WaywardLanternBlockEntity.getPlaceFor(entityFromChunk, pos, level.random);
                    entityFromChunk.teleportTo((double)((float)putAt.getX() + 0.5f), (double)putAt.getY(), (double)((float)putAt.getZ() + 0.5f));
                    Entity owner = TameableUtils.getOwnerOf(entityFromChunk);
                    if (owner instanceof Player) {
                        ((Player)owner).displayClientMessage((Component)Component.translatable((String)"message.domesticationinnovation.wayward_lantern_return", (Object[])new Object[]{entityFromChunk.getName()}), false);
                    }
                    te.finishedRequests.add(request.getPetUUID());
                }
                WaywardLanternBlockEntity.loadChunksAround(serverLevel, request.getPetUUID(), request.getChunkPosition(), false);
            }
        }
    }

    private static void loadChunksAround(ServerLevel serverLevel, UUID ticket, BlockPos center, boolean load) {
        ChunkPos chunkPos = new ChunkPos(center);
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                if (load) {
                    ChunkLoader.forceLoadChunk((Level)serverLevel, chunkPos);
                    continue;
                }
                ChunkLoader.unloadChunk((Level)serverLevel, chunkPos);
            }
        }
    }

    private static List<Player> getPlayers(Level level, BlockPos pos) {
        double dist = 4096.0;
        ArrayList<Player> withinDist = new ArrayList<Player>();
        for (Player player : level.players()) {
            if (!(player.distanceToSqr(Vec3.atCenterOf((Vec3i)pos)) < dist)) continue;
            withinDist.add(player);
        }
        return withinDist;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("CheckAgainIn")) {
            this.checkAgainIn = tag.getInt("CheckAgainIn");
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("CheckAgainIn", this.checkAgainIn);
    }

    private static BlockPos getPlaceFor(Entity entity, BlockPos lanternPos, RandomSource random) {
        int maxDist = (int)Math.max(entity.getBbWidth() + 1.0f, 10.0f);
        for (int i = 0; i < 10; ++i) {
            BlockPos at = lanternPos.offset(random.nextInt(maxDist) - maxDist / 2, 1, random.nextInt(maxDist) - maxDist / 2);
            while (entity.level().getBlockState(at).isAir() && at.getY() > entity.level().getMinBuildHeight() && entity.level().noCollision(entity.getType().getSpawnAABB((double)((float)at.getX() + 0.5f), (double)(at.getY() - 1), (double)((float)at.getZ() + 0.5f)))) {
                at = at.below();
            }
            if (entity.level().noCollision(entity.getType().getSpawnAABB((double)((float)at.getX() + 0.5f), (double)at.getY(), (double)((float)at.getZ() + 0.5f)))) {
                return at;
            }
            if (!entity.isInWall()) continue;
            return lanternPos.above();
        }
        return lanternPos.above();
    }
}

