/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pet_home.server.entity;

import com.github.yzqdev.pet_home.server.entity.PHEntityRegistry;
import com.github.yzqdev.pet_home.util.TameableUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ChainLightningEntity
extends Entity {
    private static final EntityDataAccessor<Integer> CREATOR_ID = SynchedEntityData.defineId(ChainLightningEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> FROM_ID = SynchedEntityData.defineId(ChainLightningEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> TARGET_COUNT = SynchedEntityData.defineId(ChainLightningEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> CURRENT_TARGET_ID = SynchedEntityData.defineId(ChainLightningEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DIES_IN = SynchedEntityData.defineId(ChainLightningEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private List<Entity> previouslyShocked = new ArrayList<Entity>();
    private boolean hasShocked = false;
    private boolean hasChained = false;

    public ChainLightningEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(CREATOR_ID, (Object)-1);
        builder.define(FROM_ID, (Object)-1);
        builder.define(TARGET_COUNT, (Object)1);
        builder.define(CURRENT_TARGET_ID, (Object)-1);
        builder.define(DIES_IN, (Object)5);
    }

    public void tick() {
        super.tick();
        Entity creator = this.getCreatorEntity();
        Entity current = this.getToEntity();
        if (creator instanceof LivingEntity && current != null) {
            this.setPos(new Vec3(current.getX(), current.getY() + (double)(current.getBbHeight() * 0.5f), current.getZ()));
            if (!this.level().isClientSide && !this.hasShocked) {
                this.hasShocked = true;
                current.hurt(current.damageSources().lightningBolt(), 3.0f);
            }
        }
        if (!this.level().isClientSide) {
            if (!this.hasChained && this.getChainsLeft() > 0 && creator instanceof LivingEntity) {
                Entity closestValid = null;
                for (Entity entity : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(8.0))) {
                    if (entity.equals((Object)creator) || TameableUtils.hasSameOwnerAs((LivingEntity)creator, entity) || this.previouslyShocked.contains(entity) || creator.isAlliedTo(entity) || !(entity instanceof Mob) || !this.hasLineOfSight(entity) || closestValid != null && !(this.distanceTo(entity) < this.distanceTo(closestValid))) continue;
                    closestValid = entity;
                }
                if (closestValid != null) {
                    this.createLightningAt(closestValid);
                    this.hasChained = true;
                }
            }
            if (this.getDiesInTicks() > 0) {
                this.setDiesInTicks(this.getDiesInTicks() - 1);
            } else {
                this.remove(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    private boolean hasLineOfSight(Entity entity) {
        if (entity.level() != this.level()) {
            return false;
        }
        Vec3 vec3 = new Vec3(this.getX(), this.getEyeY(), this.getZ());
        Vec3 vec31 = new Vec3(entity.getX(), entity.getEyeY(), entity.getZ());
        if (vec31.distanceTo(vec3) > 128.0) {
            return false;
        }
        return this.level().clip(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).getType() == HitResult.Type.MISS;
    }

    private void createLightningAt(Entity closestValid) {
        ChainLightningEntity child = (ChainLightningEntity)((EntityType)PHEntityRegistry.CHAIN_LIGHTNING.get()).create(this.level());
        child.previouslyShocked = new ArrayList<Entity>(this.previouslyShocked);
        child.previouslyShocked.add(closestValid);
        child.setCreatorEntityID(this.getCreatorEntityID());
        child.setFromEntityID(this.getId());
        child.setToEntityID(closestValid.getId());
        child.copyPosition(closestValid);
        child.setChainsLeft(this.getChainsLeft() - 1);
        this.level().addFreshEntity((Entity)child);
    }

    public int getCreatorEntityID() {
        return (Integer)this.entityData.get(CREATOR_ID);
    }

    public void setCreatorEntityID(int id) {
        this.entityData.set(CREATOR_ID, (Object)id);
    }

    public Entity getCreatorEntity() {
        return this.getCreatorEntityID() == -1 ? null : this.level().getEntity(this.getCreatorEntityID());
    }

    public int getFromEntityID() {
        return (Integer)this.entityData.get(FROM_ID);
    }

    public void setFromEntityID(int id) {
        this.entityData.set(FROM_ID, (Object)id);
    }

    public Entity getFromEntity() {
        return this.getFromEntityID() == -1 ? null : this.level().getEntity(this.getFromEntityID());
    }

    public int getToEntityID() {
        return (Integer)this.entityData.get(CURRENT_TARGET_ID);
    }

    public void setToEntityID(int id) {
        this.entityData.set(CURRENT_TARGET_ID, (Object)id);
    }

    public Entity getToEntity() {
        return this.getToEntityID() == -1 ? null : this.level().getEntity(this.getToEntityID());
    }

    public int getChainsLeft() {
        return (Integer)this.entityData.get(TARGET_COUNT);
    }

    public void setChainsLeft(int i) {
        this.entityData.set(TARGET_COUNT, (Object)i);
    }

    public int getDiesInTicks() {
        return (Integer)this.entityData.get(DIES_IN);
    }

    public void setDiesInTicks(int i) {
        this.entityData.set(DIES_IN, (Object)i);
    }

    protected void readAdditionalSaveData(CompoundTag p_20052_) {
    }

    protected void addAdditionalSaveData(CompoundTag p_20139_) {
    }
}

