/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pet_home.server.entity;

import com.github.yzqdev.pet_home.server.entity.PHEntityRegistry;
import com.github.yzqdev.pet_home.util.IComandableMob;
import com.github.yzqdev.pet_home.util.TameableUtils;
import javax.annotation.Nullable;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class FeatherEntity
extends FishingHook {
    private static final EntityDataAccessor<Integer> OWNER_ID = SynchedEntityData.defineId(FeatherEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private boolean prevOnGround = false;
    public LivingEntity closestPet = null;

    public FeatherEntity(EntityType featherType, Level level) {
        super(featherType, level);
    }

    public FeatherEntity(Player player, Level level) {
        this((EntityType)PHEntityRegistry.FEATHER.get(), level);
        this.setOwner((Entity)player);
        float f = player.getXRot();
        float f1 = player.getYRot();
        float f2 = Mth.cos((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.sin((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.cos((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.sin((float)(-f * ((float)Math.PI / 180)));
        double d0 = player.getX() - (double)f3 * 0.3;
        double d1 = player.getEyeY();
        double d2 = player.getZ() - (double)f2 * 0.3;
        this.moveTo(d0, d1, d2, f1, f);
        Vec3 vec3 = new Vec3((double)(-f3), (double)Mth.clamp((float)(-(f5 / f4)), (float)-5.0f, (float)5.0f), (double)(-f2));
        double d3 = vec3.length();
        vec3 = vec3.multiply(0.6 / d3 + 0.5 + this.random.nextGaussian() * 0.0045, 0.6 / d3 + 0.5 + this.random.nextGaussian() * 0.0045, 0.6 / d3 + 0.5 + this.random.nextGaussian() * 0.0045);
        this.setDeltaMovement(vec3);
        this.setYRot((float)(Mth.atan2((double)vec3.x, (double)vec3.z) * 57.2957763671875));
        this.setXRot((float)(Mth.atan2((double)vec3.y, (double)vec3.horizontalDistance()) * 57.2957763671875));
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(OWNER_ID, (Object)0);
    }

    public void tick() {
        super.tick();
        this.setDeltaMovement(this.getDeltaMovement().multiply(0.8, 0.8, 0.8));
        if (this.onGround() && !this.level().isClientSide) {
            Mob mob;
            LivingEntity livingEntity;
            if (!this.prevOnGround) {
                this.closestPet = this.findClosestPetOf(this.getPlayerOwner());
            }
            if ((livingEntity = this.closestPet) instanceof Mob && this.isPetAmbulatory((LivingEntity)(mob = (Mob)livingEntity))) {
                if (this.closestPet.distanceTo((Entity)this) <= this.closestPet.getBbWidth() + 1.0f) {
                    if ((double)this.closestPet.distanceTo((Entity)this) > 0.1) {
                        mob.lookAt((Entity)this, 40.0f, 90.0f);
                        Vec3 move = new Vec3(this.getX() - mob.getX(), this.getY() - mob.getY(), this.getZ() - mob.getZ());
                        mob.setDeltaMovement(mob.getDeltaMovement().add(move.normalize().scale(0.05)));
                    }
                    mob.getNavigation().stop();
                } else {
                    mob.getNavigation().moveTo((Entity)this, 1.0);
                }
            }
        }
        this.prevOnGround = this.onGround();
    }

    private LivingEntity findClosestPetOf(Player owner) {
        LivingEntity closestValid = null;
        for (Entity entity : this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(21.0))) {
            if (!TameableUtils.isTamed(entity) || !TameableUtils.isPetOf(owner, entity) || !this.isPetAmbulatory((LivingEntity)entity) || !((LivingEntity)entity).hasLineOfSight((Entity)this) || closestValid != null && !(this.distanceTo(entity) < this.distanceTo((Entity)closestValid))) continue;
            closestValid = (LivingEntity)entity;
        }
        return closestValid;
    }

    protected boolean canHitEntity(Entity entity) {
        return false;
    }

    protected void onHitEntity(EntityHitResult result) {
    }

    public Entity getOwner() {
        Entity prev = super.getOwner();
        if ((Integer)this.entityData.get(OWNER_ID) != -1) {
            return this.level().getEntity(((Integer)this.entityData.get(OWNER_ID)).intValue());
        }
        return prev;
    }

    public void setOwner(@Nullable Entity owner) {
        super.setOwner(owner);
        this.entityData.set(OWNER_ID, (Object)(owner == null ? -1 : owner.getId()));
    }

    @Nullable
    public Player getPlayerOwner() {
        if (this.level().isClientSide && (Integer)this.entityData.get(OWNER_ID) != -1) {
            Entity entity = this.level().getEntity(((Integer)this.entityData.get(OWNER_ID)).intValue());
            return entity instanceof Player ? (Player)entity : null;
        }
        Entity entity = this.getOwner();
        return entity instanceof Player ? (Player)entity : null;
    }

    public boolean isPetAmbulatory(LivingEntity entity) {
        if (entity instanceof TamableAnimal && (((TamableAnimal)entity).isOrderedToSit() || ((TamableAnimal)entity).isInSittingPose())) {
            return false;
        }
        return !(entity instanceof IComandableMob) || ((IComandableMob)entity).getCommand() != 1;
    }
}

