/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pet_home.server.entity;

import com.github.yzqdev.pet_home.server.misc.PHParticleRegistry;
import com.github.yzqdev.pet_home.server.misc.PHSoundRegistry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class GiantBubbleEntity
extends Entity {
    private static final EntityDataAccessor<Integer> POPS_IN = SynchedEntityData.defineId(GiantBubbleEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public GiantBubbleEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public void tick() {
        super.tick();
        double d = this.isInWater() ? 0.2 : 0.08;
        this.move(MoverType.SELF, new Vec3(0.0, d, 0.0));
        if (this.getPopsIn() <= 0) {
            this.pop();
        } else {
            this.setpopsIn(this.getPopsIn() - 1);
            this.level().addParticle((ParticleOptions)PHParticleRegistry.SIMPLE_BUBBLE.get(), this.getRandomX(1.4f), this.getRandomY(), this.getRandomZ(1.4f), (double)((this.random.nextFloat() - 0.5f) * 0.3f), (double)-0.1f, (double)((this.random.nextFloat() - 0.5f) * 0.3f));
        }
    }

    public void positionRider(Entity entity, Entity.MoveFunction moveFunction) {
        moveFunction.accept(entity, this.getX(), this.getBoundingBox().minY - 0.1, this.getZ());
    }

    public boolean hurt(DamageSource source, float f) {
        if (source.is(DamageTypeTags.IS_PROJECTILE) && f > 0.0f || source.is(DamageTypes.FELL_OUT_OF_WORLD)) {
            this.pop();
            return true;
        }
        return false;
    }

    private void pop() {
        this.playSound((SoundEvent)PHSoundRegistry.GIANT_BUBBLE_POP.get(), 1.0f, 1.5f);
        if (!this.level().isClientSide) {
            ((ServerLevel)this.level()).sendParticles((ParticleOptions)((SimpleParticleType)PHParticleRegistry.GIANT_POP.get()), this.getX(), this.getY() + (double)(this.getBbHeight() * 0.5f), this.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
        }
        this.ejectPassengers();
        this.discard();
    }

    public boolean isNoGravity() {
        return true;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(POPS_IN, (Object)20);
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        this.setpopsIn(tag.getInt("PopsIn"));
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.putInt("PopsIn", this.getPopsIn());
    }

    public int getPopsIn() {
        return (Integer)this.entityData.get(POPS_IN);
    }

    public void setpopsIn(int i) {
        this.entityData.set(POPS_IN, (Object)i);
    }

    public boolean shouldRiderSit() {
        return false;
    }
}

