/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pet_home.server.entity;

import com.github.yzqdev.pet_home.server.PHDataComponents;
import com.github.yzqdev.pet_home.server.entity.PHEntityRegistry;
import com.github.yzqdev.pet_home.server.item.NetItem;
import com.github.yzqdev.pet_home.server.item.PHItemRegistry;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class NetEntity
extends ThrowableItemProjectile {
    private String entityNbt = "itemNbt";
    private ItemStack itemStack = ItemStack.EMPTY;
    private boolean hasItemStack = false;

    public NetEntity(EntityType<? extends ThrowableItemProjectile> entityType, Level world) {
        super(entityType, world);
    }

    public NetEntity(double x, double y, double z, Level world, ItemStack newStack) {
        super((EntityType)PHEntityRegistry.NET_ENTITY.get(), x, y, z, world);
        this.setItemStack(newStack);
    }

    @Nonnull
    protected Item getDefaultItem() {
        if (this.hasItemStack && !this.itemStack.isEmpty()) {
            return NetItem.containsEntity(this.itemStack) ? (Item)PHItemRegistry.NET_HAS_ITEM.get() : (Item)PHItemRegistry.NET_ITEM.get();
        }
        return (Item)PHItemRegistry.NET_ITEM.get();
    }

    protected void onHit(@Nonnull HitResult result) {
        if (this.level().isClientSide || !this.isAlive()) {
            return;
        }
        HitResult.Type type = result.getType();
        boolean containsEntity = NetItem.containsEntity(this.itemStack);
        if (containsEntity) {
            Entity entity = NetItem.getEntityFromStack(this.itemStack, this.level(), true);
            BlockPos pos = type == HitResult.Type.ENTITY ? ((EntityHitResult)result).getEntity().blockPosition() : ((BlockHitResult)result).getBlockPos();
            entity.absMoveTo((double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5, 0.0f, 0.0f);
            this.level().addFreshEntity(entity);
        } else if (type == HitResult.Type.ENTITY) {
            EntityHitResult entityRayTrace = (EntityHitResult)result;
            Entity target = entityRayTrace.getEntity();
            if (!target.isAlive() || !NetItem.canCatchMob(target)) {
                return;
            }
            CompoundTag nbt = NetItem.getNBTfromEntity(target);
            ItemStack newStack = new ItemStack((ItemLike)PHItemRegistry.NET_HAS_ITEM.get());
            newStack.set(PHDataComponents.ENTITY_HOLDER, (Object)nbt);
            ItemEntity itemEntity = this.createDroppedItemAtEntity(target, newStack);
            this.level().addFreshEntity((Entity)itemEntity);
            target.discard();
        } else {
            ItemEntity emptynet = this.createDroppedItemAtEntity((Entity)this, this.itemStack.copy());
            this.level().addFreshEntity((Entity)emptynet);
        }
        this.discard();
    }

    public void setItemStack(ItemStack stack) {
        this.itemStack = stack.copy();
        this.hasItemStack = true;
        this.setItem(this.itemStack);
    }

    protected ItemEntity createDroppedItemAtEntity(Entity entity, ItemStack stack) {
        return new ItemEntity(this.level(), entity.getX(), entity.getY(), entity.getZ(), stack);
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        if (this.hasItemStack) {
            nbt.put(this.entityNbt, this.itemStack.save((HolderLookup.Provider)this.level().registryAccess()));
        }
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.itemStack = (ItemStack)ItemStack.parse((HolderLookup.Provider)this.level().registryAccess(), (Tag)nbt.getCompound("pet_home")).get();
        if (nbt.contains(this.entityNbt, 10)) {
            ItemStack savedStack = (ItemStack)ItemStack.parse((HolderLookup.Provider)this.level().registryAccess(), (Tag)nbt.getCompound(this.entityNbt)).get();
            this.setItemStack(savedStack);
        } else {
            this.hasItemStack = false;
        }
    }
}

