/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pet_home.server.entity;

import com.github.yzqdev.pet_home.server.misc.PHParticleRegistry;
import com.github.yzqdev.pet_home.server.misc.PHSoundRegistry;
import com.github.yzqdev.pet_home.util.TameableUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class PsychicWallEntity
extends Entity {
    protected static final EntityDataAccessor<Direction> DIRECTION = SynchedEntityData.defineId(PsychicWallEntity.class, (EntityDataSerializer)EntityDataSerializers.DIRECTION);
    private static final EntityDataAccessor<Optional<UUID>> CREATOR_UUID = SynchedEntityData.defineId(PsychicWallEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<Integer> CREATOR_ID = SynchedEntityData.defineId(PsychicWallEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> LIFESPAN = SynchedEntityData.defineId(PsychicWallEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> BLOCK_WIDTH = SynchedEntityData.defineId(PsychicWallEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final List<UUID> deflectedArrows = new ArrayList<UUID>();
    private final Map<UUID, Integer> deflectedEntities = new HashMap<UUID, Integer>();
    private int soundLoop = 0;

    public PsychicWallEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public void tick() {
        Entity creator;
        super.tick();
        if (this.tickCount <= 10 || this.getLifespan() <= 10) {
            this.setBoundingBox(this.makeBoundingBox());
        } else {
            if (this.soundLoop % 15 == 0) {
                this.playSound((SoundEvent)PHSoundRegistry.PSYCHIC_WALL.get(), 1.0f, this.random.nextFloat() * 0.3f + 0.9f);
            }
            ++this.soundLoop;
        }
        if (!this.level().isClientSide && this.getCreatorId() != null && (creator = this.getCreator()) != null) {
            this.entityData.set(CREATOR_ID, (Object)creator.getId());
            if (!creator.isAlive() && this.getLifespan() > 20) {
                this.setLifespan(20);
            }
        }
        this.setDeltaMovement(Vec3.ZERO);
        float wX = Math.abs(this.getWallDirection().getStepX());
        float wY = Math.abs(this.getWallDirection().getStepY());
        float wZ = Math.abs(this.getWallDirection().getStepZ());
        AABB collisionAABB = this.getBoundingBox().inflate((double)(wX * 0.25f), (double)(wY * 0.25f), (double)(wZ * 0.25f));
        List colliders = this.level().getEntities((Entity)this, collisionAABB);
        float backISay = this.getWallDirection().getAxis() == Direction.Axis.Y ? -0.6f : -0.1f;
        for (Entity collider : colliders) {
            Vec3 vec31;
            if (this.isSameTeam(collider)) continue;
            collider.push((double)((float)this.getWallDirection().getStepX() * 0.25f), (double)((float)this.getWallDirection().getStepY() * 0.25f), (double)((float)this.getWallDirection().getStepZ() * 0.25f));
            if (this.deflectedEntities.containsKey(collider.getUUID())) continue;
            boolean flag = true;
            if (collider instanceof Projectile) {
                if (this.isFiredByAlly((Projectile)collider)) {
                    flag = false;
                } else {
                    collider.setDeltaMovement(collider.getDeltaMovement().scale((double)backISay));
                    collider.setYRot(collider.getYRot() + 180.0f);
                    collider.setXRot(collider.getXRot() + 180.0f);
                }
            }
            if (!flag) continue;
            this.deflectedEntities.put(collider.getUUID(), 15);
            if (!this.level().isClientSide || !collider.getBoundingBox().intersects(collisionAABB)) continue;
            Vec3 vec3 = new Vec3(collider.getX(), collider.getY(0.5), collider.getZ());
            EntityHitResult entityhitresult = ProjectileUtil.getEntityHitResult((Entity)collider, (Vec3)vec3, (Vec3)(vec31 = collisionAABB.getCenter()), (AABB)collisionAABB, entity -> entity == this, (double)collider.distanceTo((Entity)this));
            Vec3 vec32 = entityhitresult == null || entityhitresult.getType() == HitResult.Type.MISS ? vec3 : entityhitresult.getLocation();
            this.level().addParticle((ParticleOptions)PHParticleRegistry.PSYCHIC_WALL.get(), vec32.x, vec32.y, vec32.z, (double)this.getWallDirection().get3DDataValue(), 0.0, 0.0);
            this.playSound((SoundEvent)PHSoundRegistry.PSYCHIC_WALL_DEFLECT.get(), 1.0f, this.random.nextFloat() * 0.3f + 0.9f);
        }
        if (!this.deflectedEntities.isEmpty()) {
            for (UUID uuid : this.deflectedEntities.keySet()) {
                this.deflectedEntities.put(uuid, this.deflectedEntities.get(uuid) - 1);
            }
            this.deflectedEntities.entrySet().removeIf(e -> (Integer)e.getValue() <= 0);
        }
        if (this.getLifespan() <= 0) {
            this.discard();
        } else {
            this.setLifespan(this.getLifespan() - 1);
        }
    }

    private boolean isFiredByAlly(Projectile projectile) {
        Entity owner = this.getCreator();
        if (owner instanceof LivingEntity && projectile.getOwner() != null) {
            return TameableUtils.hasSameOwnerAs((LivingEntity)owner, projectile.getOwner());
        }
        return false;
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public boolean hurt(DamageSource source, float f) {
        return false;
    }

    public boolean isNoGravity() {
        return true;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(LIFESPAN, (Object)300);
        builder.define(BLOCK_WIDTH, (Object)1);
        builder.define(CREATOR_UUID, Optional.empty());
        builder.define(CREATOR_ID, (Object)-1);
        builder.define(DIRECTION, (Object)Direction.UP);
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        if (tag.contains("Lifespan")) {
            this.setLifespan(tag.getInt("Lifespan"));
        }
        if (tag.hasUUID("CreatorUUID")) {
            this.setCreatorId(tag.getUUID("CreatorUUID"));
        }
        this.setBlockWidth(tag.getInt("BlockWidth"));
        this.setWallDirection(Direction.from3DDataValue((int)tag.getInt("WallDirection")));
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        if (this.getCreatorId() != null) {
            tag.putUUID("CreatorUUID", this.getCreatorId());
        }
        tag.putInt("Lifespan", this.getLifespan());
        tag.putInt("BlockWidth", this.getBlockWidth());
        tag.putInt("WallDirection", this.getWallDirection().get3DDataValue());
    }

    public int getLifespan() {
        return (Integer)this.entityData.get(LIFESPAN);
    }

    public void setLifespan(int i) {
        this.entityData.set(LIFESPAN, (Object)i);
    }

    public int getBlockWidth() {
        return (Integer)this.entityData.get(BLOCK_WIDTH);
    }

    public void setBlockWidth(int i) {
        this.entityData.set(BLOCK_WIDTH, (Object)i);
    }

    public Direction getWallDirection() {
        return (Direction)this.entityData.get(DIRECTION);
    }

    public void setWallDirection(Direction direction) {
        this.entityData.set(DIRECTION, (Object)direction);
    }

    @Nullable
    public UUID getCreatorId() {
        return ((Optional)this.entityData.get(CREATOR_UUID)).orElse(null);
    }

    public void setCreatorId(@Nullable UUID uniqueId) {
        this.entityData.set(CREATOR_UUID, Optional.ofNullable(uniqueId));
    }

    public Entity getCreator() {
        if (!this.level().isClientSide) {
            UUID id = this.getCreatorId();
            if (id != null) {
                return ((ServerLevel)this.level()).getEntity(id);
            }
            return null;
        }
        int id = (Integer)this.entityData.get(CREATOR_ID);
        return id < 0 ? null : this.level().getEntity(id);
    }

    public boolean canCollideWith(Entity entity) {
        return !this.isSameTeam(entity);
    }

    protected AABB makeBoundingBox() {
        Direction direction2 = this.getWallDirection().getOpposite();
        float scale = (float)Math.min(10, Math.min(this.getLifespan(), this.tickCount)) / 10.0f;
        float width = (float)this.getBlockWidth() / 2.0f * scale;
        float minX = -0.15f;
        float minY = -0.15f;
        float minZ = -0.15f;
        float maxX = 0.15f;
        float maxY = 0.15f;
        float maxZ = 0.15f;
        switch (direction2) {
            case NORTH: 
            case SOUTH: {
                minX = -width;
                maxX = width;
                minY = -width;
                maxY = width;
                break;
            }
            case EAST: 
            case WEST: {
                minZ = -width;
                maxZ = width;
                minY = -width;
                maxY = width;
                break;
            }
            case UP: 
            case DOWN: {
                minX = -width;
                maxX = width;
                minZ = -width;
                maxZ = width;
            }
        }
        return new AABB(this.getX() + (double)minX, this.getY() + (double)minY, this.getZ() + (double)minZ, this.getX() + (double)maxX, this.getY() + (double)maxY, this.getZ() + (double)maxZ);
    }

    public void setPos(double p_20210_, double p_20211_, double p_20212_) {
        this.setPosRaw(p_20210_, p_20211_, p_20212_);
        this.setBoundingBox(this.makeBoundingBox());
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> ac) {
        if (DIRECTION.equals(ac) || BLOCK_WIDTH.equals(ac)) {
            this.setBoundingBox(this.makeBoundingBox());
        }
        super.onSyncedDataUpdated(ac);
    }

    public boolean isSameTeam(Entity entity) {
        Entity owner = this.getCreator();
        return owner instanceof LivingEntity && (TameableUtils.hasSameOwnerAs((LivingEntity)owner, entity) || owner.isAlliedTo(entity));
    }
}

