/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pet_home.server.entity;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class RecallBallEntity
extends Entity {
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.defineId(RecallBallEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final EntityDataAccessor<String> CONTAINED_ENTITY_TYPE = SynchedEntityData.defineId(RecallBallEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<CompoundTag> CONTAINED_ENTITY_DATA = SynchedEntityData.defineId(RecallBallEntity.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    private static final EntityDataAccessor<Boolean> OPENED = SynchedEntityData.defineId(RecallBallEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> FINISHED = SynchedEntityData.defineId(RecallBallEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private float prevOpenProgress;
    private float openProgress;

    public RecallBallEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(OWNER_UUID, Optional.empty());
        builder.define(CONTAINED_ENTITY_TYPE, (Object)"minecraft:pig");
        builder.define(CONTAINED_ENTITY_DATA, (Object)new CompoundTag());
        builder.define(OPENED, (Object)false);
        builder.define(FINISHED, (Object)false);
    }

    public InteractionResult interactAt(Player player, Vec3 vec3, InteractionHand hand) {
        return this.interact(player, hand);
    }

    public boolean isPickable() {
        return !this.isFinished();
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (!this.isFinished()) {
            if (this.getOwnerUUID() == null) {
                this.discard();
            } else if (player.getUUID().equals(this.getOwnerUUID()) && !((Boolean)this.entityData.get(OPENED)).booleanValue()) {
                this.playSound(SoundEvents.ENDER_CHEST_OPEN, 1.0f, 1.5f);
                this.entityData.set(OPENED, (Object)true);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void tick() {
        EntityType type;
        super.tick();
        this.setYRot(this.getYRot() + 1.0f);
        this.setXRot(0.0f);
        this.prevOpenProgress = this.openProgress;
        if (this.isInWaterOrBubble() || this.isInLava()) {
            this.setPos(this.position().add(0.0, 0.08, 0.0));
        }
        if (((Boolean)this.entityData.get(OPENED)).booleanValue() && this.openProgress < 1.0f) {
            this.openProgress += 0.1f;
        }
        if (!((Boolean)this.entityData.get(OPENED)).booleanValue() && this.openProgress > 0.0f) {
            this.openProgress -= 0.1f;
        }
        if (this.random.nextFloat() < 0.4f) {
            this.level().addParticle((ParticleOptions)ParticleTypes.PORTAL, this.getRandomX(0.5), this.getRandomY() - 0.25, this.getRandomZ(0.5), (this.random.nextDouble() - 0.5) * 2.0, -this.random.nextDouble(), (this.random.nextDouble() - 0.5) * 2.0);
        }
        if (this.getY() < (double)this.level().getMinBuildHeight()) {
            this.setPos(this.getX(), (float)this.level().getMinBuildHeight() + 1.2f, this.getZ());
        }
        if (((Boolean)this.entityData.get(OPENED)).booleanValue() && this.openProgress >= 1.0f && !this.isFinished() && !this.level().isClientSide && (type = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)this.getContainedEntityType()))) != null) {
            Entity entity = type.create(this.level());
            if (entity instanceof LivingEntity) {
                LivingEntity alive = (LivingEntity)entity;
                alive.readAdditionalSaveData(this.getContainedData());
                alive.setHealth(Math.max(2.0f, alive.getMaxHealth() * 0.25f));
                alive.setYRot(this.random.nextFloat() * 360.0f - 180.0f);
                alive.copyPosition((Entity)this);
                this.level().addFreshEntity((Entity)alive);
            }
            this.entityData.set(FINISHED, (Object)true);
            this.entityData.set(OPENED, (Object)false);
        }
        if (this.isFinished() && this.openProgress <= 0.01f) {
            this.discard();
        }
    }

    public boolean isNoGravity() {
        return true;
    }

    public boolean shouldBeSaved() {
        return !this.isFinished() && super.shouldBeSaved();
    }

    public boolean isFinished() {
        return (Boolean)this.entityData.get(FINISHED);
    }

    protected void readAdditionalSaveData(CompoundTag compoundNBT) {
        UUID uuid;
        if (compoundNBT.hasUUID("Owner")) {
            uuid = compoundNBT.getUUID("Owner");
        } else {
            String s = compoundNBT.getString("Owner");
            uuid = OldUsersConverter.convertMobOwnerIfNecessary((MinecraftServer)this.getServer(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setOwnerUUID(uuid);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.setContainedEntityType(compoundNBT.getString("ContainedEntityType"));
        if (!compoundNBT.getCompound("ContainedData").isEmpty()) {
            this.setContainedData(compoundNBT.getCompound("ContainedData"));
        }
        this.entityData.set(FINISHED, (Object)compoundNBT.getBoolean("Finished"));
    }

    protected void addAdditionalSaveData(CompoundTag compoundNBT) {
        if (this.getOwnerUUID() != null) {
            compoundNBT.putUUID("Owner", this.getOwnerUUID());
        }
        compoundNBT.putString("ContainedEntityType", this.getContainedEntityType());
        compoundNBT.put("ContainedData", (Tag)this.getContainedData());
        compoundNBT.putBoolean("Finished", this.isFinished());
    }

    @Nullable
    public UUID getOwnerUUID() {
        return ((Optional)this.entityData.get(OWNER_UUID)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID uuid) {
        this.entityData.set(OWNER_UUID, Optional.ofNullable(uuid));
    }

    public String getContainedEntityType() {
        return (String)this.entityData.get(CONTAINED_ENTITY_TYPE);
    }

    public void setContainedEntityType(String containedEntityType) {
        this.entityData.set(CONTAINED_ENTITY_TYPE, (Object)containedEntityType);
    }

    public CompoundTag getContainedData() {
        return (CompoundTag)this.entityData.get(CONTAINED_ENTITY_DATA);
    }

    public void setContainedData(CompoundTag containedData) {
        this.entityData.set(CONTAINED_ENTITY_DATA, (Object)containedData);
    }

    public boolean isInvulnerableTo(DamageSource damageSource) {
        return damageSource.isCreativePlayer();
    }

    public float getOpenProgress(float f) {
        return Mth.lerp((float)f, (float)this.prevOpenProgress, (float)this.openProgress);
    }
}

