/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pet_home.server.item;

import com.github.yzqdev.pet_home.PetHomeConfig;
import com.github.yzqdev.pet_home.datagen.LangDefinition;
import com.github.yzqdev.pet_home.server.PHDataComponents;
import com.github.yzqdev.pet_home.server.entity.NetEntity;
import com.github.yzqdev.pet_home.server.item.PHItemRegistry;
import com.github.yzqdev.pet_home.server.item.Type;
import com.github.yzqdev.pet_home.util.ItemMobTooltip;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.common.util.LogicalSidedProvider;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class NetItem
extends Item {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Type type;
    static Set<String> warned;

    public NetItem(Type type) {
        super(new Item.Properties().stacksTo(1));
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    @Nonnull
    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        Level world = context.getLevel();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = context.getItemInHand();
        if (world.isClientSide || !NetItem.containsEntity(stack)) {
            return InteractionResult.FAIL;
        }
        Entity entity = NetItem.getEntityFromStack(stack, world, true);
        BlockPos blockPos = context.getClickedPos();
        entity.absMoveTo((double)blockPos.getX() + 0.5, (double)(blockPos.getY() + 1), (double)blockPos.getZ() + 0.5, 0.0f, 0.0f);
        stack.set(PHDataComponents.ENTITY_HOLDER, null);
        world.addFreshEntity(entity);
        context.getItemInHand().shrink(1);
        if (player.isCreative()) {
            player.setItemInHand(context.getHand(), new ItemStack((ItemLike)PHItemRegistry.NET_ITEM.get()));
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (target.getCommandSenderWorld().isClientSide || target instanceof Player || !target.isAlive() || NetItem.containsEntity(stack)) {
            return InteractionResult.FAIL;
        }
        if (this.type == Type.EMPTY) {
            EntityType entityID = target.getType();
            if (!NetItem.canCatchMob((Entity)target)) {
                return InteractionResult.FAIL;
            }
            ItemStack newStack = new ItemStack((ItemLike)PHItemRegistry.NET_HAS_ITEM.get());
            CompoundTag nbt = NetItem.getNBTfromEntity((Entity)target);
            ItemStack newerStack = newStack.split(1);
            newerStack.set(PHDataComponents.ENTITY_HOLDER, (Object)nbt);
            player.swing(hand);
            player.setItemInHand(hand, newStack);
            if (!player.addItem(newerStack)) {
                ItemEntity itemEntity = new ItemEntity(player.level(), player.getX(), player.getY(), player.getZ(), newerStack);
                player.level().addFreshEntity((Entity)itemEntity);
            }
            target.discard();
            player.getCooldowns().addCooldown((Item)this, 5);
            return InteractionResult.SUCCESS;
        }
        return super.interactLivingEntity(stack, player, target, hand);
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (!entity.isCurrentlyGlowing()) {
            entity.setGlowingTag(true);
        }
        if (!entity.isInvulnerable()) {
            entity.setInvulnerable(true);
        }
        Vec3 position = entity.position();
        int minY = entity.level().getMinBuildHeight();
        if (position.y < (double)minY) {
            entity.setNoGravity(true);
            entity.setDeltaMovement(Vec3.ZERO);
            entity.setPos(position.x, (double)minY, position.z);
        }
        return super.onEntityItemUpdate(stack, entity);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        if (this.type == Type.HAS_MOB) {
            if (NetItem.containsEntity(stack)) {
                CompoundTag holder = NetItem.getEntityData(stack);
                String id = holder.getString("id");
                EntityType type = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)id));
                tooltip.add(type.getDescription());
                tooltip.add((Component)Component.translatable((String)LangDefinition.ConstantMsg.health_text).append(": " + String.format("%.1f", NetItem.getEntityData(stack).getDouble("Health"))));
            }
        } else {
            super.appendHoverText(stack, context, tooltip, tooltipFlag);
            tooltip.add((Component)Component.translatable((String)LangDefinition.ConstantMsg.net_launcher_default_only_tamable).withStyle(ChatFormatting.GRAY));
        }
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        if (this.type == Type.EMPTY) {
            return Optional.empty();
        }
        if (stack.has(PHDataComponents.ENTITY_HOLDER)) {
            CompoundTag tag = (CompoundTag)stack.get(PHDataComponents.ENTITY_HOLDER);
            return Optional.of(new ItemMobTooltip(tag));
        }
        return Optional.empty();
    }

    public static RegistryAccess registryAccess() {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            return ServerLifecycleHooks.getCurrentServer().registryAccess();
        }
        return ((Level)((Optional)LogicalSidedProvider.CLIENTWORLD.get(LogicalSide.CLIENT)).orElseThrow()).registryAccess();
    }

    public static Component getNameFromStoredEntity(ItemStack stack) {
        CompoundTag holder;
        block3: {
            holder = NetItem.getEntityData(stack);
            if (holder.contains("CustomName", 8)) {
                String s = holder.getString("CustomName");
                try {
                    return Component.Serializer.fromJson((String)s, (HolderLookup.Provider)NetItem.registryAccess());
                }
                catch (Exception exception) {
                    if (warned.contains(s)) break block3;
                    LOGGER.warn("Failed to parse entity custom name {}", (Object)s, (Object)exception);
                    warned.add(s);
                }
            }
        }
        String id = holder.getString("id");
        EntityType type = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)id));
        return type.getDescription().copy().withStyle(ChatFormatting.AQUA);
    }

    @Nonnull
    public Component getName(@Nonnull ItemStack stack) {
        Component nameC = super.getName(stack);
        if (!NetItem.containsEntity(stack)) {
            return nameC;
        }
        return ((MutableComponent)nameC).append(" (").append(NetItem.getNameFromStoredEntity(stack)).append(")");
    }

    public NetEntity createNet(Level worldIn, LivingEntity shooter, ItemStack stack) {
        ItemStack newStack = stack.copy();
        newStack.setCount(1);
        return new NetEntity(shooter.getX(), shooter.getY() + 1.25, shooter.getZ(), worldIn, newStack);
    }

    public static boolean containsEntity(ItemStack stack) {
        return stack != null && stack.has(PHDataComponents.ENTITY_HOLDER);
    }

    public static CompoundTag getEntityData(ItemStack stack) {
        return NetItem.containsEntity(stack) ? (CompoundTag)stack.get(PHDataComponents.ENTITY_HOLDER) : new CompoundTag();
    }

    public static String getEntityID(CompoundTag nbt) {
        return nbt.getString("id");
    }

    public static boolean isBlacklisted(EntityType<?> type) {
        return type == EntityType.PLAYER || PetHomeConfig.mobcatcherBlackList.contains(type);
    }

    public static boolean canCatchMob(Entity livingEntity) {
        EntityType type = livingEntity.getType();
        if (PetHomeConfig.mobcatcherOnlyTamableAnimal) {
            return livingEntity instanceof TamableAnimal && !NetItem.isBlacklisted(type);
        }
        return !NetItem.isBlacklisted(type);
    }

    public static Entity getEntityFromNBT(CompoundTag nbt, Level world, boolean withInfo) {
        Entity entity = ((EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)NetItem.getEntityID(nbt)))).create(world);
        if (withInfo) {
            entity.load(nbt);
        }
        return entity;
    }

    public static Entity getEntityFromStack(ItemStack stack, Level world, boolean withInfo) {
        return NetItem.getEntityFromNBT((CompoundTag)stack.get(PHDataComponents.ENTITY_HOLDER), world, withInfo);
    }

    public static CompoundTag getNBTfromEntity(Entity entity) {
        CompoundTag nbt = new CompoundTag();
        entity.save(nbt);
        return nbt;
    }
}

