/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pet_home.server.item;

import com.github.yzqdev.pet_home.datagen.LangDefinition;
import com.github.yzqdev.pet_home.server.PHDataComponents;
import com.github.yzqdev.pet_home.server.entity.NetEntity;
import com.github.yzqdev.pet_home.server.item.NetItem;
import com.github.yzqdev.pet_home.server.item.PHItemRegistry;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class NetLauncherItem
extends Item {
    public static final Component CAPTURE = Component.translatable((String)LangDefinition.ConstantMsg.capturing_text).withStyle(ChatFormatting.GREEN);
    public static final Component RELEASE = Component.translatable((String)LangDefinition.ConstantMsg.release_text).withStyle(ChatFormatting.RED);

    public NetLauncherItem(Item.Properties properties) {
        super(properties);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)LangDefinition.ConstantMsg.net_launcher_tip).withStyle(ChatFormatting.GREEN));
        tooltipComponents.add((Component)Component.translatable((String)LangDefinition.ConstantMsg.net_launcher_default_only_tamable).withStyle(ChatFormatting.GRAY));
    }

    public void releaseUsing(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            int i = this.getUseDuration(stack, (LivingEntity)player) - timeLeft;
            if (i < 0) {
                return;
            }
            float f = NetLauncherItem.getNetVelocity(i);
            if ((double)f >= 0.1) {
                if (!worldIn.isClientSide) {
                    if (NetLauncherItem.isCaptureMode(stack)) {
                        ItemStack netStack = new ItemStack((ItemLike)PHItemRegistry.NET_ITEM.get());
                        Item item = netStack.getItem();
                        if (item instanceof NetItem) {
                            NetItem netItem = (NetItem)item;
                            NetEntity netEntity = netItem.createNet(worldIn, (LivingEntity)player, netStack);
                            netEntity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, f * 3.0f, 0.0f);
                            worldIn.addFreshEntity((Entity)netEntity);
                            stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                        }
                    } else {
                        ItemStack netWithEntityStack = this.findNet(player);
                        if (netWithEntityStack.isEmpty()) {
                            player.sendSystemMessage((Component)Component.translatable((String)LangDefinition.ConstantMsg.no_net_entity_text));
                            return;
                        }
                        Object netEntity = netWithEntityStack.getItem();
                        if (netEntity instanceof NetItem) {
                            NetItem netItem = (NetItem)((Object)netEntity);
                            netEntity = netItem.createNet(worldIn, (LivingEntity)player, netWithEntityStack);
                            netEntity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, f * 3.0f, 0.0f);
                            worldIn.addFreshEntity((Entity)netEntity);
                            stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                            netWithEntityStack.shrink(1);
                        }
                    }
                }
                worldIn.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    @NotNull
    public ItemStack getDefaultInstance() {
        ItemStack stack = new ItemStack((ItemLike)this);
        stack.set(PHDataComponents.RELEASE_MODE, (Object)false);
        return stack;
    }

    public static float getNetVelocity(int charge) {
        float f = (float)charge / 20.0f;
        f = (f * f + f * 2.0f) / 3.0f;
        f = Math.min(f, 1.5f);
        return f;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level worldIn, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isCrouching()) {
            boolean capture = NetLauncherItem.isCaptureMode(stack);
            stack.set(PHDataComponents.RELEASE_MODE, (Object)capture);
            player.displayClientMessage(capture ? RELEASE : CAPTURE, true);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        if (NetLauncherItem.isCaptureMode(stack)) {
            player.startUsingItem(hand);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        player.startUsingItem(hand);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    @Nonnull
    public Component getName(@Nonnull ItemStack stack) {
        MutableComponent base = (MutableComponent)super.getName(stack);
        return base.append(" (").append(NetLauncherItem.isCaptureMode(stack) ? CAPTURE : RELEASE).append(")");
    }

    public static boolean isCaptureMode(ItemStack stack) {
        return !stack.has(PHDataComponents.RELEASE_MODE) || Boolean.FALSE.equals(stack.get(PHDataComponents.RELEASE_MODE));
    }

    protected ItemStack findNet(Player player) {
        ItemStack stack = player.getMainHandItem();
        if (NetLauncherItem.isFilledNet(player.getItemInHand(InteractionHand.OFF_HAND))) {
            return player.getItemInHand(InteractionHand.OFF_HAND);
        }
        if (NetLauncherItem.isFilledNet(player.getItemInHand(InteractionHand.MAIN_HAND))) {
            return player.getItemInHand(InteractionHand.MAIN_HAND);
        }
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack itemstack = player.getInventory().getItem(i);
            if (!NetLauncherItem.isFilledNet(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.EMPTY;
    }

    public static boolean isEmptyNet(ItemStack stack) {
        return stack.getItem() instanceof NetItem && !NetItem.containsEntity(stack);
    }

    public static boolean isFilledNet(ItemStack stack) {
        return stack.getItem() instanceof NetItem && NetItem.containsEntity(stack);
    }
}

