/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pet_home.server.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.ZombieHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.event.EventHooks;

public class RottenAppleItem
extends Item {
    public RottenAppleItem() {
        super(new Item.Properties().food(new FoodProperties.Builder().nutrition(3).saturationModifier(0.3f).effect(() -> new MobEffectInstance(MobEffects.POISON, 100, 1), 1.0f).build()));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltips.pet_home.substitute_rotten_apple.desc").withStyle(ChatFormatting.GREEN));
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        if (entity.getType() == EntityType.HORSE && EventHooks.canLivingConvert((LivingEntity)entity, (EntityType)EntityType.ZOMBIE_HORSE, timer -> {})) {
            player.swing(hand);
            Horse horse = (Horse)entity;
            horse.playSound(SoundEvents.HORSE_DEATH, 0.8f, horse.getVoicePitch());
            horse.playSound(SoundEvents.ZOMBIE_INFECT, 0.8f, horse.getVoicePitch());
            CompoundTag horseExtras = new CompoundTag();
            if (!horse.getBodyArmorItem().isEmpty()) {
                horse.spawnAtLocation(horse.getBodyArmorItem().copy());
                horse.setItemSlot(EquipmentSlot.CHEST, ItemStack.EMPTY);
            }
            horse.addAdditionalSaveData(horseExtras);
            for (int i = 0; i < 6 + horse.getRandom().nextInt(5); ++i) {
                horse.level().addParticle((ParticleOptions)ParticleTypes.SNEEZE, horse.getRandomX(1.0), horse.getRandomY(), horse.getRandomZ(1.0), 0.0, 0.0, 0.0);
            }
            ZombieHorse zombie = (ZombieHorse)EntityType.ZOMBIE_HORSE.create(horse.level());
            if (horse.isLeashed()) {
                zombie.setLeashedTo(horse.getLeashHolder(), true);
            }
            zombie.moveTo(horse.getX(), horse.getY(), horse.getZ(), horse.getYRot(), horse.getXRot());
            zombie.setNoAi(horse.isNoAi());
            zombie.setBaby(horse.isBaby());
            if (horse.hasCustomName()) {
                zombie.setCustomName(horse.getCustomName());
                zombie.setCustomNameVisible(horse.isCustomNameVisible());
            }
            zombie.readAdditionalSaveData(horseExtras);
            zombie.setPersistenceRequired();
            EventHooks.onLivingConvert((LivingEntity)horse, (LivingEntity)zombie);
            player.level().addFreshEntity((Entity)zombie);
            horse.discard();
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }
}

