/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pet_home.server.misc;

import com.github.yzqdev.pet_home.server.misc.LanternRequest;
import com.github.yzqdev.pet_home.server.misc.RespawnRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class PHWorldData
extends SavedData {
    private static final String IDENTIFIER = "pet_home_world_data";
    private final List<RespawnRequest> respawnRequestList = new ArrayList<RespawnRequest>();
    private final List<LanternRequest> lanternRequestList = new ArrayList<LanternRequest>();

    private PHWorldData() {
    }

    public static PHWorldData create() {
        return new PHWorldData();
    }

    public static PHWorldData get(Level world) {
        if (world instanceof ServerLevel) {
            ServerLevel overworld = world.getServer().getLevel(Level.OVERWORLD);
            DimensionDataStorage storage = overworld.getDataStorage();
            PHWorldData data = (PHWorldData)storage.computeIfAbsent(new SavedData.Factory(PHWorldData::create, PHWorldData::load), IDENTIFIER);
            if (data != null) {
                data.setDirty();
            }
            return data;
        }
        return null;
    }

    public static PHWorldData load(CompoundTag nbt, HolderLookup.Provider lookupProvider) {
        CompoundTag innerTag;
        int i;
        ListTag listtag;
        PHWorldData data = new PHWorldData();
        if (nbt.contains("RespawnList")) {
            listtag = nbt.getList("RespawnList", 10);
            for (i = 0; i < listtag.size(); ++i) {
                innerTag = listtag.getCompound(i);
                data.respawnRequestList.add(new RespawnRequest(innerTag.getString("EntityType"), innerTag.getString("DimensionIn"), innerTag.getCompound("EntityData"), new BlockPos(innerTag.getInt("X"), innerTag.getInt("Y"), innerTag.getInt("Z")), innerTag.getLong("Timestamp"), innerTag.getString("EntityNametag")));
            }
        }
        if (nbt.contains("LanternList")) {
            listtag = nbt.getList("LanternList", 10);
            for (i = 0; i < listtag.size(); ++i) {
                innerTag = listtag.getCompound(i);
                data.lanternRequestList.add(new LanternRequest(innerTag.getUUID("PetUUID"), innerTag.getString("EntityType"), innerTag.getUUID("OwnerUUID"), new BlockPos(innerTag.getInt("X"), innerTag.getInt("Y"), innerTag.getInt("Z")), innerTag.getLong("Timestamp"), innerTag.getString("EntityNametag")));
            }
        }
        return data;
    }

    public CompoundTag save(CompoundTag compound, HolderLookup.Provider provider) {
        CompoundTag tag;
        ListTag listTag;
        if (!this.respawnRequestList.isEmpty()) {
            listTag = new ListTag();
            for (RespawnRequest respawnRequest : this.respawnRequestList) {
                tag = new CompoundTag();
                tag.putString("EntityType", respawnRequest.getEntityTypeLoc());
                tag.putString("DimensionIn", respawnRequest.getDimension());
                tag.put("EntityData", (Tag)respawnRequest.getEntityData());
                tag.putInt("X", respawnRequest.getBedPosition().getX());
                tag.putInt("Y", respawnRequest.getBedPosition().getY());
                tag.putInt("Z", respawnRequest.getBedPosition().getZ());
                tag.putLong("Timestamp", respawnRequest.getTimestamp());
                tag.putString("EntityNametag", respawnRequest.getNametag());
                listTag.add((Object)tag);
            }
            compound.put("RespawnList", (Tag)listTag);
        }
        if (!this.lanternRequestList.isEmpty()) {
            listTag = new ListTag();
            for (LanternRequest lanternRequest : this.lanternRequestList) {
                tag = new CompoundTag();
                tag.putUUID("PetUUID", lanternRequest.getPetUUID());
                tag.putString("EntityType", lanternRequest.getEntityTypeLoc());
                tag.putUUID("OwnerUUID", lanternRequest.getOwnerUUID());
                tag.putLong("Timestamp", lanternRequest.getTimestamp());
                tag.putString("EntityNametag", lanternRequest.getNametag());
                tag.putInt("X", lanternRequest.getChunkPosition().getX());
                tag.putInt("Y", lanternRequest.getChunkPosition().getY());
                tag.putInt("Z", lanternRequest.getChunkPosition().getZ());
                listTag.add((Object)tag);
            }
            compound.put("LanternList", (Tag)listTag);
        }
        return compound;
    }

    public void addRespawnRequest(RespawnRequest request) {
        this.respawnRequestList.add(request);
    }

    public void removeRespawnRequest(RespawnRequest request) {
        this.respawnRequestList.remove(request);
    }

    public List<RespawnRequest> getRespawnRequestsFor(Level level, BlockPos pos) {
        ArrayList<RespawnRequest> list = new ArrayList<RespawnRequest>();
        String dimension = level.dimension().toString();
        for (RespawnRequest request : this.respawnRequestList) {
            if (!dimension.equals(request.getDimension()) || !pos.equals((Object)request.getBedPosition())) continue;
            list.add(request);
        }
        return list;
    }

    public void addLanternRequest(LanternRequest request) {
        this.lanternRequestList.add(request);
    }

    public void removeLanternRequest(LanternRequest request) {
        this.lanternRequestList.remove(request);
    }

    public void removeMatchingLanternRequests(UUID reloaded) {
        this.lanternRequestList.removeIf(request -> request.getPetUUID().equals(reloaded));
    }

    public List<LanternRequest> getLanternRequestsFor(UUID uuid) {
        ArrayList<LanternRequest> list = new ArrayList<LanternRequest>();
        for (LanternRequest request : this.lanternRequestList) {
            if (!uuid.equals(request.getOwnerUUID())) continue;
            list.add(request);
        }
        return list;
    }
}

