/*
 * Decompiled with CFR 0.152.
 */
package com.github.yzqdev.pet_home.server.misc.trades;

import com.github.yzqdev.pet_home.datagen.ModTags;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;

public class SellingRandomEnchantedBook
implements VillagerTrades.ItemListing {
    private final int villagerXp;

    public SellingRandomEnchantedBook(int villagerXp) {
        this.villagerXp = villagerXp;
    }

    public MerchantOffer getOffer(Entity trader, RandomSource random) {
        int i;
        ItemStack itemstack;
        Optional optional = trader.level().registryAccess().registryOrThrow(Registries.ENCHANTMENT).getRandomElementOf(ModTags.TradableEnchantmentKey, random);
        if (!optional.isEmpty()) {
            Holder holder = (Holder)optional.get();
            Enchantment enchantment = (Enchantment)holder.value();
            int j = Math.max(enchantment.getMinLevel(), 0);
            int k = Math.min(enchantment.getMaxLevel(), Integer.MAX_VALUE);
            int l = Mth.nextInt((RandomSource)random, (int)j, (int)k);
            itemstack = EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance(holder, l));
            i = 2 + random.nextInt(5 + l * 10) + 3 * l;
            if (holder.is(EnchantmentTags.DOUBLE_TRADE_PRICE)) {
                i *= 2;
            }
            if (i > 64) {
                i = 64;
            }
        } else {
            i = 1;
            itemstack = new ItemStack((ItemLike)Items.BOOK);
        }
        return new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, i), Optional.of(new ItemCost((ItemLike)Items.BOOK)), itemstack, 12, this.villagerXp, 0.2f);
    }
}

